/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.event;

import java.util.Map;
import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderContext;
import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.PivotHeaderTree;
import org.zkoss.pivot.PivotModel;
import org.zkoss.pivot.Pivottable;
import org.zkoss.pivot.impl.util.Texts;
import org.zkoss.pivot.util.Trees;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class PivotUIEvent
extends Event {
    private static final long serialVersionUID = 4921606491027913571L;
    public static final String ON_PIVOT_POPUP = "onPivotPopup";
    public static final String ON_PIVOT_CONTEXT = "onPivotContext";
    public static final String ON_PIVOT_TOOLTIP = "onPivotTooltip";
    public static final String ON_PIVOT_NODE_OPEN = "onPivotNodeOpen";
    private final PivotField.Type _pfType;
    private final PivotHeaderContext _colCtx;
    private final PivotHeaderContext _rowCtx;
    private final PivotField _df;
    private int _x;
    private int _y;
    private boolean _open;

    public PivotUIEvent(String name, Component pivottable, boolean open, PivotField.Type pfType, PivotHeaderContext colContext, PivotHeaderContext rowContext, PivotField dataField) {
        this(name, pivottable, pfType, colContext, rowContext, dataField);
        this._open = open;
    }

    public PivotUIEvent(String name, Component pivottable, int x, int y, PivotField.Type pfType, PivotHeaderContext colContext, PivotHeaderContext rowContext, PivotField dataField) {
        this(name, pivottable, pfType, colContext, rowContext, dataField);
        this._x = x;
        this._y = y;
    }

    private PivotUIEvent(String name, Component pivottable, PivotField.Type pfType, PivotHeaderContext colContext, PivotHeaderContext rowContext, PivotField dataField) {
        super(name, pivottable);
        this._pfType = pfType;
        this._colCtx = colContext;
        this._rowCtx = rowContext;
        this._df = dataField;
    }

    public static final PivotUIEvent getPivotUIEvent(AuRequest request) {
        String command = request.getCommand();
        Component component = request.getComponent();
        PivotModel model = ((Pivottable)component).getModel();
        Map data = request.getData();
        PivotField.Type type = PivotUIEvent.getType((Integer)data.get("t"));
        int di = (Integer)data.get("di");
        PivotField df = di < 0 ? null : model.getFields(PivotField.Type.DATA)[di];
        PivotHeaderContext cctx = PivotUIEvent.getContext(model.getColumnHeaderTree(), (String)data.get("ck"), (Integer)data.get("ci"));
        PivotHeaderContext rctx = PivotUIEvent.getContext(model.getRowHeaderTree(), (String)data.get("rk"), (Integer)data.get("ri"));
        if (AuRequests.getBoolean((Map)data, (String)"opn")) {
            return new PivotUIEvent(command, component, AuRequests.getInt((Map)data, (String)"opn", (int)0) > 0, type, cctx, rctx, df);
        }
        return new PivotUIEvent(command, component, AuRequests.getInt((Map)data, (String)"x", (int)0), AuRequests.getInt((Map)data, (String)"y", (int)0), type, cctx, rctx, df);
    }

    public PivotField.Type getFieldType() {
        return this._pfType;
    }

    public PivotHeaderContext getRowContext() {
        return this._rowCtx;
    }

    public PivotHeaderContext getColumnContext() {
        return this._colCtx;
    }

    public PivotField getDataField() {
        return this._df;
    }

    public boolean isOpen() {
        return this._open;
    }

    public final int getX() {
        return this._x;
    }

    public final int getY() {
        return this._y;
    }

    private static PivotField.Type getType(int typeCode) {
        switch (typeCode) {
            case 0: {
                return PivotField.Type.DATA;
            }
            case 1: {
                return PivotField.Type.ROW;
            }
            case 2: {
                return PivotField.Type.COLUMN;
            }
        }
        return null;
    }

    public static PivotHeaderContext getContext(PivotHeaderTree tree, String key, int dispIndex) {
        if (key == null) {
            return null;
        }
        String[] keys = key.split("%", 2);
        int[] ids = Texts.getRankIndices(keys[0]);
        PivotHeaderNode node = Trees.getNode(tree, ids);
        Calculator cal = keys.length == 1 ? null : Trees.getCalculator(node, Texts.getRankIndex(keys[1]));
        return new PivotHeaderContext(node, cal, dispIndex);
    }
}

