/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.event;

import java.util.Map;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderContext;
import org.zkoss.pivot.PivotModel;
import org.zkoss.pivot.Pivottable;
import org.zkoss.pivot.event.PivotUIEvent;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class PivotColumnResizeEvent
extends Event {
    private static final long serialVersionUID = 1360574320629000L;
    public static final String ON_PIVOT_COLUMN_RESIZE = "onPivotColumnResize";
    private final int _width;
    private final PivotHeaderContext _colContext;
    private final PivotField _df;

    protected PivotColumnResizeEvent(String name, Component target, PivotHeaderContext colContext, PivotField dataField, int width) {
        super(name, target);
        this._width = width;
        this._colContext = colContext;
        this._df = dataField;
    }

    public static final PivotColumnResizeEvent getPivotColumnResizeEvent(AuRequest request) {
        Pivottable comp = (Pivottable)request.getComponent();
        boolean colOrient = "column".equals(comp.getDataFieldOrient());
        PivotModel model = comp.getModel();
        Map data = request.getData();
        int width = (Integer)data.get("wd");
        int ci = (Integer)data.get("ci");
        PivotField[] dfs = model.getFields(PivotField.Type.DATA);
        PivotField df = colOrient && dfs.length > 0 ? dfs[ci % dfs.length] : null;
        PivotHeaderContext cctx = PivotUIEvent.getContext(model.getColumnHeaderTree(), (String)data.get("ck"), ci);
        return new PivotColumnResizeEvent(ON_PIVOT_COLUMN_RESIZE, (Component)comp, cctx, df, width);
    }

    public int getWidth() {
        return this._width;
    }

    public PivotHeaderContext getColumnContext() {
        return this._colContext;
    }

    public PivotField getDataField() {
        return this._df;
    }
}

