/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.util.poi;

import java.util.Map;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.CreationHelper;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.Workbook;

public class StyleFactory {
    public static final short DEFAULT_BOLD_WEIGHT = 400;
    public static final short DEFAULT_COLOR = Short.MAX_VALUE;
    public static final short DEFAULT_FONT_HEIGHT_IN_POINTS = 10;
    public static final String DEFAULT_FONT_NAME = "Arial";
    public static final boolean DEFAULT_ITALIC = false;
    public static final boolean DEFAULT_STRIKEOUT = false;
    public static final short DEFAULT_TYPE_OFFSET = 0;
    public static final byte DEFAULT_UNDERLINE = 0;
    private final Workbook _book;

    public StyleFactory(Workbook book) {
        this._book = book;
    }

    public CellStyle createCellStyle() {
        return this._book.createCellStyle();
    }

    public CellStyle cloneCellStyle(CellStyle source) {
        CellStyle style = this._book.createCellStyle();
        style.cloneStyleFrom(source);
        return style;
    }

    public CellStyle createCellStyle(String dataFormat) {
        CellStyle style = this.createCellStyle();
        style.setDataFormat(this.createDataFormat(dataFormat));
        return style;
    }

    public short createDataFormat(String format) {
        CreationHelper createHelper = this._book.getCreationHelper();
        return createHelper.createDataFormat().getFormat(format);
    }

    public Font getOrCreateFont(Map<FontProperty, Object> properties) {
        if (properties == null) {
            return this.getOrCreateFont((short)400, (short)Short.MAX_VALUE, (short)10, DEFAULT_FONT_NAME, false, false, (short)0, (byte)0);
        }
        short boldWeight = properties.containsKey((Object)FontProperty.BOLD_WEIGHT) ? (short)((Short)properties.get((Object)FontProperty.BOLD_WEIGHT)) : (short)400;
        short color = properties.containsKey((Object)FontProperty.COLOR) ? (short)((Short)properties.get((Object)FontProperty.COLOR)) : (short)Short.MAX_VALUE;
        short fontHeightInPoints = properties.containsKey((Object)FontProperty.HEIGHT) ? (short)((Short)properties.get((Object)FontProperty.HEIGHT)) : (short)10;
        String name = properties.containsKey((Object)FontProperty.NAME) ? (String)properties.get((Object)FontProperty.NAME) : DEFAULT_FONT_NAME;
        boolean italic = properties.containsKey((Object)FontProperty.ITALIC) ? (Boolean)properties.get((Object)FontProperty.ITALIC) : false;
        boolean strikeout = properties.containsKey((Object)FontProperty.STRIKEOUT) ? (Boolean)properties.get((Object)FontProperty.STRIKEOUT) : false;
        short typeOffset = properties.containsKey((Object)FontProperty.TYPE_OFFSET) ? (Short)properties.get((Object)FontProperty.TYPE_OFFSET) : (short)0;
        byte underline = properties.containsKey((Object)FontProperty.UNDERLINE) ? (Byte)properties.get((Object)FontProperty.UNDERLINE) : (byte)0;
        return this.getOrCreateFont(boldWeight, color, fontHeightInPoints, name, italic, strikeout, typeOffset, underline);
    }

    public Font getOrCreateFontWithBoldWeight(short fontBoldWeight) {
        return this.getOrCreateFont(fontBoldWeight, (short)Short.MAX_VALUE, (short)10, DEFAULT_FONT_NAME, false, false, (short)0, (byte)0);
    }

    public Font getOrCreateFontWithColor(short fontColor) {
        return this.getOrCreateFont((short)400, fontColor, (short)10, DEFAULT_FONT_NAME, false, false, (short)0, (byte)0);
    }

    public Font getOrCreateFontWithHeight(short fontHeightInPoints) {
        return this.getOrCreateFont((short)400, (short)Short.MAX_VALUE, fontHeightInPoints, DEFAULT_FONT_NAME, false, false, (short)0, (byte)0);
    }

    public Font getOrCreateFontWithName(String fontName) {
        return this.getOrCreateFont((short)400, (short)Short.MAX_VALUE, (short)10, fontName, false, false, (short)0, (byte)0);
    }

    public Font getOrCreateFontWithItalic(boolean italic) {
        return this.getOrCreateFont((short)400, (short)Short.MAX_VALUE, (short)10, DEFAULT_FONT_NAME, italic, false, (short)0, (byte)0);
    }

    public Font getOrCreateFontWithStrikeout(boolean Strikeout) {
        return this.getOrCreateFont((short)400, (short)Short.MAX_VALUE, (short)10, DEFAULT_FONT_NAME, false, Strikeout, (short)0, (byte)0);
    }

    public Font getOrCreateFontWithTypeOffset(short typeOffset) {
        return this.getOrCreateFont((short)400, (short)Short.MAX_VALUE, (short)10, DEFAULT_FONT_NAME, false, false, typeOffset, (byte)0);
    }

    public Font getOrCreateFontWithUnderline(byte underline) {
        return this.getOrCreateFont((short)400, (short)Short.MAX_VALUE, (short)10, DEFAULT_FONT_NAME, false, false, (short)0, underline);
    }

    public Font getOrCreateFont(short boldWeight, short color, short fontHeightInPoints, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        short fontHeight = (short)(fontHeightInPoints * 20);
        Font font = this._book.findFont(boldWeight, color, fontHeight, name, italic, strikeout, typeOffset, underline);
        if (font == null) {
            font = this.createFont();
            font.setBoldweight(boldWeight);
            font.setColor(color);
            font.setFontHeightInPoints(fontHeightInPoints);
            font.setFontName(name);
            font.setItalic(italic);
            font.setStrikeout(strikeout);
            font.setTypeOffset(typeOffset);
            font.setUnderline(underline);
            return this.createFont();
        }
        return font;
    }

    public Font createFont() {
        return this._book.createFont();
    }

    public static enum FontProperty {
        BOLD_WEIGHT,
        COLOR,
        HEIGHT,
        NAME,
        ITALIC,
        STRIKEOUT,
        TYPE_OFFSET,
        UNDERLINE;

    }
}

