/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRowFields;
import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.GroupHandler;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.impl.StandardCalculator;
import org.zkoss.pivot.impl.TabularPivotField;
import org.zkoss.pivot.util.ExcelUnreadableException;
import org.zkoss.pivot.util.PivotExportCell;
import org.zkoss.pivot.util.PivotExportContext;
import org.zkoss.pivot.util.PivotExportSheetConfig;
import org.zkoss.pivot.util.poi.CellStyleConfigurator;
import org.zkoss.pivot.util.poi.StyleFactory;
import org.zkoss.poi.ss.usermodel.Calculation;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.PivotCache;
import org.zkoss.poi.ss.usermodel.PivotField;
import org.zkoss.poi.ss.usermodel.PivotTable;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.ss.util.ItemInfo;
import org.zkoss.poi.xssf.usermodel.XSSFPivotTable;
import org.zkoss.poi.xssf.usermodel.XSSFSheet;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;
import org.zkoss.zpoiex.ss.usermodel.helpers.PivotTableHelper;

class XSSFExporter {
    private XSSFWorkbook _book;
    private final PivotExportContext _context;
    private final CellStyleConfigurator _styleConfig;
    private HashMap<String, CellStyle> _dataFormatStyleCache = null;
    private LinkedHashMap<String, List<Object>> _rawData;
    private boolean _writeOutputStream = false;
    private StyleFactory _styleFactory;
    private static HashMap<StandardCalculator, PivotField.Item.Type> itemTypeMap;
    private static HashMap<String, Calculation> map;

    private XSSFExporter(PivotExportContext context, CellStyleConfigurator styleConfig, boolean writeOutputStream, XSSFWorkbook book) {
        this._context = context;
        this._styleConfig = styleConfig;
        this._writeOutputStream = writeOutputStream;
        this._book = book;
        if (this._styleConfig != null) {
            this._dataFormatStyleCache = new HashMap();
            this._styleFactory = new StyleFactory((Workbook)this._book);
        }
    }

    XSSFExporter(PivotExportContext context, CellStyleConfigurator styleConfig) {
        this(context, styleConfig, true, new XSSFWorkbook());
    }

    XSSFExporter(XSSFWorkbook book, PivotExportContext context, CellStyleConfigurator styleConfig) {
        this(context, styleConfig, false, book);
    }

    private static LinkedHashMap<String, List<Object>> cloneRawData(Iterable<? extends List<?>> srcData, Iterable<String> columns) {
        LinkedHashMap<String, List<Object>> cache = new LinkedHashMap<String, List<Object>>();
        for (String string : columns) {
            cache.put(string, new ArrayList());
        }
        for (List list : srcData) {
            Iterator<String> iter = cache.keySet().iterator();
            for (Object o : list) {
                String column = iter.next();
                if (o instanceof Number) {
                    cache.get(column).add(((Number)o).doubleValue());
                    continue;
                }
                cache.get(column).add(o);
            }
        }
        return cache;
    }

    private AreaReference writeSourceData(XSSFSheet sheet) {
        PivotField[] fields;
        this._rawData = XSSFExporter.cloneRawData(this._context.getRawData(), this._context.getRawColumns());
        for (PivotField field : fields = this._context.getAllFields()) {
            GroupHandler groupHandler;
            if (field.getType() == PivotField.Type.DATA || (groupHandler = field.getGroupHandler()) == null) continue;
            List<Object> column = this._rawData.get(field.getFieldName());
            ArrayList<Object> newColumn = new ArrayList<Object>(column.size());
            for (Object data : column) {
                newColumn.add(groupHandler.getGroup(data));
            }
            this._rawData.put(field.getFieldName(), newColumn);
        }
        int[] bound = this.writeRawData(this._rawData, sheet, this._styleConfig);
        int rCol = bound[0];
        int bRow = bound[1];
        return new AreaReference(sheet.getSheetName() + "!A1:" + CellReference.convertNumToColString((int)rCol) + (bRow + 1));
    }

    private int[] writeRawData(LinkedHashMap<String, List<Object>> srcData, XSSFSheet sheet, CellStyleConfigurator cellConfigurator) {
        int row = -1;
        int colIdx = 0;
        for (String field : srcData.keySet()) {
            XSSFExporter.getOrCreateCell(0, colIdx, (Sheet)sheet).setCellValue(field);
            List<Object> column = srcData.get(field);
            row = column.size();
            for (int r = 0; r < column.size(); ++r) {
                Object data = column.get(r);
                Cell cell = null;
                if (data instanceof Number) {
                    cell = XSSFExporter.getOrCreateCell(r + 1, colIdx, (Sheet)sheet);
                    cell.setCellValue(((Number)data).doubleValue());
                } else if (data instanceof String) {
                    cell = XSSFExporter.getOrCreateCell(r + 1, colIdx, (Sheet)sheet);
                    cell.setCellValue((String)data);
                } else if (data instanceof Date) {
                    cell = XSSFExporter.getOrCreateCell(r + 1, colIdx, (Sheet)sheet);
                    cell.setCellValue((Date)data);
                } else if (data instanceof Calendar) {
                    cell = XSSFExporter.getOrCreateCell(r + 1, colIdx, (Sheet)sheet);
                    cell.setCellValue(((Calendar)data).getTime());
                }
                if (cell == null) continue;
                this.setDataFormat(cell, field);
            }
            ++colIdx;
        }
        this.setColumnAutoSize(colIdx, sheet);
        return new int[]{--colIdx, row};
    }

    private XSSFPivotTable createPivotTable(AreaReference sourceRef, XSSFSheet sheet) {
        PivotTableHelper pvHelper = new PivotTableHelper();
        PivotCache pivotCache = pvHelper.createPivotCache(sourceRef, (Workbook)sheet.getWorkbook());
        return (XSSFPivotTable)pvHelper.createPivotTable(new CellReference(0, 0), "PivotTable1", pivotCache, (Sheet)sheet);
    }

    private void setDataFormat(Cell cell, String fieldName) {
        String dataFormat;
        if (this._styleConfig != null && fieldName != null && (dataFormat = this._styleConfig.getDataFormat(fieldName)) != null && !dataFormat.isEmpty()) {
            cell.setCellStyle(this.uniqueDataFormatCellStyle(dataFormat));
        }
    }

    private CellStyle uniqueDataFormatCellStyle(String dataFormat) {
        CellStyle dataFormatCellStyle = this._dataFormatStyleCache.get(dataFormat);
        if (dataFormatCellStyle == null) {
            dataFormatCellStyle = this._styleFactory.createCellStyle(dataFormat);
            this._dataFormatStyleCache.put(dataFormat, dataFormatCellStyle);
        }
        return dataFormatCellStyle;
    }

    private void checkIfExcelUnreadable(PivotField[] pfs) throws ExcelUnreadableException {
        Iterable<List<?>> rawdata = this._context.getRawData();
        for (PivotField pf : pfs) {
            TabularPivotField tpf = (TabularPivotField)pf;
            int idx = tpf.getSourceDataIndex();
            HashMap<String, String> map = new HashMap<String, String>();
            for (List<?> row : rawdata) {
                Object obj = row.get(idx);
                if (!(obj instanceof String)) continue;
                String s = (String)obj;
                String key = s.toUpperCase();
                if (!map.keySet().contains(key)) {
                    map.put(key, s);
                    continue;
                }
                if (((String)map.get(key)).equals(s)) continue;
                throw new ExcelUnreadableException(pf, (String)map.get(key), s);
            }
        }
    }

    void export(OutputStream out, boolean open) throws IOException {
        if (this._book == null) {
            this._book = new XSSFWorkbook();
        }
        this.checkIfExcelUnreadable(this._context.getAllFields());
        PivotExportSheetConfig sheetConfig = this._context.getSheetConfig();
        XSSFSheet dataSheet = this._book.createSheet(sheetConfig.getDataSheetName());
        XSSFSheet pivotSheet = this._book.createSheet(sheetConfig.getPivotSheetName());
        if (sheetConfig.getSheetOrder() == PivotExportSheetConfig.SheetOrder.PIVOT_FIRST) {
            this._book.setSheetOrder(pivotSheet.getSheetName(), 0);
        }
        this._book.setSheetHidden(this._book.getSheetIndex((Sheet)dataSheet), sheetConfig.isDataSheetHidden());
        this._book.setSelectedTab(this._book.getSheetIndex((Sheet)pivotSheet));
        this._book.setActiveSheet(this._book.getSheetIndex((Sheet)pivotSheet));
        AreaReference sourceDataRef = this.writeSourceData(dataSheet);
        XSSFPivotTable pivotTable = this.createPivotTable(sourceDataRef, pivotSheet);
        pivotTable.setOutline(true);
        pivotTable.setOutlineData(true);
        if (!this._context.isDataFieldColumnOrient()) {
            pivotTable.setDataOnRows(true);
        }
        Helper helper = new Helper();
        int rbnd = this._context.getSheetHeight();
        int cbnd = this._context.getSheetWidth();
        for (int r = 0; r < rbnd; ++r) {
            for (int c = 0; c < cbnd; ++c) {
                PivotExportCell pc = this._context.getCell(r, c);
                if (pc == null) continue;
                Object key = null;
                Cell cell = null;
                PivotField.Item.Type type = null;
                switch (pc.getType()) {
                    case TITLE_DATA: 
                    case TITLE_COLUMN: 
                    case TITLE_ROW: {
                        XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet).setCellValue(pc.getLabel());
                        break;
                    }
                    case DATA: {
                        Number value;
                        if (helper.isFirstDataCellSet()) {
                            helper.setFirstDataCell(r, c);
                        }
                        if ((value = pc.getValue()) == null) break;
                        cell = XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet);
                        cell.setCellValue(value.doubleValue());
                        this.setDataFormat(cell, pc.getFieldName());
                        break;
                    }
                    case COLUMN: {
                        Double val;
                        Date d;
                        key = pc.getKey();
                        if (key instanceof Date) {
                            d = (Date)key;
                            helper.putColumnItem(r, c, d);
                            cell = XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet);
                            cell.setCellValue(d);
                            this.setDataFormat(cell, pc.getFieldName());
                            break;
                        }
                        if (key instanceof Number) {
                            val = ((Number)key).doubleValue();
                            helper.putColumnItem(r, c, val);
                            XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet).setCellValue(val.doubleValue());
                            break;
                        }
                        helper.putColumnItem(r, c, key == null ? null : pc.getLabel());
                        XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet).setCellValue(pc.getLabel());
                        break;
                    }
                    case COLUMN_SUBTOTAL: {
                        type = XSSFExporter.getPivotFieldItemTypeMap().get(pc.getCalcuator());
                        if (type == null) {
                            throw new IllegalArgumentException("Expecting type of PivotField.Item.Type");
                        }
                        cell = XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet);
                        cell.setCellValue(pc.getLabel());
                        helper.putColumnItem(r, c, pc.getKey(), type);
                        break;
                    }
                    case COLUMN_DATA: {
                        helper.setContainsColumnData(true);
                        helper.putColumnItem(r, c, pc.getLabel());
                        XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet).setCellValue(pc.getLabel());
                        break;
                    }
                    case COLUMN_GRAND_TOTAL: {
                        helper.addColumnGrandTotal(pc.getLabel());
                        XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet).setCellValue(pc.getLabel());
                        break;
                    }
                    case ROW: {
                        Double val;
                        Date d;
                        key = pc.getKey();
                        if (key instanceof Date) {
                            d = (Date)key;
                            helper.putRowItem(r, c, d);
                            cell = XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet);
                            cell.setCellValue(d);
                            this.setDataFormat(cell, pc.getFieldName());
                            break;
                        }
                        if (key instanceof Number) {
                            val = ((Number)key).doubleValue();
                            helper.putRowItem(r, c, val);
                            XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet).setCellValue(val.doubleValue());
                            break;
                        }
                        helper.putRowItem(r, c, key == null ? null : pc.getLabel());
                        XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet).setCellValue(pc.getLabel());
                        break;
                    }
                    case ROW_SUBTOTAL: {
                        type = XSSFExporter.getPivotFieldItemTypeMap().get(pc.getCalcuator());
                        if (type == null) {
                            throw new IllegalArgumentException("Expecting type of PivotField.Item.Type");
                        }
                        cell = XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet);
                        cell.setCellValue(pc.getLabel());
                        helper.putRowItem(r, c, pc.getKey(), type);
                        break;
                    }
                    case ROW_DATA: {
                        helper.setContainsRowData(true);
                        helper.putRowItem(r, c, pc.getLabel());
                        XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet).setCellValue(pc.getLabel());
                        break;
                    }
                    case ROW_GRAND_TOTAL: {
                        helper.addRowGrandTotal(pc.getLabel());
                        XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet).setCellValue(pc.getLabel());
                    }
                }
                if (this._styleConfig == null || this._styleFactory == null) continue;
                this._styleConfig.config(pc.getType(), XSSFExporter.getOrCreateCell(r, c, (Sheet)pivotSheet), this._styleFactory);
            }
        }
        pivotTable.setFirstData(helper.getFirstDataRow(), helper.getFirstDataColumn());
        if (!this._context.isDataFieldColumnOrient()) {
            PivotField[] rowFields = this._context.getRowFields();
            int r = this._context.getColumnFields().length;
            for (int i = 0; i < rowFields.length; ++i) {
                String str = rowFields[i].getFieldName();
                XSSFExporter.getOrCreateCell(r, i + 1, (Sheet)pivotSheet).setCellValue(str);
            }
        }
        List<List<ItemInfo>> rowItems = helper.buildRowItems();
        List<List<ItemInfo>> colItems = helper.buildColumnItems();
        this.setupDataFields((PivotTable)pivotTable);
        LinkedHashMap<PivotField, TreeSet<Object>> itemsInfo = this.prepareItemsInfo();
        this.setupRowFields(itemsInfo, rowItems, pivotTable, open);
        pivotTable.setRowItems(rowItems);
        this.setupColumnFields(itemsInfo, colItems, pivotTable, open);
        pivotTable.setColumnItems(colItems);
        pivotTable.setLocationRef(new AreaReference("A1:" + new CellReference(this._context.getSheetHeight() - 1, this._context.getSheetWidth() - 1).formatAsString()));
        if (this._context.getSheetConfig().isColumnAutoSize()) {
            this.setColumnAutoSize(this._context.getSheetWidth(), pivotSheet);
        }
        if (this._writeOutputStream) {
            this._book.write(out);
            out.flush();
        }
    }

    private void setupColumnFields(LinkedHashMap<PivotField, TreeSet<Object>> itemsInfo, List<List<ItemInfo>> colItems, XSSFPivotTable pivotTable, boolean open) {
        PivotField[] columnFields;
        for (PivotField tf : columnFields = this._context.getColumnFields()) {
            org.zkoss.poi.ss.usermodel.PivotField poiField = pivotTable.getPivotField(tf.getFieldName());
            XSSFExporter.setupSubtotals(tf.getSubtotals(), poiField);
            XSSFExporter.setupItems(itemsInfo.get(tf), tf, poiField, open);
            pivotTable.setColumnField(poiField);
        }
        PivotField[] dataFields = this._context.getDataFields();
        if (this._context.isDataFieldColumnOrient() && dataFields != null && dataFields.length > 1) {
            CTField last;
            CTColFields ctColFields = pivotTable.getCTColFields();
            List fieldList = ctColFields.getFieldList();
            if (fieldList != null && fieldList.size() > 0 && (last = (CTField)fieldList.get(fieldList.size() - 1)).getX() == -2) {
                return;
            }
            ctColFields.addNewField().setX(-2);
            ctColFields.setCount((long)ctColFields.getFieldList().size());
        }
    }

    private void setupRowFields(LinkedHashMap<PivotField, TreeSet<Object>> itemsInfo, List<List<ItemInfo>> rowItems, XSSFPivotTable pivotTable, boolean open) {
        PivotField[] rowFields;
        for (PivotField tf : rowFields = this._context.getRowFields()) {
            String fieldName = tf.getFieldName();
            org.zkoss.poi.ss.usermodel.PivotField poiField = pivotTable.getPivotField(fieldName);
            poiField.setOutline(false);
            XSSFExporter.setupSubtotals(tf.getSubtotals(), poiField);
            XSSFExporter.setupItems(itemsInfo.get(tf), tf, poiField, open);
            pivotTable.setRowField(poiField);
        }
        PivotField[] dataFields = this._context.getDataFields();
        if (!this._context.isDataFieldColumnOrient() && dataFields != null && dataFields.length > 1) {
            CTField last;
            CTRowFields ctRowFields = pivotTable.getCTRowFields();
            List fieldList = ctRowFields.getFieldList();
            if (fieldList != null && fieldList.size() > 0 && (last = (CTField)fieldList.get(fieldList.size() - 1)).getX() == -2) {
                return;
            }
            ctRowFields.addNewField().setX(-2);
            ctRowFields.setCount((long)ctRowFields.getFieldList().size());
        }
    }

    private static void setupItems(TreeSet<Object> items, PivotField tpf, org.zkoss.poi.ss.usermodel.PivotField poiField, boolean open) {
        ArrayList<Object> list = new ArrayList<Object>(items);
        Calculator[] subtotals = tpf.getSubtotals();
        if (subtotals != null) {
            for (Calculator c : subtotals) {
                PivotField.Item.Type type = XSSFExporter.getPivotFieldItemTypeMap().get(c);
                if (type == null) continue;
                list.add(type);
            }
        }
        poiField.setItems(list);
        if (!open) {
            for (PivotField.Item item : poiField.getItems()) {
                item.setShowDetail(false);
            }
        }
    }

    private static void initPivotFieldItemMap() {
        itemTypeMap = new HashMap();
        itemTypeMap.put(StandardCalculator.SUM, PivotField.Item.Type.SUM);
        itemTypeMap.put(StandardCalculator.SUM_OR_COUNT, PivotField.Item.Type.DEFAULT);
        itemTypeMap.put(StandardCalculator.COUNT, PivotField.Item.Type.COUNT);
        itemTypeMap.put(StandardCalculator.AVERAGE, PivotField.Item.Type.AVERAGE);
        itemTypeMap.put(StandardCalculator.MAX, PivotField.Item.Type.MAX);
        itemTypeMap.put(StandardCalculator.MIN, PivotField.Item.Type.MIN);
        itemTypeMap.put(StandardCalculator.COUNT_NUMBER, PivotField.Item.Type.COUNT_NUMS);
        itemTypeMap.put(StandardCalculator.STD_DEV, PivotField.Item.Type.STD_DEV);
        itemTypeMap.put(StandardCalculator.STD_DEV_P, PivotField.Item.Type.STD_DEV_P);
        itemTypeMap.put(StandardCalculator.VARIANCE, PivotField.Item.Type.VARIANCE);
        itemTypeMap.put(StandardCalculator.VARIANCE_P, PivotField.Item.Type.VARIANCE_P);
    }

    private static HashMap<StandardCalculator, PivotField.Item.Type> getPivotFieldItemTypeMap() {
        if (itemTypeMap == null) {
            XSSFExporter.initPivotFieldItemMap();
        }
        return itemTypeMap;
    }

    private LinkedHashMap<PivotField, TreeSet<Object>> prepareItemsInfo() {
        PivotField[] fields;
        LinkedHashMap<PivotField, TreeSet<Object>> itemsInfo = new LinkedHashMap<PivotField, TreeSet<Object>>();
        for (PivotField tpf : fields = this._context.getAllFields()) {
            if (!(tpf instanceof TabularPivotField)) {
                throw new IllegalArgumentException("Expecting TabularPivotField");
            }
            TreeSet<Object> set = new TreeSet<Object>(((TabularPivotField)tpf).getComparator());
            set.addAll((Collection<Object>)this._rawData.get(tpf.getFieldName()));
            itemsInfo.put(tpf, set);
        }
        return itemsInfo;
    }

    private static void setupSubtotals(Calculator[] calculator, org.zkoss.poi.ss.usermodel.PivotField poiField) {
        if (calculator == null) {
            poiField.setDefaultSubtotal(false);
            return;
        }
        HashSet<Calculation> set = new HashSet<Calculation>();
        for (Calculator c : calculator) {
            if (!(c instanceof StandardCalculator)) {
                throw new IllegalArgumentException("Expecting StandardCalculator");
            }
            Calculation calculation = XSSFExporter.getCalculationMap().get(((StandardCalculator)c).getLabel());
            if (calculation == null) continue;
            set.add(calculation);
        }
        poiField.setSubtotals(set);
    }

    private void setupDataFields(PivotTable pivotTable) {
        PivotField[] dataPF = this._context.getDataFields();
        for (int i = 0; i < dataPF.length; ++i) {
            PivotField pf = dataPF[i];
            org.zkoss.poi.ss.usermodel.PivotField poiField = pivotTable.getPivotField(pf.getFieldName());
            Calculator summary = pf.getSummary();
            if (!(summary instanceof StandardCalculator)) {
                throw new IllegalArgumentException("Expecting StandardCalculator");
            }
            pivotTable.setDataField(poiField, pf.getFieldName(), XSSFExporter.getCalculationMap().get(((StandardCalculator)summary).getLabel()));
        }
    }

    private static void initCalculationMap() {
        map = new HashMap();
        map.put(StandardCalculator.SUM.getLabel(), Calculation.SUM);
        map.put(StandardCalculator.SUM_OR_COUNT.getLabel(), Calculation.SUM);
        map.put(StandardCalculator.COUNT.getLabel(), Calculation.COUNT);
        map.put(StandardCalculator.AVERAGE.getLabel(), Calculation.AVERAGE);
        map.put(StandardCalculator.MAX.getLabel(), Calculation.MAX);
        map.put(StandardCalculator.MIN.getLabel(), Calculation.MIN);
        map.put(StandardCalculator.COUNT_NUMBER.getLabel(), Calculation.COUNT_NUMS);
        map.put(StandardCalculator.STD_DEV.getLabel(), Calculation.STD_DEV);
        map.put(StandardCalculator.STD_DEV_P.getLabel(), Calculation.STD_DEV_P);
        map.put(StandardCalculator.VARIANCE.getLabel(), Calculation.VARIANCE);
        map.put(StandardCalculator.VARIANCE_P.getLabel(), Calculation.VARIANCE_P);
    }

    private static HashMap<String, Calculation> getCalculationMap() {
        if (map == null) {
            XSSFExporter.initCalculationMap();
        }
        return map;
    }

    private void setColumnAutoSize(int rCol, XSSFSheet sheet) {
        if (this._context.getSheetConfig().isColumnAutoSize()) {
            for (int c = 0; c < rCol; ++c) {
                sheet.autoSizeColumn(c, true);
            }
        }
    }

    private static Row getOrCreateRow(int row, Sheet sheet) {
        Row r = sheet.getRow(row);
        if (r == null) {
            return sheet.createRow(row);
        }
        return r;
    }

    private static Cell getOrCreateCell(int row, int col, Sheet sheet) {
        Row r = XSSFExporter.getOrCreateRow(row, sheet);
        Cell cell = r.getCell(col);
        if (cell == null) {
            return r.createCell(col);
        }
        return cell;
    }

    class ItemWrapper {
        Object val;
        PivotField.Item.Type type;

        ItemWrapper(Object val, PivotField.Item.Type type) {
            this.val = val;
            this.type = type;
        }
    }

    private class Helper {
        int _firstDataRow = -1;
        int _firstDataCol = -1;
        TreeMap<Integer, HashMap<Integer, ItemWrapper>> rowItems = new TreeMap();
        TreeMap<Integer, HashMap<Integer, ItemWrapper>> colItems = new TreeMap();
        ArrayList<String> _rowGrandTotal;
        ArrayList<String> _columnGrandTotal;
        boolean _containsRowData;
        boolean _containsColumnData;

        private Helper() {
        }

        boolean isFirstDataCellSet() {
            return this._firstDataRow < 0 || this._firstDataCol < 0;
        }

        int getFirstDataRow() {
            return this._firstDataRow;
        }

        int getFirstDataColumn() {
            return this._firstDataCol;
        }

        public void setContainsRowData(boolean b) {
            this._containsRowData = b;
        }

        boolean isContainsRowData() {
            return this._containsRowData;
        }

        public void setContainsColumnData(boolean b) {
            this._containsColumnData = b;
        }

        boolean isContainsColumnData() {
            return this._containsColumnData;
        }

        void setFirstDataCell(int row, int col) {
            this._firstDataRow = row;
            this._firstDataCol = col;
        }

        void putRowItem(int row, int col, Object val) {
            this.getRowItemMap(row).put(col, new ItemWrapper(val, PivotField.Item.Type.DATA));
        }

        void putRowItem(int row, int col, Object val, PivotField.Item.Type type) {
            this.getRowItemMap(row).put(col, new ItemWrapper(val, type));
        }

        private HashMap<Integer, ItemWrapper> getRowItemMap(int row) {
            HashMap<Integer, ItemWrapper> map = this.rowItems.get(row);
            if (map == null) {
                map = new HashMap();
                this.rowItems.put(row, map);
            }
            return map;
        }

        void putColumnItem(int row, int col, Object val) {
            this.getColumnItemMap(col).put(row, new ItemWrapper(val, PivotField.Item.Type.DATA));
        }

        void putColumnItem(int row, int col, Object val, PivotField.Item.Type type) {
            this.getColumnItemMap(col).put(row, new ItemWrapper(val, type));
        }

        private HashMap<Integer, ItemWrapper> getColumnItemMap(int col) {
            HashMap<Integer, ItemWrapper> map = this.colItems.get(col);
            if (map == null) {
                map = new HashMap();
                this.colItems.put(col, map);
            }
            return map;
        }

        public void addColumnGrandTotal(String label) {
            if (this._columnGrandTotal == null) {
                this._columnGrandTotal = new ArrayList();
            }
            this._columnGrandTotal.add(label);
        }

        List<List<ItemInfo>> buildColumnItems() {
            int size = this.getColumnItemSize();
            ArrayList<List<ItemInfo>> lists = new ArrayList<List<ItemInfo>>();
            block0: for (Integer col : this.colItems.keySet()) {
                ArrayList<ItemInfo> list = new ArrayList<ItemInfo>(size);
                lists.add(list);
                HashMap<Integer, ItemWrapper> map = this.colItems.get(col);
                for (int r = 1; r < size + 1; ++r) {
                    ItemWrapper wrap = map.get(r);
                    if (this.isContainsColumnData() && r == size) {
                        list.add(new ItemInfo(wrap.type, wrap.val, -2));
                    } else if (wrap != null) {
                        list.add(new ItemInfo(wrap.type, wrap.val, r));
                    } else {
                        list.add(null);
                    }
                    if (wrap != null && wrap.type != PivotField.Item.Type.DATA) continue block0;
                }
            }
            if (this._columnGrandTotal != null) {
                for (int i = 0; i < this._columnGrandTotal.size(); ++i) {
                    String str = this._columnGrandTotal.get(i);
                    ArrayList<ItemInfo> infos = new ArrayList<ItemInfo>();
                    infos.add(new ItemInfo(PivotField.Item.Type.GRAND, (Object)str, 0, i));
                    lists.add(infos);
                }
            }
            return lists;
        }

        public void addRowGrandTotal(String label) {
            if (this._rowGrandTotal == null) {
                this._rowGrandTotal = new ArrayList();
            }
            this._rowGrandTotal.add(label);
        }

        List<List<ItemInfo>> buildRowItems() {
            int rowItemSize = this.getRowItemSize();
            ArrayList<List<ItemInfo>> lists = new ArrayList<List<ItemInfo>>();
            block0: for (Integer row : this.rowItems.keySet()) {
                ArrayList<ItemInfo> list = new ArrayList<ItemInfo>(rowItemSize);
                lists.add(list);
                HashMap<Integer, ItemWrapper> map = this.rowItems.get(row);
                for (int c = 0; c < rowItemSize; ++c) {
                    ItemWrapper wrap = map.get(c);
                    if (this.isContainsRowData() && c == rowItemSize - 1) {
                        list.add(new ItemInfo(wrap.type, wrap.val, -2));
                    } else if (wrap != null) {
                        list.add(new ItemInfo(wrap.type, wrap.val, c));
                    } else {
                        list.add(null);
                    }
                    if (wrap != null && wrap.type != PivotField.Item.Type.DATA) continue block0;
                }
            }
            if (this._rowGrandTotal != null) {
                for (int i = 0; i < this._rowGrandTotal.size(); ++i) {
                    String str = this._rowGrandTotal.get(i);
                    ArrayList<ItemInfo> infos = new ArrayList<ItemInfo>();
                    infos.add(new ItemInfo(PivotField.Item.Type.GRAND, (Object)str, 0, i));
                    lists.add(infos);
                }
            }
            return lists;
        }

        private int getColumnItemSize() {
            PivotField[] columnFields = XSSFExporter.this._context.getColumnFields();
            PivotField[] dataFields = XSSFExporter.this._context.getDataFields();
            return XSSFExporter.this._context.isDataFieldColumnOrient() ? columnFields.length + (dataFields.length > 1 ? 1 : 0) : columnFields.length;
        }

        private int getRowItemSize() {
            PivotField[] rowFields = XSSFExporter.this._context.getRowFields();
            PivotField[] dataFields = XSSFExporter.this._context.getDataFields();
            return XSSFExporter.this._context.isDataFieldColumnOrient() ? rowFields.length : rowFields.length + (dataFields.length > 1 ? 1 : 0);
        }
    }
}

