/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class PivotModels {
    public static <T> Iterable<T> filter(final Iterable<? extends T> iterable, final Filter<T> filter) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new FilterIterator(iterable.iterator(), filter);
            }
        };
    }

    private static class FilterIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> _iter;
        private final Filter<T> _filter;
        private T _next;

        public FilterIterator(Iterator<? extends T> iter, Filter<T> filter) {
            this._iter = iter;
            this._filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (this._next == null) {
                this.loadNext();
            }
            return this._next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T item = this._next;
            this._next = null;
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void loadNext() {
            while (this._iter.hasNext()) {
                T item = this._iter.next();
                if (!this._filter.keep(item)) continue;
                this._next = item;
                return;
            }
        }
    }

    public static interface Filter<T> {
        public boolean keep(T var1);
    }
}

