/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderTree;
import org.zkoss.pivot.PivotModel;
import org.zkoss.pivot.PivotRenderer;
import org.zkoss.pivot.Pivottable;
import org.zkoss.pivot.impl.SimplePivotRenderer;
import org.zkoss.pivot.impl.TabularPivotModel;
import org.zkoss.pivot.impl.util.DataCellTraverser;
import org.zkoss.pivot.impl.util.ExportDataCellFiller;
import org.zkoss.pivot.impl.util.ExportHeaderCellFiller;
import org.zkoss.pivot.impl.util.HeaderSizeInfo;
import org.zkoss.pivot.impl.util.HeaderTraverser;
import org.zkoss.pivot.impl.util.PagingInfo;
import org.zkoss.pivot.util.PivotExportCell;
import org.zkoss.pivot.util.PivotExportContext;
import org.zkoss.pivot.util.PivotExportSheetConfig;
import org.zkoss.pivot.util.XSSFExporter;
import org.zkoss.pivot.util.poi.CellStyleConfigurator;
import org.zkoss.pivot.util.poi.StyleFactory;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.ss.util.CellRangeAddress;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;

public class Exports {
    public static final String XLSX = "xlsx";
    public static final String XLSX_STATIC = "xlsx.static";
    public static final String XLS = "xls";
    public static final String DEFAULT_FORMAT = Library.getProperty((String)"org.zkoss.pivot.export.format", (String)"xlsx");

    public static void exportExcel(OutputStream out, PivotExportContext context) throws IOException {
        Exports.exportExcel(out, DEFAULT_FORMAT, context);
    }

    public static void exportExcel(OutputStream out, String fileFormat, PivotExportContext context) throws IOException {
        Exports.exportExcel(out, fileFormat, context, (CellStyleConfigurator)new DefaultCellStyleConfigurator());
    }

    public static void exportExcel(OutputStream out, Workbook book, PivotExportContext context) throws IOException {
        Exports.exportExcel(out, book, context, (CellStyleConfigurator)new DefaultCellStyleConfigurator());
    }

    public static void exportExcel(OutputStream out, String fileFormat, PivotExportContext context, CellStyleConfigurator styleConfig) throws IOException {
        String string = fileFormat = Strings.isEmpty((String)fileFormat) ? DEFAULT_FORMAT.toLowerCase() : fileFormat.toLowerCase();
        if (XLS.equals(fileFormat)) {
            Exports.writeWorkbook(out, (Workbook)new HSSFWorkbook(), context, styleConfig, true);
        } else if (XLSX_STATIC.equals(fileFormat)) {
            Exports.writeWorkbook(out, (Workbook)new XSSFWorkbook(), context, styleConfig, true);
        } else if (XLSX.equals(fileFormat)) {
            XSSFExporter exporter = new XSSFExporter(context, styleConfig);
            exporter.export(out, context.isOpen());
        } else {
            throw new IllegalArgumentException("Illegal file format: " + fileFormat);
        }
    }

    public static void exportExcel(OutputStream out, Workbook book, PivotExportContext context, CellStyleConfigurator styleConfig) throws IOException {
        if (book == null) {
            Exports.exportExcel(out, DEFAULT_FORMAT, context, styleConfig);
            return;
        }
        if (book instanceof XSSFWorkbook) {
            XSSFExporter exporter = new XSSFExporter((XSSFWorkbook)book, context, styleConfig);
            exporter.export(out, context.isOpen());
        } else if (book instanceof HSSFWorkbook) {
            Exports.writeWorkbook(out, book, context, styleConfig, false);
        } else {
            throw new IllegalArgumentException("Illegal Workbook format: " + book);
        }
    }

    private static void writeWorkbook(OutputStream out, Workbook book, PivotExportContext context, CellStyleConfigurator styleConfig, boolean writeOutputStream) throws IOException {
        Sheet sheet = book.createSheet(context.getSheetConfig().getDataSheetName());
        int rbnd = context.getSheetHeight();
        int cbnd = context.getSheetWidth();
        int eRowIndex = 0;
        StyleFactory styleFactory = styleConfig != null ? new StyleFactory(book) : null;
        for (int r = 0; r < rbnd; ++r) {
            Row eRow = sheet.createRow(eRowIndex++);
            for (int c = 0; c < cbnd; ++c) {
                PivotExportCell pec = context.getCell(r, c);
                if (pec == null) continue;
                Cell eCell = eRow.createCell(c);
                PivotExportCell.Type pecType = pec.getType();
                switch (pecType) {
                    case DATA: {
                        Number value = pec.getValue();
                        if (value != null) {
                            eCell.setCellValue(value.doubleValue());
                            break;
                        }
                        if (pec.getLabel() == null) break;
                        eCell.setCellValue(pec.getLabel());
                        break;
                    }
                    default: {
                        String label = pec.getLabel();
                        eCell.setCellValue(label);
                        int rspan = pec.getRowSpan();
                        int cspan = pec.getColumnSpan();
                        if (rspan <= 1 && cspan <= 1) break;
                        sheet.addMergedRegion(new CellRangeAddress(r, r + rspan - 1, c, c + cspan - 1));
                    }
                }
                if (styleConfig == null || styleFactory == null) continue;
                styleConfig.config(pecType, eCell, styleFactory);
            }
        }
        if (context.getSheetConfig().isColumnAutoSize()) {
            for (int c = 0; c < cbnd; ++c) {
                sheet.autoSizeColumn(c, true);
            }
        }
        if (writeOutputStream) {
            book.write(out);
            out.flush();
        }
    }

    public static void exportCSV(OutputStream out, PivotExportContext context) throws IOException {
        Exports.exportCSV(out, context, ",");
    }

    public static void exportCSV(OutputStream out, PivotExportContext context, String separator) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        int rbnd = context.getSheetHeight();
        int cbnd = context.getSheetWidth();
        PivotExportCell dt = context.getTitleCell(PivotExportCell.Type.TITLE_DATA);
        PivotExportCell ct = context.getTitleCell(PivotExportCell.Type.TITLE_COLUMN);
        boolean skipFirstRow = !(dt != null && !Strings.isBlank((String)dt.getLabel()) || ct != null && !Strings.isBlank((String)ct.getLabel()));
        try {
            int r;
            int n = r = skipFirstRow ? 1 : 0;
            while (r < rbnd) {
                for (int c = 0; c < cbnd; ++c) {
                    PivotExportCell cell = context.getCell(r, c);
                    if (cell != null) {
                        if (cell.getType() == PivotExportCell.Type.DATA) {
                            Number n2 = cell.getValue();
                            if (n2 != null) {
                                writer.append("" + n2.doubleValue());
                            }
                        } else {
                            String v = cell.getLabel();
                            if (!Strings.isEmpty((String)v)) {
                                writer.append(v);
                            }
                        }
                    }
                    if (c == cbnd - 1) continue;
                    writer.append(separator);
                }
                writer.newLine();
                ++r;
            }
            writer.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static PivotExportContext getExportContext(Pivottable table, boolean open, String[] titles) {
        return Exports.getExportContext(table, open, titles, false);
    }

    public static PivotExportContext getExportContext(Pivottable table, boolean open, String[] titles, boolean useRendererForDataCells) {
        return Exports.getExportContext(table, table.getModel(), table.getPivotRenderer(), table.getDataFieldOrient(), open, titles, useRendererForDataCells, PivotExportSheetConfig.DEFAULT_SHEET_CONFIG);
    }

    public static PivotExportContext getExportContext(Pivottable table, boolean open, String[] titles, boolean useRendererForDataCells, PivotExportSheetConfig sheetConfig) {
        return Exports.getExportContext(table, table.getModel(), table.getPivotRenderer(), table.getDataFieldOrient(), open, titles, useRendererForDataCells, sheetConfig);
    }

    public static PivotExportContext getExportContext(PivotModel model, PivotRenderer renderer, String dataFieldOrient, boolean open, String[] titles) {
        return Exports.getExportContext(model, renderer, dataFieldOrient, open, titles, false);
    }

    public static PivotExportContext getExportContext(PivotModel model, PivotRenderer renderer, String dataFieldOrient, boolean open, String[] titles, boolean useRendererForDataCells) {
        return Exports.getExportContext(null, model, renderer, dataFieldOrient, open, titles, useRendererForDataCells, PivotExportSheetConfig.DEFAULT_SHEET_CONFIG);
    }

    private static PivotExportContext getExportContext(final Pivottable table, final PivotModel model, PivotRenderer renderer, String dataFieldOrient, final boolean open, String[] titles, boolean useRendererForDataCells, final PivotExportSheetConfig sheetConfig) {
        if (renderer == null) {
            renderer = new SimplePivotRenderer();
        }
        final boolean isColOrient = dataFieldOrient != null && "column".equals(dataFieldOrient.toLowerCase());
        PivotField[] dataPF = model.getFields(PivotField.Type.DATA);
        int dataFieldSize = dataPF.length;
        final int rowDFSize = isColOrient ? 1 : dataFieldSize;
        final int colDFSize = isColOrient ? dataFieldSize : 1;
        PagingInfo rowPagingInfo = new PagingInfo(rowDFSize);
        PagingInfo colPagingInfo = new PagingInfo(colDFSize);
        PivotHeaderTree rowTree = model.getRowHeaderTree();
        PivotHeaderTree colTree = model.getColumnHeaderTree();
        HeaderTraverser rowHeaderTrav = new HeaderTraverser(rowTree, rowPagingInfo, open);
        HeaderTraverser colHeaderTrav = new HeaderTraverser(colTree, colPagingInfo, open);
        String[] rowGtLBs = Exports.getGrandTotalLabels(table, renderer, isColOrient ? null : dataPF);
        String[] colGtLBs = Exports.getGrandTotalLabels(table, renderer, (PivotField[])(isColOrient ? dataPF : null));
        ExportHeaderCellFiller rowEIF = new ExportHeaderCellFiller(table, renderer, false, rowDFSize);
        ExportHeaderCellFiller colEIF = new ExportHeaderCellFiller(table, renderer, true, colDFSize);
        HeaderSizeInfo headerSizeInfo = new HeaderSizeInfo(table, renderer, model, isColOrient);
        final int rowOffset = headerSizeInfo.getRowDisplayOffset();
        final int colOffset = headerSizeInfo.getColumnDisplayOffset();
        final int colSize = colHeaderTrav.getSize();
        final int rowSize = rowHeaderTrav.getSize();
        colHeaderTrav.run(new HeaderTraverser.Filler[]{colEIF});
        rowHeaderTrav.run(new HeaderTraverser.Filler[]{rowEIF});
        final PivotExportCell[][] colCells = colEIF.getExportCells();
        final PivotExportCell[][] rowCells = rowEIF.getExportCells();
        DataCellTraverser cellTrav = new DataCellTraverser(model, isColOrient, rowHeaderTrav.getRealSize(), colHeaderTrav.getRealSize(), rowPagingInfo, open);
        ExportDataCellFiller filler = new ExportDataCellFiller(cellTrav, renderer, table, useRendererForDataCells);
        cellTrav.addCellFiller(filler);
        cellTrav.fill();
        final PivotExportCell[][] dataCells = filler.getCells();
        int tLen = titles == null ? 0 : titles.length;
        final PivotExportCell dataTitle = new PivotExportCell(PivotExportCell.Type.TITLE_DATA, tLen < 1 ? null : titles[0], new int[]{colOffset, 1});
        final PivotExportCell colTitle = new PivotExportCell(PivotExportCell.Type.TITLE_COLUMN, tLen < 2 ? null : titles[1], new int[]{colDFSize * (colSize + 1), 1});
        final PivotExportCell rowTitle = new PivotExportCell(PivotExportCell.Type.TITLE_ROW, tLen < 3 ? null : titles[2], new int[]{colOffset, rowOffset});
        final PivotExportCell[] colGTs = new PivotExportCell[colDFSize];
        for (int i = 0; i < colDFSize; ++i) {
            colGTs[i] = table.isGrandTotalForColumns() ? new PivotExportCell(PivotExportCell.Type.COLUMN_GRAND_TOTAL, colGtLBs[i], new int[]{1, rowOffset}) : null;
        }
        final PivotExportCell[] rowGTs = new PivotExportCell[rowDFSize];
        for (int i = 0; i < rowDFSize; ++i) {
            rowGTs[i] = table.isGrandTotalForRows() ? new PivotExportCell(PivotExportCell.Type.ROW_GRAND_TOTAL, rowGtLBs[i], new int[]{colOffset, 1}) : null;
        }
        final PivotExportCell[] dfCells = new PivotExportCell[dataFieldSize];
        PivotExportCell.Type dt = isColOrient ? PivotExportCell.Type.COLUMN_DATA : PivotExportCell.Type.ROW_DATA;
        for (int i = 0; i < dataFieldSize; ++i) {
            dfCells[i] = new PivotExportCell(dt, renderer.renderDataField(dataPF[i]), null);
        }
        return new PivotExportContext(){

            @Override
            public int getColumnOffset() {
                return colOffset;
            }

            @Override
            public int getRowOffset() {
                return rowOffset;
            }

            @Override
            public int getColumnCount(boolean withDataField, boolean withGrandTotal) {
                return (withDataField ? colDFSize : 1) * (colSize + (withGrandTotal ? 1 : 0));
            }

            @Override
            public int getRowCount(boolean withDataField, boolean withGrandTotal) {
                return (withDataField ? rowDFSize : 1) * (rowSize + (withGrandTotal ? 1 : 0));
            }

            @Override
            public int getSheetHeight() {
                return this.getRowOffset() + this.getRowCount(true, true) + 1;
            }

            @Override
            public int getSheetWidth() {
                return this.getColumnOffset() + this.getColumnCount(true, true);
            }

            @Override
            public PivotExportCell getCell(int rowIndex, int columnIndex) {
                int rbnd = rowOffset + this.getRowCount(true, table.isGrandTotalForRows()) + 1;
                int cbnd = colOffset + this.getColumnCount(true, table.isGrandTotalForColumns());
                if (rowIndex < 0 || rowIndex >= rbnd || columnIndex < 0 || columnIndex >= cbnd) {
                    return null;
                }
                if (rowIndex == 0) {
                    return columnIndex == 0 ? dataTitle : (columnIndex == colOffset ? colTitle : null);
                }
                if (rowIndex == 1 && columnIndex == 0) {
                    return rowTitle;
                }
                if (rowIndex < rowOffset + 1 && columnIndex < colOffset) {
                    return null;
                }
                if (rowIndex < rowOffset + 1 && columnIndex >= colOffset) {
                    int c = columnIndex - colOffset;
                    int d = c % colDFSize;
                    if ((c /= colDFSize) == this.getColumnCount(false, false)) {
                        return rowIndex == 1 ? colGTs[d] : null;
                    }
                    if (colDFSize > 1 && rowIndex == rowOffset) {
                        return dfCells[d];
                    }
                    return d > 0 ? null : colCells[c][rowIndex - 1];
                }
                if (columnIndex < colOffset) {
                    int r = rowIndex - rowOffset - 1;
                    int d = r % rowDFSize;
                    if ((r /= rowDFSize) == this.getRowCount(false, false)) {
                        return columnIndex == 0 ? rowGTs[d] : null;
                    }
                    if (rowDFSize > 1 && columnIndex == colOffset - 1) {
                        return dfCells[d];
                    }
                    return d > 0 ? null : rowCells[r][columnIndex];
                }
                return dataCells[rowIndex - rowOffset - 1][columnIndex - colOffset];
            }

            @Override
            public PivotExportCell getTitleCell(PivotExportCell.Type type) {
                switch (type) {
                    case TITLE_DATA: {
                        return dataTitle;
                    }
                    case TITLE_COLUMN: {
                        return colTitle;
                    }
                    case TITLE_ROW: {
                        return rowTitle;
                    }
                }
                throw new IllegalArgumentException("Expecting title types: TITLE_DATA, TITLE_COLUMN or TITLE_ROW");
            }

            @Override
            public Iterable<? extends List<?>> getRawData() {
                if (model instanceof TabularPivotModel) {
                    return ((TabularPivotModel)model).getRawData();
                }
                throw new IllegalArgumentException("Expecting TabularPivotModel");
            }

            @Override
            public Iterable<String> getRawColumns() {
                PivotField[] fields = model.getFields();
                ArrayList<String> cols = new ArrayList<String>(fields.length);
                for (PivotField f : fields) {
                    cols.add(f.getFieldName());
                }
                return cols;
            }

            @Override
            public PivotField[] getRowFields() {
                return model.getFields(PivotField.Type.ROW);
            }

            @Override
            public PivotField[] getColumnFields() {
                return model.getFields(PivotField.Type.COLUMN);
            }

            @Override
            public PivotField[] getDataFields() {
                return model.getFields(PivotField.Type.DATA);
            }

            @Override
            public PivotField[] getAllFields() {
                return model.getFields();
            }

            @Override
            public boolean isDataFieldColumnOrient() {
                return isColOrient;
            }

            @Override
            public boolean isOpen() {
                return open;
            }

            @Override
            public PivotExportSheetConfig getSheetConfig() {
                return sheetConfig;
            }
        };
    }

    private static String[] getGrandTotalLabels(Pivottable table, PivotRenderer renderer, PivotField[] fields) {
        if (fields == null) {
            return new String[]{renderer.renderGrandTotalField(table, null)};
        }
        int len = fields.length;
        String[] result = new String[len];
        for (int i = 0; i < len; ++i) {
            result[i] = renderer.renderGrandTotalField(table, fields[i]);
        }
        return result;
    }

    private static class DefaultCellStyleConfigurator
    implements CellStyleConfigurator {
        private DefaultCellStyleConfigurator() {
        }

        @Override
        public void config(PivotExportCell.Type type, Cell cell, StyleFactory styleFactory) {
            if (type != PivotExportCell.Type.DATA && cell.getCellType() == 1 && cell.getStringCellValue().contains("\n")) {
                CellStyle newCellStyle = styleFactory.createCellStyle();
                newCellStyle.setWrapText(true);
                cell.setCellStyle(newCellStyle);
            }
        }

        @Override
        public String getDataFormat(String field) {
            return null;
        }
    }
}

