/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

public class PagingInfo {
    private final int _start;
    private final int _limit;
    private final int _end;
    private final int _dataSize;
    private final boolean _isLimited;
    private final int _nodeStart;
    private final int _nodeLimit;
    private final int _nodeEnd;
    private final int _cutoffStart;
    private final int _cutoffEnd;

    public PagingInfo(int dataSize) {
        this(0, -1, dataSize);
    }

    public PagingInfo(int start, int limit, int dataSize) {
        if (start < 0) {
            throw new IllegalArgumentException("start index cannot be less than 0.");
        }
        if (dataSize < 0) {
            throw new IllegalArgumentException("data size must not be negative.");
        }
        this._isLimited = limit >= 0;
        this._start = start;
        this._dataSize = dataSize;
        if (dataSize <= 0) {
            dataSize = 1;
        }
        this._nodeStart = start / dataSize;
        this._cutoffStart = start % dataSize;
        if (this._isLimited) {
            this._limit = limit;
            this._end = start + limit;
            this._nodeEnd = (this._end - 1) / dataSize + 1;
            this._nodeLimit = this._nodeEnd - this._nodeStart;
            this._cutoffEnd = (dataSize - this._end % dataSize) % dataSize;
        } else {
            this._nodeEnd = -1;
            this._nodeLimit = -1;
            this._end = -1;
            this._limit = -1;
            this._cutoffEnd = 0;
        }
    }

    public int getDataSize() {
        return this._dataSize;
    }

    public int getStart() {
        return this._start;
    }

    public int getLimit() {
        return this._limit;
    }

    public int getEnd() {
        return this._end;
    }

    public boolean isLimited() {
        return this._isLimited;
    }

    public int getNodeStart() {
        return this._nodeStart;
    }

    public int getNodeLimit() {
        return this._nodeLimit;
    }

    public int getNodeEnd() {
        return this._nodeEnd;
    }

    public int getCutoffStart() {
        return this._cutoffStart;
    }

    public int getNaiveCutoffEnd() {
        return this._cutoffEnd;
    }

    public int getRealCutoffEnd(int realNodeSize) {
        return Math.max(realNodeSize * this._dataSize - this._limit - this._cutoffStart, 0);
    }

    public int getPagedSize(int size) {
        return this.isLimited() ? Math.min(size, this.getLimit()) : (size -= this.getCutoffStart());
    }
}

