/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderContext;
import org.zkoss.pivot.PivotRenderer;
import org.zkoss.pivot.Pivottable;
import org.zkoss.pivot.impl.SimplePivotRenderer;
import org.zkoss.pivot.impl.util.DataCellTraverser;
import org.zkoss.pivot.util.PivotExportCell;

public class ExportDataCellFiller
implements DataCellTraverser.CellFiller {
    private final int _gtRowOffset;
    private final PivotExportCell[][] _cells;
    private static final PivotRenderer DEFAULT_RENDERER = new SimplePivotRenderer();
    private final PivotRenderer _renderer;
    private final Pivottable _table;
    private final boolean _useRendererForDataCells;

    public ExportDataCellFiller(DataCellTraverser trav) {
        this(trav, null, null, false);
    }

    public ExportDataCellFiller(DataCellTraverser trav, PivotRenderer renderer, Pivottable table, boolean useRendererForDataCells) {
        int colSize = trav.getCellColumnSize();
        this._gtRowOffset = trav.getCellRowSize();
        this._cells = new PivotExportCell[this._gtRowOffset + trav.getCellRowGTSize()][colSize];
        this._table = table;
        this._renderer = renderer;
        this._useRendererForDataCells = useRendererForDataCells;
    }

    public PivotExportCell[][] getCells() {
        return this._cells;
    }

    @Override
    public void fill(Number summary, PivotHeaderContext rowCtx, PivotHeaderContext colCtx, PivotField dataField, int ri, int ci, boolean isRowGT) {
        String defaultLabel;
        String label;
        if (isRowGT) {
            ri += this._gtRowOffset;
        }
        if (this._useRendererForDataCells && !(label = this._renderer.renderCell(summary, this._table, rowCtx, colCtx, dataField)).equals(defaultLabel = DEFAULT_RENDERER.renderCell(summary, this._table, rowCtx, colCtx, dataField))) {
            this._cells[ri][ci] = new PivotExportCell(PivotExportCell.Type.DATA, label, null);
            return;
        }
        this._cells[ri][ci] = new PivotExportCell(summary, dataField.getFieldName());
    }
}

