/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl.util;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderContext;
import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.PivotHeaderTree;
import org.zkoss.pivot.PivotModel;
import org.zkoss.pivot.impl.util.PagingInfo;
import org.zkoss.pivot.util.Trees;

public class DataCellTraverser {
    private final List<CellFiller> _fillers = new LinkedList<CellFiller>();
    private final int _cellRowSize;
    private final int _cellColSize;
    private final int _cellRowGTSize;
    private final boolean _openAll;
    private final PivotModel _model;
    private final PagingInfo _pgInfo;
    private final boolean _isColOrient;
    private final PivotField[] _dataFields;

    public DataCellTraverser(PivotModel model, boolean isColOrient, int rowSize, int colSize, PagingInfo pgInfo, boolean open) {
        this._model = model;
        this._pgInfo = pgInfo;
        this._openAll = open;
        this._dataFields = model.getFields(PivotField.Type.DATA);
        int dflen = this._dataFields.length;
        this._isColOrient = isColOrient;
        ++colSize;
        if (this._isColOrient) {
            colSize *= dflen;
        } else {
            rowSize *= dflen;
        }
        this._cellRowSize = this._pgInfo.getPagedSize(rowSize);
        this._cellColSize = colSize;
        this._cellRowGTSize = this._isColOrient ? 1 : dflen;
    }

    public void addCellFiller(CellFiller filler) {
        this._fillers.add(filler);
    }

    public int getCellRowSize() {
        return this._cellRowSize;
    }

    public int getCellColumnSize() {
        return this._cellColSize;
    }

    public int getCellRowGTSize() {
        return this._cellRowGTSize;
    }

    private static boolean isTerminal(PivotHeaderNode node, boolean open) {
        return open ? node.isLeaf() : Trees.isTerminal(node);
    }

    public void fill() {
        PivotHeaderTree rowTree = this._model.getRowHeaderTree();
        final PivotHeaderTree colTree = this._model.getColumnHeaderTree();
        final int offset = this._pgInfo.getNodeStart();
        final int limit = this._pgInfo.getNodeLimit();
        Trees.traverse(rowTree, this._openAll, offset, limit, new Trees.NodeRunner(){

            @Override
            public void onNode(final PivotHeaderNode rowNode, Trees.TreeTravCtx rowTctx) {
                final boolean isRowGT = Trees.isRoot(rowNode);
                int rowst = 0;
                if (!isRowGT) {
                    rowst = rowTctx.index() + (DataCellTraverser.isTerminal(rowNode, DataCellTraverser.this._openAll) ? 0 : rowTctx.nodesize()) - offset;
                    if (DataCellTraverser.this._pgInfo.isLimited() && rowst >= limit || rowTctx.postindex() <= offset) {
                        return;
                    }
                }
                final int rowStart = rowst;
                Trees.traverse(colTree, DataCellTraverser.this._openAll, new Trees.NodeRunner(){

                    @Override
                    public void onNode(PivotHeaderNode colNode, Trees.TreeTravCtx colTctx) {
                        int colStart = colTctx.index() + (DataCellTraverser.isTerminal(colNode, DataCellTraverser.this._openAll) ? 0 : colTctx.nodesize());
                        DataCellTraverser.this.fill(rowNode, colNode, rowStart, colStart, isRowGT, DataCellTraverser.this._openAll);
                    }
                });
            }
        });
    }

    public void fill(PivotHeaderNode rnode, PivotHeaderNode cnode, int rindex, int cindex, boolean isRowGT, boolean open) {
        new SingleCellFillCtx(this, rnode, cnode, rindex, cindex, isRowGT, open).fill();
    }

    private static class SingleCellFillCtx {
        final DataCellTraverser _context;
        final PivotHeaderNode _rnode;
        final PivotHeaderNode _cnode;
        final int _rindex;
        final int _cindex;
        final boolean _isRowGT;
        final boolean _open;

        private SingleCellFillCtx(DataCellTraverser context, PivotHeaderNode rnode, PivotHeaderNode cnode, int rindex, int cindex, boolean isRowGT, boolean open) {
            this._context = context;
            this._rnode = rnode;
            this._cnode = cnode;
            this._rindex = rindex;
            this._cindex = cindex;
            this._isRowGT = isRowGT;
            this._open = open;
        }

        private void fill() {
            if (DataCellTraverser.isTerminal(this._rnode, this._open) || Trees.isRoot(this._rnode)) {
                this.fill(-1);
            } else {
                int size = Trees.getSubtotalCount(this._rnode, this._open);
                for (int i = 0; i < size; ++i) {
                    this.fill(i);
                }
            }
        }

        private void fill(int rowCalIndex) {
            for (int di = 0; di < this._context._dataFields.length; ++di) {
                this.fill(rowCalIndex, di);
            }
        }

        private void fill(int rowCalIndex, int dataIndex) {
            if (DataCellTraverser.isTerminal(this._cnode, this._open) || Trees.isRoot(this._cnode)) {
                this.fill(rowCalIndex, -1, dataIndex);
            } else {
                int size = Trees.getSubtotalCount(this._cnode, this._open);
                for (int i = 0; i < size; ++i) {
                    this.fill(rowCalIndex, i, dataIndex);
                }
            }
        }

        private void fill(int rowCalIndex, int colCalIndex, int dataIndex) {
            int dataSize = this._context._dataFields.length;
            int ri = this.getPagedRowIndex(rowCalIndex, dataIndex);
            if (ri < 0 || !this._isRowGT && ri >= this._context._cellRowSize) {
                return;
            }
            int ci = this._cindex + Math.max(colCalIndex, 0);
            if (this._context._isColOrient) {
                ci = ci * dataSize + dataIndex;
            }
            Number summary = (Number)this._context._model.getValue(this._rnode, rowCalIndex, this._cnode, colCalIndex, dataIndex);
            Calculator rcal = Trees.getCalculator(this._rnode, rowCalIndex);
            Calculator ccal = Trees.getCalculator(this._cnode, colCalIndex);
            PivotField dataField = this._context._dataFields[dataIndex];
            PivotHeaderContext rowCtx = new PivotHeaderContext(this._rnode, rcal, ri);
            PivotHeaderContext colCtx = new PivotHeaderContext(this._cnode, ccal, ci);
            int gtri = this._context._isColOrient ? 0 : dataIndex;
            int realRi = this._isRowGT ? gtri : ri;
            for (CellFiller f : this._context._fillers) {
                f.fill(summary, rowCtx, colCtx, dataField, realRi, ci, this._isRowGT);
            }
        }

        private int getPagedRowIndex(int rowCalIndex, int dataIndex) {
            int dataSize = this._context._dataFields.length;
            boolean hasDF = !this._context._isColOrient;
            int len = this._context._cellRowSize + (hasDF ? dataSize : 1);
            if (this._isRowGT) {
                return hasDF ? len - dataSize + dataIndex : len - 1;
            }
            int ri = this._rindex + Math.max(rowCalIndex, 0);
            if (hasDF) {
                ri = ri * dataSize + dataIndex - this._context._pgInfo.getCutoffStart();
            }
            return ri;
        }
    }

    public static interface CellFiller {
        public void fill(Number var1, PivotHeaderContext var2, PivotHeaderContext var3, PivotField var4, int var5, int var6, boolean var7);
    }
}

