/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.pivot.impl;

import java.util.List;
import org.zkoss.pivot.Calculator;
import org.zkoss.pivot.PivotField;
import org.zkoss.pivot.PivotHeaderNode;
import org.zkoss.pivot.impl.SimplePivotHeaderTree;
import org.zkoss.pivot.impl.util.IndexLinkedList;

public class SimplePivotHeaderNode
implements PivotHeaderNode {
    private final SimplePivotHeaderTree _tree;
    private final SimplePivotHeaderNode _parent;
    private IndexLinkedList<Object, SimplePivotHeaderNode> _children;
    private final int _depth;
    private final Object _key;
    private transient int _size = -1;
    private transient int _sizeAsIfOpen = -1;
    private final String _hash;
    private boolean _open;

    public SimplePivotHeaderNode(SimplePivotHeaderTree tree) {
        this._parent = null;
        this._tree = tree;
        this._depth = 0;
        this._key = null;
        this._hash = "";
    }

    public SimplePivotHeaderNode(Object key, SimplePivotHeaderNode parent) {
        this._parent = parent;
        if (parent != null) {
            parent.initChildren().add(key, this);
        }
        this._tree = parent.getTree();
        this._depth = parent.getDepth() + 1;
        this._key = key;
        this._hash = parent._hash + "[" + key + "]";
    }

    @Override
    public SimplePivotHeaderTree getTree() {
        return this._tree;
    }

    public List<SimplePivotHeaderNode> getChildren() {
        return this.initChildren();
    }

    @Override
    public int getDepth() {
        return this._depth;
    }

    @Override
    public Object getKey() {
        return this._key;
    }

    @Override
    public SimplePivotHeaderNode getParent() {
        return this._parent;
    }

    @Override
    public SimplePivotHeaderNode getChild(Object key) {
        return this._children == null ? null : this._children.query(key);
    }

    @Override
    public boolean isLeaf() {
        return this._children == null || this._children.isEmpty();
    }

    @Override
    public boolean isOpen() {
        return this._open;
    }

    @Override
    public void setOpen(boolean open) {
        this._open = open;
        for (SimplePivotHeaderNode p = this.getParent(); p != null; p = p.getParent()) {
            p._size = -1;
        }
    }

    @Override
    public PivotField getField() {
        return this._depth == 0 ? null : this._tree.getFields()[this._depth - 1];
    }

    public boolean isRoot() {
        return this._depth == 0;
    }

    public String getHash() {
        return this._hash;
    }

    @Override
    public int getSubtotalCount(boolean asIfOpen) {
        if (this.isRoot() || this.isLeaf() || !asIfOpen && !this.isOpen()) {
            return 0;
        }
        Calculator[] subs = this.getField().getSubtotals();
        return subs == null ? 0 : subs.length;
    }

    @Override
    public int getSize(boolean asIfOpen) {
        if (this.isLeaf() || !this._open && !asIfOpen) {
            return 1;
        }
        if (asIfOpen) {
            if (this._sizeAsIfOpen < 0) {
                this._sizeAsIfOpen = 0;
                for (SimplePivotHeaderNode n : this.getChildren()) {
                    this._sizeAsIfOpen += n.getSize(true) + n.getSubtotalCount(true);
                }
            }
            return this._sizeAsIfOpen;
        }
        if (this._size < 0) {
            this._size = 0;
            for (SimplePivotHeaderNode n : this.getChildren()) {
                this._size += n.getSize(false) + n.getSubtotalCount(false);
            }
        }
        return this._size;
    }

    protected IndexLinkedList<Object, SimplePivotHeaderNode> initChildren() {
        if (this._children == null) {
            this._children = new IndexLinkedList();
        }
        return this._children;
    }

    public String toString() {
        return this._hash != null ? this._hash : super.toString();
    }
}

