/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.zkoss.web.servlet.ServletOutputStreamWrapper;

public class HttpBufferedResponse
extends HttpServletResponseWrapper {
    private Writer _writer;
    private OutputStream _stream;
    private PrintWriter _pwt;
    private ServletOutputStream _sos;
    private boolean _bSendRedirect;

    public static final HttpServletResponse getInstance(HttpServletResponse response, Writer writer) {
        if (!(writer == null || response instanceof HttpBufferedResponse && ((HttpBufferedResponse)response)._writer == writer)) {
            return new HttpBufferedResponse(response, writer);
        }
        return response;
    }

    public static final HttpServletResponse getInstance(HttpServletResponse response, OutputStream stream) {
        if (!(stream == null || response instanceof HttpBufferedResponse && ((HttpBufferedResponse)response)._stream == stream)) {
            return new HttpBufferedResponse(response, stream);
        }
        return response;
    }

    private HttpBufferedResponse(HttpServletResponse response, Writer writer) {
        super(response);
        if (writer == null) {
            throw new IllegalArgumentException("null writer");
        }
        this._writer = writer;
    }

    private HttpBufferedResponse(HttpServletResponse response, OutputStream stream) {
        super(response);
        if (stream == null) {
            throw new IllegalArgumentException("null stream");
        }
        this._stream = stream;
    }

    public boolean isSendRedirect() {
        return this._bSendRedirect;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._sos != null) {
            throw new IllegalStateException("getOutputStream was called");
        }
        if (this._pwt == null) {
            this._pwt = this._writer != null ? (this._writer instanceof PrintWriter ? (PrintWriter)this._writer : new PrintWriter(this._writer)) : new PrintWriter(new OutputStreamWriter(this._stream, this.getCharacterEncoding()));
        }
        return this._pwt;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._pwt != null) {
            throw new IllegalStateException("getWriter was called");
        }
        if (this._sos == null) {
            this._sos = this._stream != null ? ServletOutputStreamWrapper.getInstance(this._stream) : ServletOutputStreamWrapper.getInstance(this._writer, this.getCharacterEncoding());
        }
        return this._sos;
    }

    public void flushBuffer() throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        } else {
            this._stream.flush();
        }
    }

    public void resetBuffer() {
        if (this._writer instanceof StringWriter) {
            ((StringWriter)this._writer).getBuffer().setLength(0);
        } else if (this._stream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this._stream).reset();
        }
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(location);
        this._bSendRedirect = true;
    }
}

