/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.action;

import java.io.IOException;
import java.io.StringWriter;
import org.owasp.encoder.Encode;
import org.zkoss.lang.Strings;
import org.zkoss.web.servlet.dsp.DspException;
import org.zkoss.web.servlet.dsp.action.Action;
import org.zkoss.web.servlet.dsp.action.ActionContext;

public abstract class AbstractAction
implements Action {
    private boolean _if = true;
    private boolean _unless = false;

    public boolean getIf() {
        return this._if;
    }

    public void setIf(boolean ifcond) {
        this._if = ifcond;
    }

    public boolean getUnless() {
        return this._unless;
    }

    public void setUnless(boolean unless) {
        this._unless = unless;
    }

    public boolean isEffective() {
        return this._if && !this._unless;
    }

    protected static final int toScope(String scope) {
        return "request".equals(scope) ? 1 : ("session".equals(scope) ? 2 : ("application".equals(scope) ? 3 : 0));
    }

    protected static final void append(StringBuffer sb, String attrName, String attrValue) {
        if (attrValue != null) {
            sb.append(' ').append(attrName).append("=\"").append(Encode.forHtmlAttribute((String)attrValue)).append('\"');
        }
    }

    protected static void append(StringBuffer sb, String attrName, boolean avail) {
        if (avail) {
            sb.append(' ').append(attrName);
        }
    }

    protected static final void append(StringBuffer sb, String attrName, int val) {
        sb.append(' ').append(attrName).append("=\"").append(Integer.toString(val)).append('\"');
    }

    static StringWriter getFragmentOut(ActionContext ac, boolean trim) throws IOException {
        return trim && !(ac.getOut() instanceof StringWriter) ? new StringWriter() : null;
    }

    static void renderFragment(ActionContext ac, StringWriter out, boolean trim) throws DspException, IOException {
        if (trim) {
            StringBuffer buf = (out != null ? out : (StringWriter)ac.getOut()).getBuffer();
            int index = buf.length();
            ac.renderFragment(out);
            Strings.trim((StringBuffer)buf, (int)index);
        } else {
            ac.renderFragment(out);
        }
    }
}

