/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.web.servlet.ServletOutputStreamWrapper;
import org.zkoss.web.servlet.http.HttpBufferedResponse;

public class BufferedResponse
extends ServletResponseWrapper {
    private Writer _writer;
    private OutputStream _stream;
    private PrintWriter _pwt;
    private ServletOutputStream _sos;

    public static final ServletResponse getInstance(ServletResponse response, Writer writer) {
        if (response instanceof HttpServletResponse) {
            return HttpBufferedResponse.getInstance((HttpServletResponse)response, writer);
        }
        if (!(writer == null || response instanceof BufferedResponse && ((BufferedResponse)response)._writer == writer)) {
            return new BufferedResponse(response, writer);
        }
        return response;
    }

    public static final ServletResponse getInstance(ServletResponse response, OutputStream stream) {
        if (response instanceof HttpServletResponse) {
            return HttpBufferedResponse.getInstance((HttpServletResponse)response, stream);
        }
        if (!(stream == null || response instanceof BufferedResponse && ((BufferedResponse)response)._stream == stream)) {
            return new BufferedResponse(response, stream);
        }
        return response;
    }

    private BufferedResponse(ServletResponse response, Writer writer) {
        super(response);
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        this._writer = writer;
    }

    private BufferedResponse(ServletResponse response, OutputStream stream) {
        super(response);
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        this._stream = stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._sos != null) {
            throw new IllegalStateException("getOutputStream was called");
        }
        if (this._pwt == null) {
            this._pwt = this._writer != null ? (this._writer instanceof PrintWriter ? (PrintWriter)this._writer : new PrintWriter(this._writer)) : new PrintWriter(new OutputStreamWriter(this._stream, this.getCharacterEncoding()));
        }
        return this._pwt;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._pwt != null) {
            throw new IllegalStateException("getWriter was called");
        }
        if (this._sos == null) {
            if (this._stream != null) {
                this._sos = ServletOutputStreamWrapper.getInstance(this._stream);
            } else {
                throw new UnsupportedOperationException("ServletOutputStream cannot wrap PrintWriter");
            }
        }
        return this._sos;
    }

    public void flushBuffer() throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        } else {
            this._stream.flush();
        }
    }

    public void resetBuffer() {
        if (this._writer instanceof StringWriter) {
            ((StringWriter)this._writer).getBuffer().setLength(0);
        } else if (this._stream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this._stream).reset();
        }
    }
}

