/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.impl;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.zkoss.web.servlet.dsp.DspException;
import org.zkoss.web.servlet.dsp.action.Action;
import org.zkoss.web.servlet.dsp.action.ActionContext;
import org.zkoss.web.servlet.dsp.impl.ActionNode;
import org.zkoss.web.servlet.dsp.impl.InterpretContext;

class ActionContextImpl
implements ActionContext {
    private final InterpretContext _ic;
    private final Action _parent;
    private final ActionNode _current;
    private final int _nLines;

    ActionContextImpl(InterpretContext ic, Action parent, ActionNode current, int nLines) {
        this._ic = ic;
        this._parent = parent;
        this._nLines = nLines;
        this._current = current;
    }

    @Override
    public Object getAttribute(String name, int scope) {
        return this._ic.resolver.getAttributes(scope).get(name);
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        if (value == null) {
            this.removeAttribute(name, scope);
            return;
        }
        this._ic.resolver.getAttributes(scope).put(name, value);
    }

    @Override
    public void removeAttribute(String name, int scope) {
        this._ic.resolver.getAttributes(scope).remove(name);
    }

    @Override
    public Object findAttribute(String name) {
        Object o = this.getAttribute(name, 0);
        if (o != null) {
            return o;
        }
        o = this.getAttribute(name, 1);
        if (o != null) {
            return o;
        }
        o = this.getAttribute(name, 2);
        return o != null ? o : this.getAttribute(name, 3);
    }

    @Override
    public void setContentType(String ctype) {
        this._ic.dc.setContentType(ctype);
    }

    @Override
    public Writer getOut() throws IOException {
        return this._ic.dc.getOut();
    }

    @Override
    public Action getParent() {
        return this._parent;
    }

    @Override
    public void renderFragment(Writer out) throws DspException, IOException {
        if (out == null || out == this._ic.dc.getOut()) {
            this._current.renderFragment(this._ic);
        } else {
            Writer old = this._ic.dc.getOut();
            this._ic.dc.setOut(out);
            try {
                this._current.renderFragment(this._ic);
            }
            finally {
                this._ic.dc.setOut(old);
            }
        }
    }

    public void include(String uri, Map params) throws DspException, IOException {
        try {
            this._ic.dc.include(uri, params);
        }
        catch (ServletException ex) {
            throw new DspException(ex);
        }
    }

    @Override
    public boolean isIncluded() {
        return this._ic.dc.isIncluded();
    }

    @Override
    public String encodeURL(String uri) throws DspException, IOException {
        try {
            return this._ic.dc.encodeURL(uri);
        }
        catch (ServletException ex) {
            throw new DspException(ex);
        }
    }

    @Override
    public int getLineNumber() {
        return this._nLines;
    }
}

