/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.zkoss.web.servlet.Charsets;

public class CharsetFilter
implements Filter {
    private String _charset = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object old = Charsets.setup(request, response, this._charset);
        try {
            chain.doFilter(request, response);
        }
        finally {
            Charsets.cleanup(request, old);
        }
    }

    public void destroy() {
    }

    public final void init(FilterConfig config) throws ServletException {
        String cs = config.getInitParameter("charset");
        if (cs != null) {
            this._charset = cs.length() > 0 ? cs : null;
        }
    }
}

