/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang.reflect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.zkoss.lang.Objects;
import org.zkoss.lang.SystemException;

public class SerializableMethod
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20060622L;
    private transient Method _m;

    public SerializableMethod(Method method) {
        this._m = method;
    }

    public final Method getMethod() {
        return this._m;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this._m == null) {
            s.writeObject(null);
        } else {
            s.writeObject(this._m.getDeclaringClass());
            s.writeObject(this._m.getName());
            Class<?>[] argTypes = this._m.getParameterTypes();
            s.writeInt(argTypes.length);
            for (int j = 0; j < argTypes.length; ++j) {
                s.writeObject(argTypes[j]);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Class cls = (Class)s.readObject();
        if (cls != null) {
            String nm = (String)s.readObject();
            int sz = s.readInt();
            Class[] argTypes = new Class[sz];
            for (int j = 0; j < sz; ++j) {
                argTypes[j] = (Class)s.readObject();
            }
            try {
                this._m = cls.getMethod(nm, argTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new SystemException("Method not found: " + nm + " with " + Objects.toString(argTypes));
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        return Objects.hashCode(this._m);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof SerializableMethod && Objects.equals(this._m, ((SerializableMethod)o)._m);
    }

    public String toString() {
        return Objects.toString(this._m);
    }
}

