/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hc.core5.net.URIBuilder;

public class URLs {
    public static URL sanitizeURL(URL url) throws MalformedURLException, URISyntaxException {
        if (url == null) {
            return null;
        }
        if ("jar".equals(url.getProtocol())) {
            String jarSpec = url.getFile();
            if (jarSpec != null && jarSpec.contains("!/")) {
                int separatorIndex = jarSpec.indexOf("!/");
                String jarFilePath = jarSpec.substring(0, separatorIndex);
                String internalPath = jarSpec.substring(separatorIndex + 2);
                if (jarFilePath.isEmpty() || internalPath.isEmpty()) {
                    throw new MalformedURLException("Invalid JAR URL format: empty jar path or internal path");
                }
                URL jarURL = new URL(jarFilePath);
                jarURL.toURI();
                return new URL("jar:" + jarFilePath + "!/" + internalPath);
            }
            throw new MalformedURLException("Invalid JAR URL format: missing !/ separator");
        }
        return new URIBuilder().setScheme(url.getProtocol()).setHost(url.getHost()).setPort(url.getPort()).setPath(url.getPath()).setCustomQuery(url.getQuery()).build().toURL();
    }
}

