/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.token;

import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.FormulaTokenParser;
import org.apache.poi.ss.formula.token.AreaRefNode;
import org.apache.poi.ss.formula.token.BracketNode;
import org.apache.poi.ss.formula.token.ColonNode;
import org.apache.poi.ss.formula.token.ErrorNode;
import org.apache.poi.ss.formula.token.ExclamationNode;
import org.apache.poi.ss.formula.token.FormulaTokenNode;
import org.apache.poi.ss.formula.token.FunctionNode;
import org.apache.poi.ss.formula.token.IntegerNode;
import org.apache.poi.ss.formula.token.NameNode;
import org.apache.poi.ss.formula.token.NodeId;
import org.apache.poi.ss.formula.token.OpNode;
import org.apache.poi.ss.formula.token.RefNode;
import org.apache.poi.ss.formula.token.TokenNodeVisitor;
import org.apache.poi.ss.util.RefUtil;

public class ColonOpNode
extends OpNode {
    @Override
    public NodeId getNodeId() {
        return NodeId.ColonNode;
    }

    @Override
    public int getFlag() {
        return 1;
    }

    @Override
    public String getOp() {
        return ":";
    }

    @Override
    public boolean setLeftOp(FormulaTokenNode node) {
        switch (node.getNodeId()) {
            case ErrorNode: {
                if (node != ErrorNode.REF_ERROR) break;
                return super.setLeftOp(node);
            }
            case IntegerNode: {
                int i = ((IntegerNode)node).getValue();
                if (i <= 0 || i > 0x100000) break;
                return super.setLeftOp(node);
            }
            case NameRefNode: 
            case FunctionNode: 
            case RefNode: 
            case AreaRefNode: 
            case ExclamationNode: 
            case BracketNode: 
            case NameNode: 
            case ColonNode: 
            case UnionNode: {
                return super.setLeftOp(node);
            }
        }
        throw new FormulaParseException("Invalid string before a colon ':': " + node.toString());
    }

    @Override
    public boolean setRightOp(FormulaTokenNode node) {
        if (node == null) {
            throw new FormulaParseException("Missing reference after '!'");
        }
        switch (node.getNodeId()) {
            case ErrorNode: {
                if (node != ErrorNode.REF_ERROR) break;
                return super.setRightOp(node);
            }
            case IntegerNode: {
                int i = ((IntegerNode)node).getValue();
                NodeId leftId = this.left.getNodeId();
                if ((i <= 0 || i > 0x100000 || leftId != NodeId.IntegerNode) && leftId != NodeId.NameNode && (leftId != NodeId.ExclamationNode || ((OpNode)this.left).getRight().getNodeId() != NodeId.IntegerNode)) break;
                return super.setRightOp(node);
            }
            case NameRefNode: 
            case FunctionNode: 
            case RefNode: 
            case AreaRefNode: 
            case ExclamationNode: 
            case BracketNode: 
            case NameNode: 
            case ColonNode: 
            case UnionNode: {
                return super.setRightOp(node);
            }
        }
        throw new FormulaParseException("Invalid data after a colon character ':': " + node.toString());
    }

    private void _toError() {
        StringBuilder sb = new StringBuilder();
        sb.append("Invalid reference: ");
        if (this.left != null) {
            sb.append(this.left);
        }
        sb.append(':');
        if (this.right != null) {
            sb.append(this.right);
        }
        throw new FormulaParseException(sb.toString());
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        return this._normalize(parser, false);
    }

    private FormulaTokenNode _normalize(FormulaTokenParser parser, boolean flag) {
        switch (this.left.getNodeId()) {
            case FunctionNode: {
                FunctionNode funcNode = (FunctionNode)this.left;
                this.left = funcNode.normalize(parser);
                break;
            }
            case ExclamationNode: {
                ExclamationNode excNode = (ExclamationNode)this.left;
                this.left = excNode.getRight();
                FormulaTokenNode rightNode = this.normalize(parser);
                excNode.setRightOp(rightNode);
                if (rightNode == null) {
                    return null;
                }
                if (rightNode.getNodeId() != NodeId.AreaRefNode && rightNode.getNodeId() != NodeId.RefNode) {
                    excNode.setRightOp(this.left);
                    if (!flag) {
                        this.right = this.right.normalize(parser);
                        if (this.right == null) {
                            return null;
                        }
                    }
                    return new ColonNode(excNode.normalize(parser), this.right);
                }
                return excNode.normalize(parser);
            }
            case BracketNode: {
                OpNode leftOpNode;
                long topLeft;
                if (!parser.isA1Notation() && (topLeft = ((BracketNode)this.left).toRefHash(parser)) != Long.MIN_VALUE) {
                    long bottomRight = Long.MIN_VALUE;
                    if (this.right.getNodeId() == NodeId.NameNode) {
                        bottomRight = ((NameNode)this.right).toRefHash();
                    } else if (this.right.getNodeId() == NodeId.BracketNode) {
                        bottomRight = ((BracketNode)this.right).toRefHash(parser);
                    }
                    if ((topLeft & Long.MIN_VALUE) == (bottomRight & Long.MIN_VALUE)) {
                        return new AreaRefNode(topLeft, bottomRight);
                    }
                    if (!flag) {
                        this.right = this.right.normalize(parser);
                        if (this.right == null) {
                            return null;
                        }
                    }
                    return new ColonNode(new RefNode(topLeft, null), this.right);
                }
                if (this.right.getNodeId() != NodeId.ExclamationNode || ((BracketNode)this.left).getRight() == null || (leftOpNode = (OpNode)this.right).getLeft().getNodeId() != NodeId.NameNode) break;
                this.right = leftOpNode.getLeft();
                leftOpNode.setLeftOp(this);
                return leftOpNode.normalize(parser);
            }
            case NameNode: {
                OpNode rightOpNode;
                long topLeft = ((NameNode)this.left).toRefHash();
                if (topLeft != Long.MIN_VALUE) {
                    long bottomRight = Long.MIN_VALUE;
                    switch (this.right.getNodeId()) {
                        case BracketNode: {
                            if (parser.isA1Notation()) break;
                            bottomRight = ((BracketNode)this.right).toRefHash(parser);
                            break;
                        }
                        case NameNode: {
                            bottomRight = ((NameNode)this.right).toRefHash();
                            break;
                        }
                        case IntegerNode: {
                            if (!parser.isA1Notation()) {
                                this._toError();
                            }
                            if (RefUtil.hasColRef(topLeft)) break;
                            bottomRight = RefUtil.toRowHash(((IntegerNode)this.right).getValue() - 1, true);
                            if (topLeft == bottomRight) {
                                return new RefNode(topLeft);
                            }
                            return new AreaRefNode(topLeft, bottomRight);
                        }
                    }
                    if ((topLeft & Long.MIN_VALUE) == (bottomRight & Long.MIN_VALUE)) {
                        return new AreaRefNode(topLeft, bottomRight);
                    }
                    if (!RefUtil.hasColRef(topLeft)) {
                        this._toError();
                    }
                    if (!flag) {
                        this.right = this.right.normalize(parser);
                        if (this.right == null) {
                            return null;
                        }
                    }
                    if (!RefUtil.hasRowRef(topLeft)) {
                        return new ColonNode(this.left, this.right);
                    }
                    return new ColonNode(new RefNode(topLeft), this.right);
                }
                if (this.right.getNodeId() != NodeId.ExclamationNode || (rightOpNode = (OpNode)this.right).getLeft().getNodeId() != NodeId.NameNode) break;
                this.right = rightOpNode.getLeft();
                rightOpNode.setLeftOp(this);
                return rightOpNode.normalize(parser);
            }
            case ColonNode: {
                OpNode leftOpNode0;
                OpNode leftOpNode = (OpNode)this.left;
                if (leftOpNode.getRight().getNodeId() == NodeId.ExclamationNode && (leftOpNode0 = (OpNode)leftOpNode.getRight()).getLeft().getNodeId() == NodeId.NameNode) {
                    leftOpNode.setRightOp(leftOpNode0.getLeft());
                    leftOpNode0.setLeftOp(leftOpNode);
                    this.left = leftOpNode0;
                    return this.normalize(parser);
                }
                this.left = ((ColonOpNode)this.left)._normalize(parser, true);
                if (this.left == null || this.left.getNodeId() != NodeId.ColonNode) break;
                leftOpNode = (OpNode)this.left;
                this.left = leftOpNode.getRight();
                leftOpNode.setRightOp(this.normalize(parser));
                if (leftOpNode.getRight() == null) {
                    return null;
                }
                if (leftOpNode.getRight().getNodeId() == NodeId.AreaRefNode) {
                    return leftOpNode;
                }
                this.left = leftOpNode;
                break;
            }
            case IntegerNode: {
                long topLeft;
                if (!parser.isA1Notation()) {
                    throw new FormulaParseException("Invalid data for a range character ':': " + this.left.toString());
                }
                if (this.right.getNodeId() == NodeId.IntegerNode) {
                    return new AreaRefNode(RefUtil.toRowHash(((IntegerNode)this.left).getValue() - 1, true), RefUtil.toRowHash(((IntegerNode)this.right).getValue() - 1, true));
                }
                if (this.right.getNodeId() == NodeId.NameNode && (topLeft = ((NameNode)this.right).toRefHash()) != Long.MIN_VALUE && !RefUtil.hasColRef(topLeft)) {
                    return new AreaRefNode(RefUtil.toRowHash(((IntegerNode)this.left).getValue() - 1, true), topLeft);
                }
                this._toError();
            }
        }
        if (!flag) {
            this.right = this.right.normalize(parser);
            if (this.right == null) {
                return null;
            }
        }
        return new ColonNode(this.left, this.right);
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        throw new FormulaParseException("Shouldn't run into this case");
    }
}

