/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.Logger;
import org.apache.poi.logging.PoiLogManager;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;

public interface ObjectData {
    public InputStream getInputStream() throws IOException;

    public OutputStream getOutputStream() throws IOException;

    default public byte[] getBytes() throws IOException {
        try (InputStream is = this.getInputStream();){
            byte[] byArray = IOUtils.toByteArray(is);
            return byArray;
        }
    }

    default public boolean hasDirectoryEntry() {
        boolean bl;
        block8: {
            InputStream is = FileMagic.prepareToCheckMagic(this.getInputStream());
            try {
                FileMagic fm = FileMagic.valueOf(is);
                boolean bl2 = bl = fm == FileMagic.OLE2;
                if (is == null) break block8;
            }
            catch (Throwable fm) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            fm.addSuppressed(throwable);
                        }
                    }
                    throw fm;
                }
                catch (IOException e) {
                    Logger LOG = PoiLogManager.getLogger(ObjectData.class);
                    LOG.atWarn().withThrowable((Throwable)e).log("Can't determine filemagic of ole stream");
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    default public DirectoryEntry getDirectory() throws IOException {
        try (InputStream is = this.getInputStream();){
            DirectoryNode directoryNode = new POIFSFileSystem(is).getRoot();
            return directoryNode;
        }
    }

    public String getOLE2ClassName();

    public String getFileName();
}

