/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.common.FtrHeader;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class XFCrcRecord
extends StandardRecord {
    public static final short sid = 2172;
    private FtrHeader futureHeader;
    private short reserved1;
    private int cxfs;
    private long crc;

    public XFCrcRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2172);
    }

    @Override
    public short getSid() {
        return 2172;
    }

    @Override
    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.XF_CRC;
    }

    public XFCrcRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.reserved1 = in.readShort();
        this.cxfs = in.readUShort();
        this.crc = (long)in.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeShort(this.reserved1);
        out.writeShort(this.cxfs);
        out.writeInt((int)this.crc);
    }

    @Override
    public XFCrcRecord copy() {
        return (XFCrcRecord)this.clone();
    }

    @Override
    protected int getDataSize() {
        return 20;
    }

    public int getCxfs() {
        return this.cxfs;
    }

    public void setCxfs(int cxfs) {
        this.cxfs = cxfs;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setCrc(long crc) {
        this.crc = crc;
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("cxfs", () -> this.cxfs, "crc", () -> HexDump.intToHex((int)this.crc));
    }
}

