/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.lang.reflect.Field;
import org.apache.poi.xssf.usermodel.XSSFTableColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STTotalsRowFunction;

public class XSSFTableColumnHelper {
    public static void setTotalsRowFunction(XSSFTableColumn tableColumn, TotalsRowFunction func) {
        CTTableColumn ctTableColumn = XSSFTableColumnHelper.getCTTableColumn(tableColumn);
        if (func == TotalsRowFunction.none) {
            if (ctTableColumn.isSetTotalsRowFunction()) {
                ctTableColumn.unsetTotalsRowFunction();
            }
        } else {
            ctTableColumn.setTotalsRowFunction(STTotalsRowFunction.Enum.forInt((int)(func.ordinal() + 1)));
        }
    }

    public static void setTotalsRowLabel(XSSFTableColumn tableColumn, String label) {
        CTTableColumn ctTableColumn = XSSFTableColumnHelper.getCTTableColumn(tableColumn);
        if (label == null) {
            if (ctTableColumn.isSetTotalsRowLabel()) {
                ctTableColumn.unsetTotalsRowLabel();
            }
        } else {
            ctTableColumn.setTotalsRowLabel(label);
        }
    }

    public static void setTotalsRowFormula(XSSFTableColumn tableColumn, String formula) {
        CTTableColumn ctTableColumn = XSSFTableColumnHelper.getCTTableColumn(tableColumn);
        if (ctTableColumn.isSetTotalsRowFormula()) {
            ctTableColumn.unsetTotalsRowFormula();
        }
        if (formula != null) {
            ctTableColumn.addNewTotalsRowFormula();
            ctTableColumn.getTotalsRowFormula().setStringValue(formula);
        }
    }

    private static CTTableColumn getCTTableColumn(XSSFTableColumn tableColumn) {
        Field ctTableColumn = null;
        try {
            ctTableColumn = tableColumn.getClass().getDeclaredField("ctTableColumn");
            ctTableColumn.setAccessible(true);
            CTTableColumn cTTableColumn = (CTTableColumn)ctTableColumn.get(tableColumn);
            return cTTableColumn;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ctTableColumn != null) {
                ctTableColumn.setAccessible(false);
            }
        }
    }

    public static enum TotalsRowFunction {
        none,
        sum,
        min,
        max,
        average,
        count,
        countNums,
        stdDev,
        var,
        custom;

    }
}

