/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.NamedStyle;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.StylesTableHelper;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyleHelper;
import org.apache.poi.xssf.usermodel.XSSFDxfCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFNamedStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTStylesheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbookProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.w3c.dom.Element;

public class XSSFWorkbookHelper {
    public static XSSFDxfCellStyle createDxfCellStyle(XSSFWorkbook workbook, int j) {
        return new XSSFDxfCellStyle(j, workbook.getStylesSource(), workbook.getTheme());
    }

    public static XSSFDxfCellStyle createDxfCellStyle(XSSFWorkbook workbook) {
        XSSFDxfCellStyle dxf = new XSSFDxfCellStyle(workbook.getStylesSource(), workbook.getTheme());
        dxf.setIndex(XSSFWorkbookHelper.addDxfCellStyle(workbook, dxf) - 1);
        return dxf;
    }

    public static int addDxfCellStyle(XSSFWorkbook workbook, XSSFDxfCellStyle cellStyle) {
        return workbook.getStylesSource().putDxf(cellStyle.getDxf());
    }

    public static XSSFCellStyle createDefaultCellStyle(XSSFWorkbook workbook, XSSFCellBorder border, XSSFCellFill fill, XSSFFont font, int numFmtId) {
        StylesTable stylesSource = workbook.getStylesSource();
        int fontId = stylesSource.putFont(font);
        int fillId = stylesSource.putFill(fill);
        int borderId = stylesSource.putBorder(border);
        CTXf xf = (CTXf)CTXf.Factory.newInstance();
        xf.setNumFmtId((long)numFmtId);
        xf.setFontId((long)fontId);
        xf.setFillId((long)fillId);
        xf.setBorderId((long)borderId);
        return XSSFCellStyleHelper.create(-1, stylesSource.putCellStyleXf(xf) - 1, stylesSource, workbook.getTheme());
    }

    public static void setAlgName(XSSFWorkbook workbook, String algName) {
        CTWorkbookProtection ctProtection = XSSFWorkbookHelper.getCTWorkbookProtection(workbook);
        ((Element)ctProtection.getDomNode()).setAttribute("workbookAlgorithmName", algName);
    }

    public static void setHashValue(XSSFWorkbook workbook, String hashValue) {
        CTWorkbookProtection ctProtection = XSSFWorkbookHelper.getCTWorkbookProtection(workbook);
        ((Element)ctProtection.getDomNode()).setAttribute("workbookHashValue", hashValue);
    }

    public static void setSaltValue(XSSFWorkbook workbook, String saltValue) {
        CTWorkbookProtection ctProtection = XSSFWorkbookHelper.getCTWorkbookProtection(workbook);
        ((Element)ctProtection.getDomNode()).setAttribute("workbookSaltValue", saltValue);
    }

    public static void setSpinCount(XSSFWorkbook workbook, String spinCount) {
        CTWorkbookProtection ctProtection = XSSFWorkbookHelper.getCTWorkbookProtection(workbook);
        ((Element)ctProtection.getDomNode()).setAttribute("workbookSpinCount", spinCount);
    }

    public static void clearDefaultCellStyles(XSSFWorkbook workbook) {
        StylesTable stylesSource = workbook.getStylesSource();
        StylesTableHelper.getBorders(stylesSource).clear();
        StylesTableHelper.getFonts(stylesSource).clear();
        StylesTableHelper.getNumberFormats(stylesSource).clear();
        StylesTableHelper.getCellStyleXfs(stylesSource).clear();
        StylesTableHelper.getCellStyleDxfs(stylesSource).clear();
        StylesTableHelper.getCellXfs(stylesSource).clear();
        StylesTableHelper.getTableStyles(stylesSource).clear();
    }

    public static void addDefaultCellStyle(XSSFWorkbook workbook, CellStyle cellStyle) {
        workbook.getStylesSource().putCellStyleXf(((XSSFCellStyle)cellStyle).getStyleXf());
    }

    public static void clearNamedStyles(XSSFWorkbook workbook) {
        CTCellStyles cellStyles;
        CTStylesheet ctStylesheet = workbook.getStylesSource().getCTStylesheet();
        if (ctStylesheet != null && (cellStyles = ctStylesheet.getCellStyles()) != null) {
            cellStyles.setCellStyleArray(null);
        }
    }

    public static void addNamedStyles(XSSFWorkbook workbook, List<NamedStyle> cellStyles) {
        if (!cellStyles.isEmpty()) {
            CTStylesheet ctStylesheet = workbook.getStylesSource().getCTStylesheet();
            CTCellStyles ctCellStyles = ctStylesheet.getCellStyles();
            if (ctCellStyles == null) {
                ctCellStyles = (CTCellStyles)CTCellStyles.Factory.newInstance();
            }
            ctCellStyles.setCount((long)cellStyles.size());
            ctCellStyles.setCellStyleArray(cellStyles.stream().map(cellsTyle -> ((XSSFNamedStyle)cellsTyle).getCellStyle()).collect(Collectors.toList()).toArray(new CTCellStyle[0]));
            ctStylesheet.setCellStyles(ctCellStyles);
        }
    }

    public static void setDefaultTableStyle(XSSFWorkbook workbook, String defaultTableStyle) {
        CTTableStyles tableStyles = workbook.getStylesSource().getCTStylesheet().getTableStyles();
        if (tableStyles != null) {
            tableStyles.setDefaultPivotStyle(defaultTableStyle);
        }
    }

    public static void setDefaultPivotStyle(XSSFWorkbook workbook, String defaultPivotStyle) {
        CTTableStyles tableStyles = workbook.getStylesSource().getCTStylesheet().getTableStyles();
        if (tableStyles != null) {
            tableStyles.setDefaultPivotStyle(defaultPivotStyle);
        }
    }

    public static void clearDxfCellStyles(XSSFWorkbook workbook) {
        StylesTableHelper.getCellStyleDxfs(workbook.getStylesSource()).clear();
    }

    public static void clearTableStyles(XSSFWorkbook workbook) {
        CTTableStyles tableStyles;
        StylesTableHelper.getTableStyles(workbook.getStylesSource()).clear();
        CTStylesheet ctStylesheet = workbook.getStylesSource().getCTStylesheet();
        if (ctStylesheet != null && (tableStyles = ctStylesheet.getTableStyles()) != null) {
            tableStyles.setTableStyleArray(null);
        }
    }

    public static NamedStyle createNamedStyle(XSSFWorkbook workbook, String name, boolean custom, int builtinId, int index) {
        return new XSSFNamedStyle(name, custom, builtinId, index, workbook.getStylesSource(), workbook.getTheme());
    }

    private static CTWorkbookProtection getCTWorkbookProtection(XSSFWorkbook workbook) {
        CTWorkbook ctWorkbook = XSSFWorkbookHelper.getCTWorkbook(workbook);
        return ctWorkbook.isSetWorkbookProtection() ? ctWorkbook.getWorkbookProtection() : ctWorkbook.addNewWorkbookProtection();
    }

    private static CTWorkbook getCTWorkbook(XSSFWorkbook workbook) {
        Field ctWorkbookField = null;
        try {
            ctWorkbookField = Arrays.stream(workbook.getClass().getDeclaredFields()).filter(t -> t.getType() == CTWorkbook.class).findFirst().get();
            ctWorkbookField.setAccessible(true);
            CTWorkbook cTWorkbook = (CTWorkbook)ctWorkbookField.get(workbook);
            return cTWorkbook;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ctWorkbookField != null) {
                ctWorkbookField.setAccessible(false);
            }
        }
    }
}

