/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xddf.usermodel.chart;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxisHelper;
import org.apache.poi.xddf.usermodel.chart.XDDFDateAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDateAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.STTimeUnit;

public class XDDFDateAxisHelper {
    public static void setId(XDDFDateAxis axis, long id) {
        axis.getCTAxId().setVal(id);
    }

    public static void setDelete(XDDFDateAxis axis, boolean delete) {
        axis.getDelete().setVal(delete);
    }

    public static void setMajorGridline(XDDFDateAxis axis, boolean majorGridline) {
        CTDateAx ctDateAx = XDDFDateAxisHelper.getDateAx(axis);
        if (majorGridline) {
            XDDFCategoryAxisHelper.fillMajorGridline(ctDateAx.addNewMajorGridlines());
        } else {
            ctDateAx.unsetMajorGridlines();
        }
    }

    public static void setAuto(XDDFDateAxis axis, boolean auto) {
        CTDateAx dateAx = XDDFDateAxisHelper.getDateAx(axis);
        if (dateAx.isSetAuto()) {
            dateAx.getAuto().setVal(auto);
        } else {
            dateAx.addNewAuto().setVal(auto);
        }
    }

    public static void setLblOffset(XDDFDateAxis axis, int lblOffset) {
        CTDateAx ctDateAx = XDDFDateAxisHelper.getDateAx(axis);
        if (ctDateAx.isSetLblOffset()) {
            ctDateAx.getLblOffset().setVal((Object)lblOffset);
        } else {
            ctDateAx.addNewLblOffset().setVal((Object)lblOffset);
        }
    }

    public static void setBaseTimeUnit(XDDFDateAxis axis, TimeUnit timeUnit) {
        CTDateAx ctDateAx = XDDFDateAxisHelper.getDateAx(axis);
        STTimeUnit.Enum ctTimeUnit = XDDFDateAxisHelper.fromTimeUnit(timeUnit);
        if (ctDateAx.isSetBaseTimeUnit()) {
            ctDateAx.getBaseTimeUnit().setVal(ctTimeUnit);
        } else {
            ctDateAx.addNewBaseTimeUnit().setVal(ctTimeUnit);
        }
    }

    public static void setMajorTimeUnit(XDDFDateAxis axis, TimeUnit timeUnit) {
        CTDateAx ctDateAx = XDDFDateAxisHelper.getDateAx(axis);
        STTimeUnit.Enum ctTimeUnit = XDDFDateAxisHelper.fromTimeUnit(timeUnit);
        if (ctDateAx.isSetMajorTimeUnit()) {
            ctDateAx.getMajorTimeUnit().setVal(ctTimeUnit);
        } else {
            ctDateAx.addNewMajorTimeUnit().setVal(ctTimeUnit);
        }
    }

    public static void setMinorTimeUnit(XDDFDateAxis axis, TimeUnit timeUnit) {
        CTDateAx ctDateAx = XDDFDateAxisHelper.getDateAx(axis);
        STTimeUnit.Enum ctTimeUnit = XDDFDateAxisHelper.fromTimeUnit(timeUnit);
        if (ctDateAx.isSetMinorTimeUnit()) {
            ctDateAx.getMinorTimeUnit().setVal(ctTimeUnit);
        } else {
            ctDateAx.addNewMinorTimeUnit().setVal(ctTimeUnit);
        }
    }

    private static STTimeUnit.Enum fromTimeUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                return STTimeUnit.DAYS;
            }
            case MONTHS: {
                return STTimeUnit.MONTHS;
            }
            case YEARS: {
                return STTimeUnit.YEARS;
            }
        }
        throw new IllegalArgumentException();
    }

    private static CTDateAx getDateAx(XDDFDateAxis axis) {
        Field ctDateAxField = null;
        try {
            ctDateAxField = Arrays.stream(axis.getClass().getDeclaredFields()).filter(t -> t.getType() == CTDateAx.class).findFirst().get();
            ctDateAxField.setAccessible(true);
            CTDateAx cTDateAx = (CTDateAx)ctDateAxField.get(axis);
            return cTDateAx;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ctDateAxField != null) {
                ctDateAxField.setAccessible(false);
            }
        }
    }

    public static enum TimeUnit {
        DAYS,
        MONTHS,
        YEARS;

    }
}

