/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xddf.usermodel.chart;

import java.lang.reflect.Field;
import org.apache.poi.xddf.usermodel.chart.AxisLabelAlignment;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCatAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChartLines;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STCompoundLine;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineCap;
import org.openxmlformats.schemas.drawingml.x2006.main.STPenAlignment;
import org.openxmlformats.schemas.drawingml.x2006.main.STSchemeColorVal;

public class XDDFCategoryAxisHelper {
    public static void setId(XDDFCategoryAxis axis, long id) {
        axis.getCTAxId().setVal(id);
    }

    public static void setDelete(XDDFCategoryAxis axis, boolean delete) {
        axis.getDelete().setVal(delete);
    }

    public static void setMajorGridline(XDDFCategoryAxis axis, boolean majorGridline) {
        CTCatAx ctCatAx = XDDFCategoryAxisHelper.getCatAx(axis);
        if (majorGridline) {
            XDDFCategoryAxisHelper.fillMajorGridline(ctCatAx.addNewMajorGridlines());
        } else {
            ctCatAx.unsetMajorGridlines();
        }
    }

    private static CTCatAx getCatAx(XDDFCategoryAxis axis) {
        Field ctCatAxField = null;
        try {
            ctCatAxField = axis.getClass().getDeclaredField("ctCatAx");
            ctCatAxField.setAccessible(true);
            CTCatAx cTCatAx = (CTCatAx)ctCatAxField.get(axis);
            return cTCatAx;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            ctCatAxField.setAccessible(false);
        }
    }

    public static void setLabelAlignment(XDDFCategoryAxis axis, AxisLabelAlignment alignment) {
        CTCatAx ctCatAx = XDDFCategoryAxisHelper.getCatAx(axis);
        if (!ctCatAx.isSetLblAlgn()) {
            ctCatAx.addNewLblAlgn();
        }
        ctCatAx.getLblAlgn().setVal(alignment.underlying);
    }

    public static void setLabelOffset(XDDFCategoryAxis axis, int labelOffset) {
        CTCatAx ctCatAx = XDDFCategoryAxisHelper.getCatAx(axis);
        if (!ctCatAx.isSetLblOffset()) {
            ctCatAx.addNewLblOffset();
        }
        ctCatAx.getLblOffset().setVal((Object)labelOffset);
    }

    static void fillMajorGridline(CTChartLines ctChartLines) {
        CTShapeProperties spPr = ctChartLines.addNewSpPr();
        CTLineProperties lnPr = spPr.addNewLn();
        lnPr.setAlgn(STPenAlignment.CTR);
        lnPr.setCap(STLineCap.FLAT);
        lnPr.setCmpd(STCompoundLine.SNG);
        lnPr.setW(9625);
        CTSolidColorFillProperties sfPr = lnPr.addNewSolidFill();
        CTSchemeColor lineColor = sfPr.addNewSchemeClr();
        lineColor.setVal(STSchemeColorVal.TX_1);
        lineColor.addNewLumMod().setVal((Object)15000);
        lineColor.addNewLumOff().setVal((Object)85000);
    }
}

