/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.poi.util.DateTimeFormatUtils;
import org.zkoss.util.CacheMap;
import org.zkoss.util.Pair;

public final class BuiltinFormats {
    public static final int FIRST_USER_DEFINED_FORMAT_INDEX = 164;
    private static final String[] _formats = new String[]{"General", "0", "0.00", "#,##0", "#,##0.00", "\"$\"#,##0_);(\"$\"#,##0)", "\"$\"#,##0_);[Red](\"$\"#,##0)", "\"$\"#,##0.00_);(\"$\"#,##0.00)", "\"$\"#,##0.00_);[Red](\"$\"#,##0.00)", "0%", "0.00%", "0.00E+00", "# ?/?", "# ??/??", "m/d/yyyy", "d-mmm-yy", "d-mmm", "mmm-yy", "h:mm AM/PM", "h:mm:ss AM/PM", "h:mm", "h:mm:ss", "m/d/yyyy h:mm", "reserved-0x17", "reserved-0x18", "reserved-0x19", "reserved-0x1A", "reserved-0x1B", "reserved-0x1C", "reserved-0x1D", "reserved-0x1E", "reserved-0x1F", "reserved-0x20", "reserved-0x21", "reserved-0x22", "reserved-0x23", "reserved-0x24", "#,##0_);(#,##0)", "#,##0_);[Red](#,##0)", "#,##0.00_);(#,##0.00)", "#,##0.00_);[Red](#,##0.00)", "_(* #,##0_);_(* (#,##0);_(* \"-\"_);_(@_)", "_(\"$\"* #,##0_);_(\"$\"* (#,##0);_(\"$\"* \"-\"_);_(@_)", "_(* #,##0.00_);_(* (#,##0.00);_(* \"-\"??_);_(@_)", "_(\"$\"* #,##0.00_);_(\"$\"* (#,##0.00);_(\"$\"* \"-\"??_);_(@_)", "mm:ss", "[h]:mm:ss", "mm:ss.0", "##0.0E+0", "@"};
    private static final CacheMap<Pair<Locale, Integer>, String> _dateFormat = new CacheMap(8);

    public static String[] getAll() {
        return (String[])_formats.clone();
    }

    public static String getBuiltinFormat(int index) {
        if (index < 0 || index >= _formats.length) {
            return null;
        }
        return _formats[index];
    }

    public static int getBuiltinFormat(String pFmt) {
        String fmt = "TEXT".equalsIgnoreCase(pFmt) ? "@" : pFmt;
        int i = -1;
        for (String f : _formats) {
            ++i;
            if (!f.equals(fmt)) continue;
            return i;
        }
        return -1;
    }

    public static String getBuiltinFormat(int index, Locale locale) {
        String fmt = BuiltinFormats.getBuiltinFormat(index);
        if (fmt == null && index != 256) {
            return null;
        }
        if (Locale.US.equals(locale)) {
            return fmt;
        }
        switch (index) {
            case 15: 
            case 16: 
            case 17: {
                fmt = BuiltinFormats.getNameMonthFormat(index, locale);
                break;
            }
            case 14: 
            case 19: 
            case 22: 
            case 256: {
                fmt = BuiltinFormats.getNumMonthFormat(index, locale);
            }
        }
        return fmt;
    }

    private static String getNameMonthFormat(int formatType, Locale locale) {
        Pair key = new Pair((Object)locale, (Object)formatType);
        String result = (String)_dateFormat.get((Object)key);
        if (result != null) {
            return result;
        }
        DateFormat format = DateTimeFormatUtils.getDateInstance(1, locale);
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        format.setTimeZone(gmt);
        String formatString = ((SimpleDateFormat)format).toPattern();
        _dateFormat.put((Object)key, (Object)formatString);
        return formatString;
    }

    private static String getNumMonthFormat(int formatType, Locale locale) {
        Pair key = new Pair((Object)locale, (Object)formatType);
        String result = (String)_dateFormat.get((Object)key);
        if (result != null) {
            return result;
        }
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        DateFormat format = null;
        switch (formatType) {
            case 19: {
                if ("zh".equals(locale.getLanguage())) {
                    String formatString = "hh:mm:ss AM/PM";
                    _dateFormat.put((Object)key, (Object)"hh:mm:ss AM/PM");
                    return "hh:mm:ss AM/PM";
                }
                format = DateTimeFormatUtils.getTimeInstance(2, locale);
                break;
            }
            case 14: {
                format = DateTimeFormatUtils.getDateInstance(2, locale);
                break;
            }
            case 22: {
                format = DateTimeFormatUtils.getDateTimeFormat(2, 3, locale);
                break;
            }
            case 256: {
                if ("zh".equals(locale.getLanguage())) {
                    String formatString = "yyyy/m/d hh:mm:ss AM/PM";
                    _dateFormat.put((Object)key, (Object)"yyyy/m/d hh:mm:ss AM/PM");
                    return "yyyy/m/d hh:mm:ss AM/PM";
                }
                format = DateTimeFormatUtils.getDateTimeFormat(2, 2, locale);
            }
        }
        format.setTimeZone(gmt);
        Calendar cal = Calendar.getInstance(gmt);
        cal.set(1234, 5, 6, 7, 8, 9);
        AttributedCharacterIterator iter = format.formatToCharacterIterator(cal.getTime());
        StringBuilder sb = new StringBuilder();
        int ycount = 0;
        int yindex = -1;
        int mcount = 0;
        boolean alreadyAMPM = false;
        char c = iter.first();
        while (c != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iter.getAttributes();
            if (attrs.isEmpty()) {
                sb.append(c);
            } else {
                block16: for (DateFormat.Field field : attrs.keySet()) {
                    switch (field.getCalendarField()) {
                        case 5: {
                            sb.append('d');
                            continue block16;
                        }
                        case 1: {
                            yindex = sb.length();
                            sb.append('y');
                            ++ycount;
                            continue block16;
                        }
                        case 10: 
                        case 11: {
                            sb.append('h');
                            continue block16;
                        }
                        case 2: {
                            if (mcount >= 2) continue block16;
                            sb.append('m');
                            ++mcount;
                            continue block16;
                        }
                        case 12: {
                            sb.append('m');
                            continue block16;
                        }
                        case 13: {
                            sb.append('s');
                            continue block16;
                        }
                        case 0: 
                        case 9: {
                            if (alreadyAMPM) continue block16;
                            sb.append("AM/PM");
                            alreadyAMPM = true;
                            continue block16;
                        }
                    }
                    if (!DateFormat.Field.HOUR1.equals(field) && !DateFormat.Field.HOUR_OF_DAY1.equals(field) && !DateFormat.Field.HOUR0.equals(field) && !DateFormat.Field.HOUR_OF_DAY0.equals(field)) continue;
                    sb.append('h');
                }
            }
            c = iter.next();
        }
        if (yindex >= 0) {
            for (int k = ycount; k < 4; ++k) {
                sb.insert(yindex, 'y');
            }
        }
        String formatString = sb.toString();
        _dateFormat.put((Object)key, (Object)formatString);
        return formatString;
    }

    static {
        _dateFormat.setLifetime(86400000);
    }
}

