/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.common;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public class XLUnicodeString {
    private static final BitField fHighByte = BitFieldFactory.getInstance(1);
    private short cchCharacters;
    private byte bits;
    private String data;

    public XLUnicodeString(RecordInputStream in) {
        this.cchCharacters = in.readShort();
        this.bits = in.readByte();
        this.data = this.isHighByte() ? in.readUnicodeLEString(this.getCharCount()) : in.readCompressedUnicode(this.getCharCount());
    }

    public XLUnicodeString(String str, boolean highByte) {
        this.setString(str);
        this.setHighByte(highByte);
    }

    public boolean isHighByte() {
        return fHighByte.isSet(this.bits);
    }

    public void setHighByte(boolean flag) {
        this.bits = fHighByte.setByteBoolean(this.bits, flag);
    }

    public int getCharCount() {
        return this.cchCharacters & 0xFFFF;
    }

    public String getString() {
        return this.data;
    }

    public void setString(String str) {
        this.data = str;
        this.cchCharacters = (short)str.length();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.cchCharacters);
        out.writeByte(this.bits);
        if (this.isHighByte()) {
            StringUtil.putUnicodeLE(this.data, out);
        } else {
            StringUtil.putCompressedUnicode(this.data, out);
        }
    }

    public int getDataSize() {
        return 3 + (this.isHighByte() ? 2 * this.getCharCount() : this.getCharCount());
    }

    public void appendString(StringBuffer sb, String prefix) {
        sb.append(prefix).append("[XLUnitcodeString]").append("\n");
        sb.append(prefix).append("    .cchCharacters = ").append(Integer.toString(this.getCharCount())).append("\n");
        sb.append(prefix).append("    .bits          = ").append(HexDump.byteToHex(this.bits)).append("\n");
        sb.append(prefix).append("        .fHighByte     = ").append(this.isHighByte()).append("\n");
        sb.append(prefix).append("    .rgchData      = ").append(this.getString()).append("\n");
        sb.append(prefix).append("[/XLUnitcodeString]").append("\n");
    }
}

