/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xddf.usermodel.chart;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxisHelper;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;

public class XDDFValueAxisHelper {
    public static void setId(XDDFValueAxis axis, long id) {
        axis.getCTAxId().setVal(id);
    }

    public static void setDelete(XDDFValueAxis axis, boolean delete) {
        axis.getDelete().setVal(delete);
    }

    public static void setMajorGridline(XDDFValueAxis axis, boolean majorGridline) {
        CTValAx ctDateAx = XDDFValueAxisHelper.getValAx(axis);
        if (majorGridline) {
            XDDFCategoryAxisHelper.fillMajorGridline(ctDateAx.addNewMajorGridlines());
        } else {
            ctDateAx.unsetMajorGridlines();
        }
    }

    private static CTValAx getValAx(XDDFValueAxis axis) {
        Field ctValAxField = null;
        try {
            ctValAxField = Arrays.stream(axis.getClass().getDeclaredFields()).filter(t -> t.getType() == CTValAx.class).findFirst().get();
            ctValAxField.setAccessible(true);
            CTValAx cTValAx = (CTValAx)ctValAxField.get(axis);
            return cTValAx;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ctValAxField != null) {
                ctValAxField.setAccessible(false);
            }
        }
    }
}

