/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.poi.util.TempFileCreationStrategy;

public class DefaultTempFileCreationStrategy
implements TempFileCreationStrategy {
    public static final String POIFILES = "poifiles";
    public static final String DELETE_FILES_ON_EXIT = "poi.delete.tmp.files.on.exit";
    private volatile File dir;
    private final Lock dirLock = new ReentrantLock();

    public DefaultTempFileCreationStrategy() {
        this(null);
    }

    public DefaultTempFileCreationStrategy(File dir) {
        this.dir = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPOIFilesDirectory() throws IOException {
        if (this.dir == null) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                throw new IOException("System's temporary directory not defined - set the -Djava.io.tmpdir jvm property!");
            }
            this.dirLock.lock();
            try {
                if (this.dir == null) {
                    Path dirPath = Paths.get(tmpDir, POIFILES);
                    File fileDir = dirPath.toFile();
                    if (fileDir.exists()) {
                        if (!fileDir.isDirectory()) {
                            throw new IOException("Could not create temporary directory. '" + String.valueOf(fileDir) + "' exists but is not a directory.");
                        }
                        this.dir = fileDir;
                    } else {
                        this.dir = Files.createDirectories(dirPath, new FileAttribute[0]).toFile();
                    }
                }
            }
            finally {
                this.dirLock.unlock();
            }
        }
    }

    @Override
    public File createTempFile(String prefix, String suffix) throws IOException {
        this.createPOIFilesDirectory();
        File newFile = Files.createTempFile(this.dir.toPath(), prefix, suffix, new FileAttribute[0]).toFile();
        if (System.getProperty(DELETE_FILES_ON_EXIT) != null) {
            newFile.deleteOnExit();
        }
        return newFile;
    }

    @Override
    public File createTempDirectory(String prefix) throws IOException {
        this.createPOIFilesDirectory();
        File newDirectory = Files.createTempDirectory(this.dir.toPath(), prefix, new FileAttribute[0]).toFile();
        newDirectory.deleteOnExit();
        return newDirectory;
    }
}

