/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import java.util.Locale;
import org.apache.poi.ss.format.CellFormatPart;
import org.apache.poi.ss.format.CellFormatType;
import org.apache.poi.ss.format.CellFormatter;
import org.apache.poi.util.LocaleUtil;
import org.zkoss.util.Pair;

public class CellTextFormatter
extends CellFormatter {
    private final int[] textPos;
    private final String desc;

    static CellFormatter getFormatter(FormatterType ft, Locale locale) {
        Pair key = new Pair((Object)ft, (Object)locale);
        CellFormatter formatter = (CellFormatter)_formatters.get(key);
        if (formatter != null) {
            return formatter;
        }
        switch (ft) {
            case SIMPLE_TEXT: {
                formatter = new CellTextFormatter(locale, "@");
            }
        }
        _formatters.put(key, formatter);
        return formatter;
    }

    public CellTextFormatter(String format) {
        this(LocaleUtil.getUserLocale(), format);
    }

    public CellTextFormatter(Locale locale, String format) {
        super(locale, format);
        int[] numPlaces = new int[1];
        this.desc = CellFormatPart.parseFormat(format, CellFormatType.TEXT, (m, part, type, desc) -> {
            if (part.equals("@")) {
                numPlaces[0] = numPlaces[0] + 1;
                return "\u0000";
            }
            return null;
        }).toString();
        this.textPos = new int[numPlaces[0]];
        int pos = this.desc.length() - 1;
        for (int i = 0; i < this.textPos.length; ++i) {
            this.textPos[i] = this.desc.lastIndexOf(0, pos);
            pos = this.textPos[i] - 1;
        }
    }

    @Override
    public void formatValue(StringBuffer toAppendTo, Object obj) {
        int start = toAppendTo.length();
        String text = obj.toString();
        if (obj instanceof Boolean) {
            text = text.toUpperCase(Locale.ROOT);
        }
        if (!this.sectionFourTextFormat && obj instanceof String && this.textPos.length == 0) {
            toAppendTo.append(text);
        } else {
            toAppendTo.append(this.desc);
            for (int textPo : this.textPos) {
                int pos = start + textPo;
                toAppendTo.replace(pos, pos + 1, text);
            }
        }
    }

    @Override
    public void simpleValue(StringBuffer toAppendTo, Object value) {
        CellTextFormatter.getFormatter(FormatterType.SIMPLE_TEXT, this.locale).formatValue(toAppendTo, value);
    }

    static enum FormatterType {
        SIMPLE_TEXT;

    }
}

