/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.token;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.EvaluationName;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.atp.AnalysisToolPak;
import org.apache.poi.ss.formula.function.FunctionMetadata;
import org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.apache.poi.ss.formula.ptg.AddPtg;
import org.apache.poi.ss.formula.ptg.Area3DPtg;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.ArrayPtg;
import org.apache.poi.ss.formula.ptg.AttrPtg;
import org.apache.poi.ss.formula.ptg.BoolPtg;
import org.apache.poi.ss.formula.ptg.ConcatPtg;
import org.apache.poi.ss.formula.ptg.DeferredNamePtg;
import org.apache.poi.ss.formula.ptg.DividePtg;
import org.apache.poi.ss.formula.ptg.EqualPtg;
import org.apache.poi.ss.formula.ptg.ErrPtg;
import org.apache.poi.ss.formula.ptg.FuncPtg;
import org.apache.poi.ss.formula.ptg.FuncVarPtg;
import org.apache.poi.ss.formula.ptg.GreaterEqualPtg;
import org.apache.poi.ss.formula.ptg.GreaterThanPtg;
import org.apache.poi.ss.formula.ptg.IntPtg;
import org.apache.poi.ss.formula.ptg.IntersectionPtg;
import org.apache.poi.ss.formula.ptg.LessEqualPtg;
import org.apache.poi.ss.formula.ptg.LessThanPtg;
import org.apache.poi.ss.formula.ptg.MissingArgPtg;
import org.apache.poi.ss.formula.ptg.MultiplyPtg;
import org.apache.poi.ss.formula.ptg.NotEqualPtg;
import org.apache.poi.ss.formula.ptg.NumberPtg;
import org.apache.poi.ss.formula.ptg.ParenthesisPtg;
import org.apache.poi.ss.formula.ptg.PercentPtg;
import org.apache.poi.ss.formula.ptg.PowerPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.RangePtg;
import org.apache.poi.ss.formula.ptg.Ref3DPtg;
import org.apache.poi.ss.formula.ptg.RefPtg;
import org.apache.poi.ss.formula.ptg.ScalarConstantPtg;
import org.apache.poi.ss.formula.ptg.StringPtg;
import org.apache.poi.ss.formula.ptg.SubtractPtg;
import org.apache.poi.ss.formula.ptg.TablePtg;
import org.apache.poi.ss.formula.ptg.UnaryMinusPtg;
import org.apache.poi.ss.formula.ptg.UnaryPlusPtg;
import org.apache.poi.ss.formula.ptg.UnionPtg;
import org.apache.poi.ss.formula.token.AddNode;
import org.apache.poi.ss.formula.token.AndNode;
import org.apache.poi.ss.formula.token.AreaRefNode;
import org.apache.poi.ss.formula.token.ArrayColumnsNode;
import org.apache.poi.ss.formula.token.BoolNode;
import org.apache.poi.ss.formula.token.ColonNode;
import org.apache.poi.ss.formula.token.CommaNode;
import org.apache.poi.ss.formula.token.DefaultTokenNode;
import org.apache.poi.ss.formula.token.DivNode;
import org.apache.poi.ss.formula.token.DoubleNode;
import org.apache.poi.ss.formula.token.EmptyNode;
import org.apache.poi.ss.formula.token.EqualNode;
import org.apache.poi.ss.formula.token.ErrorNode;
import org.apache.poi.ss.formula.token.ErrorRefNode;
import org.apache.poi.ss.formula.token.ExpNode;
import org.apache.poi.ss.formula.token.ExternalRefNode;
import org.apache.poi.ss.formula.token.FormulaTokenNode;
import org.apache.poi.ss.formula.token.FunctionNode;
import org.apache.poi.ss.formula.token.GreatNode;
import org.apache.poi.ss.formula.token.GreaterThanEqualNode;
import org.apache.poi.ss.formula.token.IntegerNode;
import org.apache.poi.ss.formula.token.LessNode;
import org.apache.poi.ss.formula.token.LessThanEqualNode;
import org.apache.poi.ss.formula.token.MinusNode;
import org.apache.poi.ss.formula.token.MultiNode;
import org.apache.poi.ss.formula.token.NameNode;
import org.apache.poi.ss.formula.token.NameRefNode;
import org.apache.poi.ss.formula.token.NotEqualNode;
import org.apache.poi.ss.formula.token.NumberNode;
import org.apache.poi.ss.formula.token.PercentNode;
import org.apache.poi.ss.formula.token.PlusNode;
import org.apache.poi.ss.formula.token.RefNode;
import org.apache.poi.ss.formula.token.SpaceNode;
import org.apache.poi.ss.formula.token.StringNode;
import org.apache.poi.ss.formula.token.SubtractNode;
import org.apache.poi.ss.formula.token.TableRefNode;
import org.apache.poi.ss.formula.token.TokenNodeVisitor;
import org.apache.poi.ss.formula.token.UnionNode;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.RefUtil;

public class TokenToPtgVisitor
implements TokenNodeVisitor<List<Ptg>> {
    private final LinkedList<Ptg> _stack = new LinkedList();
    private final FormulaParsingWorkbook _book;
    private final int _sheetIndex;
    private final int _rowIndex;
    private final int _colIndex;
    private static final int ROW = 1;
    private static final int COLUMN = 2;
    private static final int CELL = 3;
    int _pointer;
    int _formulaLength;
    String _formulaRefName;
    char look;

    public TokenToPtgVisitor(FormulaParsingWorkbook book, int sheetIndex, int rowIndex, int colIndex) {
        this._book = book;
        this._sheetIndex = sheetIndex;
        this._rowIndex = rowIndex;
        this._colIndex = colIndex;
    }

    @Override
    public List<Ptg> visitAdd(AddNode node) {
        node.visitChildren(this);
        this._stack.add(AddPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitAnd(AndNode node) {
        node.visitChildren(this);
        this._stack.add(ConcatPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitAreaRef(AreaRefNode node) {
        String refString = this.prepareRefString(node.getTopLeft(), node.getBottomRight());
        if (node.getExternalRef() != null) {
            this._formulaRefName = node.getExternalRef().getName();
            this._formulaLength = this._formulaRefName.length();
            String[] extRefInfo = this.parseBookName();
            int i = this._book.getExternalSheetIndex(extRefInfo[0], extRefInfo[1]);
            this._stack.add(new Area3DPtg(refString, i));
        } else {
            this._stack.add(new AreaPtg(new AreaReference(refString, SpreadsheetVersion.EXCEL2007)));
        }
        return this._stack;
    }

    private String prepareRefString(long topLeft, long bottomRight) {
        SpreadsheetVersion version;
        String ref1 = RefUtil.decodeRef(topLeft);
        String ref2 = RefUtil.decodeRef(bottomRight);
        int ref1Type = this.getRefType(ref1);
        int ref2Type = this.getRefType(ref2);
        SpreadsheetVersion spreadsheetVersion = version = this._book == null ? SpreadsheetVersion.EXCEL97 : this._book.getSpreadsheetVersion();
        if (ref1Type == ref2Type) {
            if (ref1Type == 1) {
                return this.getWholeRow(ref1, ref2, version);
            }
            if (ref1Type == 2) {
                return this.getWholeColumn(ref1, ref2, version);
            }
            if (ref1Type == 3) {
                return ref1 + ":" + ref2;
            }
        }
        throw new FormulaParseException("Invalid cell reference: " + ref1 + ":" + ref2);
    }

    private int getRefType(String ref) {
        int len = ref.length();
        int refType = 0;
        for (int i = 0; i < len; ++i) {
            char c = ref.charAt(i);
            if (Character.isDigit(c)) {
                refType |= 1;
            }
            if (!Character.isLetter(c)) continue;
            refType |= 2;
        }
        return refType;
    }

    private String getWholeRow(String ref1, String ref2, SpreadsheetVersion version) {
        return "$A" + ref1 + ":$" + version.getLastColumnName() + ref2;
    }

    private String getWholeColumn(String ref1, String ref2, SpreadsheetVersion version) {
        return ref1 + "$1:" + ref2 + "$" + version.getMaxRows();
    }

    @Override
    public List<Ptg> visitArrayColumns(ArrayColumnsNode node) {
        int rowCount = node.getRowCount();
        int colCount = node.getColCount();
        FormulaTokenNode[][] children = node.getChildren();
        Object[][] newChildren = new Object[rowCount][colCount];
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                FormulaTokenNode child = children[r][c];
                if (child == null) {
                    throw new FormulaParseException("Array item can't be null");
                }
                if (child instanceof NumberNode) {
                    newChildren[r][c] = ((Number)((NumberNode)child).getValue()).doubleValue();
                    continue;
                }
                if (child instanceof DefaultTokenNode) {
                    newChildren[r][c] = ((DefaultTokenNode)child).getValue();
                    continue;
                }
                if (child instanceof ErrorNode) {
                    newChildren[r][c] = child.toString();
                    continue;
                }
                if (child instanceof BoolNode) {
                    newChildren[r][c] = ((BoolNode)child).getValue();
                    continue;
                }
                throw new IllegalArgumentException("Unexpected constant node: " + child.getClass().getName());
            }
        }
        this._stack.add(new ArrayPtg(newChildren));
        return this._stack;
    }

    @Override
    public List<Ptg> visitBoolean(BoolNode node) {
        this._stack.add(BoolPtg.valueOf(node.getValue()));
        return this._stack;
    }

    @Override
    public List<Ptg> visitColon(ColonNode node) {
        node.visitChildren(this);
        this._stack.add(RangePtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitComma(CommaNode node) {
        node.visitChildren(this);
        this._stack.add(UnionPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitDiv(DivNode node) {
        node.visitChildren(this);
        this._stack.add(DividePtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitEmpty(EmptyNode node) {
        this._stack.add(MissingArgPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitEqual(EqualNode node) {
        node.visitChildren(this);
        this._stack.add(EqualPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitError(ErrorNode node) {
        this._stack.add(this._toErrPtg(node));
        return this._stack;
    }

    @Override
    public List<Ptg> visitErrorRef(ErrorRefNode node) {
        this._stack.add(this._toErrPtg(node.getErrorNode()));
        return this._stack;
    }

    @Override
    public List<Ptg> visitExp(ExpNode node) {
        node.visitChildren(this);
        this._stack.add(PowerPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitFunction(FunctionNode node) {
        String name = ((FormulaTokenNode)node.getValue()).toString();
        Ptg namePtg = this.createFunctionNamePtg(name);
        String funName = name.toUpperCase();
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByName(funName);
        int numArgs = node.getChildrenLength();
        if (fm == null) {
            if (namePtg == null) {
                throw new IllegalStateException("NamePtg must be supplied for external functions");
            }
            this._stack.add(AttrPtg.getFunIn(-1));
            this._stack.add(namePtg);
            node.visitChildren(this);
            this._stack.add(FuncVarPtg.create(name, numArgs + 1));
            return this._stack;
        }
        if (namePtg != null) {
            throw new IllegalStateException("NamePtg no applicable to internal functions");
        }
        boolean isVarArgs = !fm.hasFixedArgsLength();
        int funcIdx = fm.getIndex();
        this._stack.add(AttrPtg.getFunIn(funcIdx));
        if (funcIdx == 4 && numArgs == 1) {
            node.visitChildren(this);
            this._stack.add(AttrPtg.getSumSingle());
            return this._stack;
        }
        this.validateNumArgs(numArgs, fm);
        if ("IF".equals(funName)) {
            this.visitIfFunction(node);
        } else {
            List<List<Ptg>> ptgs = node.visitChildren(this);
            if (funcIdx == 228 && ptgs.size() != 0) {
                for (Ptg ptg : ptgs.get(0)) {
                    if (!(ptg instanceof MultiplyPtg)) continue;
                    ((MultiplyPtg)ptg).setOperator(true);
                }
            }
        }
        if (isVarArgs) {
            this._stack.add(FuncVarPtg.create(name, numArgs));
        } else {
            this._stack.add(FuncPtg.create(funcIdx));
        }
        return this._stack;
    }

    private Ptg createNamePtg(String name) {
        return this.createNamePtg(name, null);
    }

    private Ptg createNamePtg(String name, String sheetName) {
        Ptg nameToken;
        EvaluationName hName;
        if (AnalysisToolPak.isATPFunction(name.toUpperCase())) {
            name = name.toUpperCase();
        }
        if ((hName = sheetName == null ? this._book.getName(name, this._sheetIndex) : this._book.getName(name, sheetName)) == null) {
            nameToken = this._book.getNameXPtg(name, null);
            if (nameToken == null) {
                nameToken = this.createPtgForNonExistedName(name);
            }
        } else {
            nameToken = hName.createPtg();
        }
        return nameToken;
    }

    private Ptg createFunctionNamePtg(String name) {
        Ptg nameToken = null;
        if (!AbstractFunctionPtg.isBuiltInFunctionName(name)) {
            EvaluationName hName;
            if (AnalysisToolPak.isATPFunction(name.toUpperCase())) {
                name = name.toUpperCase();
            }
            if ((hName = this._book.getName(name, this._sheetIndex)) == null) {
                nameToken = this._book.getNameXPtg(name, null);
                if (nameToken == null) {
                    nameToken = this.createPtgForNonExistedName(name);
                }
            } else {
                nameToken = hName.createPtg();
            }
        }
        return nameToken;
    }

    private Ptg createPtgForNonExistedName(String nonExistedName) {
        if (this._book.isAllowedDeferredNamePtg()) {
            return new DeferredNamePtg(nonExistedName);
        }
        return this._book.getName(nonExistedName, null).createPtg();
    }

    private void validateNumArgs(int numArgs, FunctionMetadata fm) {
        if (numArgs < fm.getMinParams()) {
            String msg = "Too few arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + fm.getMinParams() : msg + "At least " + fm.getMinParams() + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
        int maxArgs = fm.hasUnlimitedVarags() ? (this._book != null ? this._book.getSpreadsheetVersion().getMaxFunctionArgs() : fm.getMaxParams()) : fm.getMaxParams();
        if (numArgs > maxArgs) {
            String msg = "Too many arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + maxArgs : msg + "At most " + maxArgs + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
    }

    private void visitIfFunction(FunctionNode node) {
        FormulaTokenNode[] children = node.getChildren();
        List<Ptg> conditions = children[0].accept(new TokenToPtgVisitor(this._book, this._sheetIndex, this._rowIndex, this._colIndex));
        int ifAttrIndex = this._stack.size() + conditions.size();
        List<Ptg> trueParam = children[1].accept(new TokenToPtgVisitor(this._book, this._sheetIndex, this._rowIndex, this._colIndex));
        int trueParamSize = trueParam.stream().map(ptg -> ptg.getSize(SpreadsheetVersion.EXCEL2007)).reduce(0, Integer::sum);
        AttrPtg attrIf = AttrPtg.createIf(trueParamSize + 4);
        if (children.length > 2) {
            List<Ptg> falseParam = children[2].accept(new TokenToPtgVisitor(this._book, this._sheetIndex, this._rowIndex, this._colIndex));
            int falseParamSize = falseParam.stream().map(ptg -> ptg.getSize(SpreadsheetVersion.EXCEL2007)).reduce(0, Integer::sum);
            AttrPtg attrSkipAfterTrue = AttrPtg.createSkip(falseParamSize + 4 + 4 - 1);
            AttrPtg attrSkipAfterFalse = AttrPtg.createSkip(3);
            this._stack.addAll(conditions);
            this._stack.add(attrIf);
            this._stack.addAll(trueParam);
            this._stack.add(attrSkipAfterTrue);
            this._stack.addAll(falseParam);
            this._stack.add(attrSkipAfterFalse);
        } else {
            AttrPtg attrSkipAfterTrue = AttrPtg.createSkip(3);
            this._stack.addAll(conditions);
            this._stack.add(attrIf);
            this._stack.addAll(trueParam);
            this._stack.add(attrSkipAfterTrue);
        }
    }

    @Override
    public List<Ptg> visitGreat(GreatNode node) {
        node.visitChildren(this);
        this._stack.add(GreaterThanPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitGreaterThanEqual(GreaterThanEqualNode node) {
        node.visitChildren(this);
        this._stack.add(GreaterEqualPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitLess(LessNode node) {
        node.visitChildren(this);
        this._stack.add(LessThanPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitLessThanEqual(LessThanEqualNode node) {
        node.visitChildren(this);
        this._stack.add(LessEqualPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitMinus(MinusNode node) {
        node.visitChildren(this);
        this._stack.add(UnaryMinusPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitMulti(MultiNode node) {
        node.visitChildren(this);
        this._stack.add(MultiplyPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitName(NameNode node) {
        this._stack.add(this.createNamePtg(node.getValue()));
        return this._stack;
    }

    @Override
    public List<Ptg> visitNameRef(NameRefNode node) {
        ExternalRefNode externalRef = node.getExternalRef();
        if (externalRef == null) {
            this._stack.add(this.createNamePtg(node.getValue()));
        } else {
            this._stack.add(this.createNamePtg(node.getValue(), externalRef.getName()));
        }
        return this._stack;
    }

    @Override
    public List<Ptg> visitNotEqual(NotEqualNode node) {
        node.visitChildren(this);
        this._stack.add(NotEqualPtg.instance);
        return this._stack;
    }

    @Override
    public <T extends Number> List<Ptg> visitNumber(NumberNode<T> node) {
        ScalarConstantPtg ptg = null;
        if (node instanceof IntegerNode) {
            int value = ((IntegerNode)node).getValue();
            ptg = value >= 0 && value <= 65535 ? new IntPtg(value) : new NumberPtg(value);
        } else if (node instanceof DoubleNode) {
            ptg = new NumberPtg(((DoubleNode)node).getValue());
        }
        this._stack.add(ptg);
        return this._stack;
    }

    @Override
    public List<Ptg> visitPercent(PercentNode node) {
        node.visitChildren(this);
        this._stack.add(PercentPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitPlus(PlusNode node) {
        node.visitChildren(this);
        this._stack.add(UnaryPlusPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitRef(RefNode node) {
        long hash = node.getHash();
        if (node.getExternalRef() != null) {
            this._formulaRefName = node.getExternalRef().getName();
            this._formulaLength = this._formulaRefName.length();
            String[] extRefInfo = this.parseBookName();
            int i = this._book.getExternalSheetIndex(extRefInfo[0], extRefInfo[1]);
            this._stack.add(new Ref3DPtg(this.getRowIndex(hash), this.getColIndex(hash), this.isRowRelative(hash), this.isColRelative(hash), i));
        } else {
            this._stack.add(new RefPtg(this.getRowIndex(hash), this.getColIndex(hash), this.isRowRelative(hash), this.isColRelative(hash)));
        }
        return this._stack;
    }

    private String[] parseBookName() {
        String bookName;
        this._pointer = 0;
        this.GetChar();
        if (this.look == '[') {
            StringBuilder sb = new StringBuilder();
            this.GetChar();
            while (this.look != ']') {
                sb.append(this.look);
                this.GetChar();
            }
            this.GetChar();
            bookName = sb.toString();
        } else {
            bookName = null;
        }
        return new String[]{this._book.getBookNameFromExternalLinkIndex(bookName), this._formulaRefName.substring(this._pointer - 1)};
    }

    private void GetChar() {
        if (this._pointer > this._formulaLength) {
            throw new FormulaParseException("string format is incorrect");
        }
        this.look = this._pointer < this._formulaLength ? this._formulaRefName.charAt(this._pointer) : (char)'\u0000';
        ++this._pointer;
    }

    @Override
    public List<Ptg> visitSpace(SpaceNode node) {
        node.visitChildren(this);
        this._stack.add(IntersectionPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitString(StringNode node) {
        this._stack.add(new StringPtg((String)node.getValue()));
        return this._stack;
    }

    @Override
    public List<Ptg> visitSubtract(SubtractNode node) {
        node.visitChildren(this);
        this._stack.add(SubtractPtg.instance);
        return this._stack;
    }

    @Override
    public List<Ptg> visitTableRef(TableRefNode node) {
        Object[] specifier;
        String tableName = node.getName();
        if (tableName.length() == 0) {
            tableName = null;
        }
        String item = node.getItem();
        String column = node.getColumn();
        if (item == null) {
            specifier = new Object[]{};
        } else {
            String specifierString = column == null ? "[" + item + "]" : item + "," + column;
            specifier = new SpecifierParser().parseSpecifiers(specifierString);
        }
        this._stack.add(this._book.createTablePtg(tableName, specifier, this._sheetIndex, this._rowIndex, this._colIndex));
        return this._stack;
    }

    @Override
    public List<Ptg> visitUnion(UnionNode node) {
        node.visitChildren(this);
        this._stack.add(ParenthesisPtg.instance);
        return this._stack;
    }

    private ErrPtg _toErrPtg(ErrorNode node) {
        return ErrPtg.valueOf(node.getErrorCode());
    }

    private int getColIndex(long refHash) {
        return (int)RefUtil.getColIndex(refHash) + 49152;
    }

    private int getRowIndex(long refHash) {
        return (int)RefUtil.getRowIndex(refHash);
    }

    private boolean isColRelative(long refHash) {
        return !RefUtil.isAbsCol(refHash);
    }

    private boolean isRowRelative(long refHash) {
        return !RefUtil.isAbsRow(refHash);
    }

    private class SpecifierParser {
        private String _formulaString;
        private int _formulaLength;
        private int _pointer = 0;
        private char look;

        private SpecifierParser() {
        }

        Object[] parseSpecifiers(String item) {
            this._formulaString = item;
            this._formulaLength = item.length();
            ArrayList<Object> specifiers = new ArrayList<Object>();
            int itemCount = 0;
            int colCount = 0;
            boolean preItem = false;
            boolean preColon = false;
            this.GetChar();
            while (true) {
                Object result;
                if ((result = this.parseSpecifier()) instanceof TablePtg.Item) {
                    if (preColon) {
                        throw new RuntimeException("a legal column name after ':' or maybe should use a ',' instead of a ':' before [" + String.valueOf(result) + "]");
                    }
                    if (++itemCount > 2) {
                        throw new RuntimeException("at most two special item specifier(e.g. #All, #Data, #Headers, #Totals, or #This Row)");
                    }
                } else if (++colCount > 2) {
                    throw new RuntimeException("at most two column specifiers separated with a colon(:) (e.g. [columnX]:[columnY])");
                }
                if (colCount + itemCount > 3) {
                    throw new RuntimeException("at most three specifiers in table expression");
                }
                specifiers.add(result);
                preItem = result instanceof TablePtg.Item;
                if (this._pointer == this._formulaLength) break;
                this.GetChar();
                this.SkipWhite();
                if (',' == this.look) {
                    preColon = false;
                    this.GetChar();
                } else if (':' == this.look) {
                    if (preItem) {
                        throw new RuntimeException("','");
                    }
                    preColon = true;
                    this.GetChar();
                } else if (']' != this.look) {
                    if (preItem) {
                        throw new RuntimeException("',' or ']'");
                    }
                    throw new RuntimeException("',', ':' or ']'");
                }
                this.SkipWhite();
            }
            return specifiers.toArray(new Object[specifiers.size()]);
        }

        private Object parseSpecifier() {
            if (this.look != '[') {
                throw new RuntimeException(this._formulaString);
            }
            this.GetChar();
            return this.parseSpecifier0();
        }

        private Object parseSpecifier0() {
            boolean leadingQuote = false;
            StringBuilder sb = new StringBuilder();
            int j = 0;
            while (true) {
                if (this.look == '\'') {
                    if (leadingQuote) {
                        sb.append("''");
                    }
                    leadingQuote = !leadingQuote;
                } else {
                    switch (this.look) {
                        case '[': {
                            if (!leadingQuote) {
                                throw new RuntimeException("single quote(') before '['");
                            }
                        }
                        case '#': {
                            if (!leadingQuote) {
                                if (j > 0) {
                                    throw new RuntimeException("single quote(') before '#'");
                                }
                            } else {
                                sb.append("'");
                            }
                            sb.append('#');
                            break;
                        }
                        case ']': {
                            if (!leadingQuote) {
                                String result = sb.toString();
                                int sblen = result.length();
                                if (sblen == 0) {
                                    throw new RuntimeException("#All, #Data, #Headers, #Totals, #This Row, or legal column names between [...]");
                                }
                                if (sblen == 1 && "#".equals(result)) {
                                    throw new RuntimeException("#All, #Data, #Headers, #Totals, #This Row between [...] or prepend single quote(') before '#' as a legal column name");
                                }
                                if (result.startsWith("#")) {
                                    TablePtg.Item item = TablePtg.Item.valueOfName(result);
                                    if (item == null) {
                                        throw new RuntimeException("#All, #Data, #Headers, #Totals, or #This Row");
                                    }
                                    return item;
                                }
                                return result;
                            }
                            sb.append("']");
                            break;
                        }
                        default: {
                            if (leadingQuote) {
                                throw new RuntimeException("'[', ']', '#', or single quote(') after single quote(')");
                            }
                            sb.append(this.look);
                        }
                    }
                    leadingQuote = false;
                }
                this.GetChar();
                ++j;
            }
        }

        private void GetChar() {
            if (this._pointer > this._formulaLength) {
                throw new FormulaParseException("string format is incorrect");
            }
            this.look = this._pointer < this._formulaLength ? this._formulaString.charAt(this._pointer) : (char)'\u0000';
            ++this._pointer;
        }

        private void SkipWhite() {
            while (this.look == ' ' || this.look == '\t' || this.look == '\r' || this.look == '\n') {
                this.GetChar();
            }
        }
    }
}

