/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Locale;
import java.util.Stack;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.ExternSheetReferenceToken;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.WorkbookDependentFormula;
import org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.apache.poi.ss.formula.ptg.ArrayPtg;
import org.apache.poi.ss.formula.ptg.AttrPtg;
import org.apache.poi.ss.formula.ptg.MemAreaPtg;
import org.apache.poi.ss.formula.ptg.MemErrPtg;
import org.apache.poi.ss.formula.ptg.MemFuncPtg;
import org.apache.poi.ss.formula.ptg.NumberPtg;
import org.apache.poi.ss.formula.ptg.OperationPtg;
import org.apache.poi.ss.formula.ptg.Parenthesis2Ptg;
import org.apache.poi.ss.formula.ptg.ParenthesisPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.TablePtg;
import org.apache.poi.ss.usermodel.ZssContext;
import org.apache.poi.util.Internal;

@Internal
public class FormulaRenderer {
    public static String toFormulaString(FormulaRenderingWorkbook book, Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            throw new IllegalArgumentException("ptgs must not be null");
        }
        Stack<String> stack = new Stack<String>();
        for (Ptg ptg : ptgs) {
            String[] operands;
            if (ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof Parenthesis2Ptg) {
                Parenthesis2Ptg parenPtg = (Parenthesis2Ptg)ptg;
                operands = FormulaRenderer.getOperands(stack, parenPtg.getNumberOfOperands());
                stack.push(parenPtg.toFormulaString(operands));
                continue;
            }
            if (ptg instanceof ParenthesisPtg) {
                String[] operands2 = FormulaRenderer.getOperands(stack, 1);
                stack.push(((ParenthesisPtg)ptg).toFormulaString(operands2));
                continue;
            }
            if (ptg instanceof AttrPtg) {
                AttrPtg attrPtg = (AttrPtg)ptg;
                if (attrPtg.isOptimizedIf() || attrPtg.isOptimizedChoose() || attrPtg.isSkip() || attrPtg.isSpace() || attrPtg.isSemiVolatile()) continue;
                if (attrPtg.isSum()) {
                    operands = FormulaRenderer.getOperands(stack, attrPtg.getNumberOfOperands());
                    stack.push(attrPtg.toFormulaString(operands));
                    continue;
                }
                if (attrPtg.isFunIn()) continue;
                throw new IllegalStateException("Unexpected tAttr: " + attrPtg.toString());
            }
            if (ptg instanceof WorkbookDependentFormula) {
                WorkbookDependentFormula optg = (WorkbookDependentFormula)((Object)ptg);
                stack.push(optg.toFormulaString(book));
                continue;
            }
            if (!(ptg instanceof OperationPtg)) {
                stack.push(ptg.toFormulaString());
                continue;
            }
            OperationPtg o = (OperationPtg)ptg;
            operands = FormulaRenderer.getOperands(stack, o.getNumberOfOperands());
            stack.push(o.toFormulaString(operands));
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        String result = (String)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("too much stuff left on the stack");
        }
        return result;
    }

    private static String[] getOperands(Stack<String> stack, int nOperands) {
        String[] operands = new String[nOperands];
        for (int j = nOperands - 1; j >= 0; --j) {
            if (stack.isEmpty()) {
                String msg = "Too few arguments supplied to operation. Expected (" + nOperands + ") operands but got (" + (nOperands - j - 1) + ")";
                throw new IllegalStateException(msg);
            }
            operands[j] = stack.pop();
        }
        return operands;
    }

    public static String toInternalFormulaString(FormulaRenderingWorkbook book, Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            throw new IllegalArgumentException("ptgs must not be null");
        }
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < ptgs.length; ++i) {
            String[] operands;
            Ptg ptg = ptgs[i];
            if (ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof ParenthesisPtg || ptg instanceof Parenthesis2Ptg) {
                String contents = (String)stack.pop();
                stack.push("(" + contents + ")");
                continue;
            }
            if (ptg instanceof AttrPtg) {
                AttrPtg attrPtg = (AttrPtg)ptg;
                if (attrPtg.isOptimizedIf() || attrPtg.isOptimizedChoose() || attrPtg.isSkip() || attrPtg.isSpace() || attrPtg.isSemiVolatile()) continue;
                if (attrPtg.isSum()) {
                    operands = FormulaRenderer.getOperands(stack, attrPtg.getNumberOfOperands());
                    stack.push(attrPtg.toFormulaString(operands));
                    continue;
                }
                if (attrPtg.isFunIn()) continue;
                throw new RuntimeException("Unexpected tAttr: " + attrPtg.toString());
            }
            if (ptg instanceof WorkbookDependentFormula) {
                WorkbookDependentFormula optg = (WorkbookDependentFormula)((Object)ptg);
                stack.push(optg.toInternalFormulaString(book));
                continue;
            }
            if (ptg instanceof NumberPtg) {
                stack.push(((NumberPtg)ptg).toInternalFormulaString());
                continue;
            }
            if (ptg instanceof ArrayPtg) {
                stack.push(((ArrayPtg)ptg).toInternalFormulaString());
                continue;
            }
            if (!(ptg instanceof OperationPtg)) {
                stack.push(ptg.toFormulaString());
                continue;
            }
            OperationPtg o = (OperationPtg)ptg;
            operands = FormulaRenderer.getOperands(stack, o.getNumberOfOperands());
            stack.push(o.toInternalFormulaString(operands));
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        String result = (String)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("too much stuff left on the stack");
        }
        return result;
    }

    public static String toFormulaEditText(FormulaRenderingWorkbook book, Ptg[] tokens, String formula) {
        boolean hit = false;
        for (Ptg token : tokens) {
            ExternSheetReferenceToken externalRef;
            EvaluationWorkbook.ExternalSheet externalSheet;
            if (token instanceof ExternSheetReferenceToken && (externalSheet = book.getExternalSheet((externalRef = (ExternSheetReferenceToken)((Object)token)).getExternSheetIndex())) != null) {
                hit = true;
                break;
            }
            if (!(token instanceof NumberPtg) && !(token instanceof AbstractFunctionPtg) && !(token instanceof ArrayPtg)) continue;
            hit = true;
            break;
        }
        return hit ? FormulaRenderer.toFormulaString(book, tokens) : formula;
    }

    public static Ptg[][] unwrapPtgArrays(Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            throw new IllegalArgumentException("ptgs must not be null");
        }
        Stack<Object> stack = new Stack<Object>();
        for (int i = 0; i < ptgs.length; ++i) {
            Ptg[] operands;
            Ptg ptg = ptgs[i];
            if (ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof Parenthesis2Ptg) {
                Parenthesis2Ptg parenPtg = (Parenthesis2Ptg)ptg;
                stack.push(FormulaRenderer.getPtgs(stack, parenPtg, parenPtg.getNumberOfOperands()));
                continue;
            }
            if (ptg instanceof ParenthesisPtg) {
                stack.push(FormulaRenderer.getPtgs(stack, ptg, 1));
                continue;
            }
            if (ptg instanceof AttrPtg) {
                AttrPtg attrPtg = (AttrPtg)ptg;
                if (attrPtg.isOptimizedIf() || attrPtg.isOptimizedChoose() || attrPtg.isSkip() || attrPtg.isSpace() || attrPtg.isSemiVolatile()) continue;
                if (attrPtg.isSum()) {
                    operands = FormulaRenderer.getPtgs(stack, attrPtg, attrPtg.getNumberOfOperands());
                    stack.push(operands);
                    continue;
                }
                if (attrPtg.isFunIn()) continue;
                throw new RuntimeException("Unexpected tAttr: " + attrPtg.toString());
            }
            if (ptg instanceof WorkbookDependentFormula) {
                WorkbookDependentFormula optg = (WorkbookDependentFormula)((Object)ptg);
                stack.push(optg);
                continue;
            }
            if (!(ptg instanceof OperationPtg)) {
                stack.push(ptg);
                continue;
            }
            OperationPtg o = (OperationPtg)ptg;
            operands = FormulaRenderer.getPtgs(stack, o, o.getNumberOfOperands());
            stack.push(operands);
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        Object result = stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("too much stuff left on the stack");
        }
        return (Ptg[][])result;
    }

    private static Ptg[] getPtgs(Stack<Object> stack, Ptg ptg, int nOperands) {
        Ptg[] operands = new Ptg[nOperands + 1];
        for (int j = nOperands - 1; j >= 0; --j) {
            if (stack.isEmpty()) {
                String msg = "Too few arguments supplied to operation. Expected (" + nOperands + ") operands but got (" + (nOperands - j - 1) + ")";
                throw new IllegalStateException(msg);
            }
            operands[j] = (Ptg)stack.pop();
        }
        operands[nOperands] = ptg;
        return operands;
    }

    public static String toFormulaCopyText(FormulaRenderingWorkbook book, Ptg[] tokens, String formula) {
        boolean hit = false;
        for (Ptg token : tokens) {
            ExternSheetReferenceToken externalRef;
            EvaluationWorkbook.ExternalSheet externalSheet;
            if (token instanceof ExternSheetReferenceToken && (externalSheet = book.getExternalSheet((externalRef = (ExternSheetReferenceToken)((Object)token)).getExternSheetIndex())) != null) {
                hit = true;
                break;
            }
            if (!(token instanceof TablePtg)) continue;
            hit = true;
            break;
        }
        return hit ? FormulaRenderer.toCopyFormulaString(book, tokens) : formula;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toCopyFormulaString(FormulaRenderingWorkbook book, Ptg[] ptgs) {
        ZssContext old = ZssContext.getThreadLocal();
        try {
            ZssContext zssContext = old == null ? new ZssContext(Locale.US, -1) : new ZssContext(Locale.US, old.getTwoDigitYearUpperBound());
            ZssContext.setThreadLocal(zssContext);
            String string = FormulaRenderer.toCopyFormulaString0(book, ptgs);
            return string;
        }
        finally {
            ZssContext.setThreadLocal(old);
        }
    }

    private static String toCopyFormulaString0(FormulaRenderingWorkbook book, Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            throw new IllegalArgumentException("ptgs must not be null");
        }
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < ptgs.length; ++i) {
            String[] operands;
            Ptg ptg = ptgs[i];
            if (ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof Parenthesis2Ptg) {
                Parenthesis2Ptg parenPtg = (Parenthesis2Ptg)ptg;
                operands = FormulaRenderer.getOperands(stack, parenPtg.getNumberOfOperands());
                stack.push(parenPtg.toFormulaString(operands));
                continue;
            }
            if (ptg instanceof ParenthesisPtg) {
                String[] operands2 = FormulaRenderer.getOperands(stack, 1);
                stack.push(((ParenthesisPtg)ptg).toFormulaString(operands2));
                continue;
            }
            if (ptg instanceof AttrPtg) {
                AttrPtg attrPtg = (AttrPtg)ptg;
                if (attrPtg.isOptimizedIf() || attrPtg.isOptimizedChoose() || attrPtg.isSkip() || attrPtg.isSpace() || attrPtg.isSemiVolatile()) continue;
                if (attrPtg.isSum()) {
                    operands = FormulaRenderer.getOperands(stack, attrPtg.getNumberOfOperands());
                    stack.push(attrPtg.toFormulaString(operands));
                    continue;
                }
                if (attrPtg.isFunIn()) continue;
                throw new RuntimeException("Unexpected tAttr: " + attrPtg.toString());
            }
            if (ptg instanceof TablePtg) {
                stack.push(((TablePtg)ptg).toCopyFormulaString());
                continue;
            }
            if (ptg instanceof WorkbookDependentFormula) {
                WorkbookDependentFormula optg = (WorkbookDependentFormula)((Object)ptg);
                stack.push(optg.toFormulaString(book));
                continue;
            }
            if (!(ptg instanceof OperationPtg)) {
                stack.push(ptg.toFormulaString());
                continue;
            }
            OperationPtg o = (OperationPtg)ptg;
            operands = FormulaRenderer.getOperands(stack, o.getNumberOfOperands());
            stack.push(o.toFormulaString(operands));
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        String result = (String)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("too much stuff left on the stack");
        }
        return result;
    }
}

