/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public class FullColorExt {
    private short xclrType;
    private short nTintShade;
    private int xclrValue;
    private byte[] unused = new byte[8];
    private static final int[] DEFAULT_THEME = new int[]{0xFFFFFF, 0, 0xEEECE1, 2050429, 5210557, 12603469, 0x9BBB59, 8414370, 4959430, 16225862, 255, 0x800080};

    public FullColorExt(RecordInputStream in) {
        this.xclrType = in.readShort();
        this.nTintShade = in.readShort();
        this.xclrValue = in.readInt();
        in.read(this.unused, 0, this.unused.length);
    }

    public FullColorExt(short r, short g, short b) {
        this.xclrType = (short)2;
        this.nTintShade = 0;
        this.xclrValue = 0xFF000000 | b << 16 & 0xFF0000 | g << 8 & 0xFF00 | r & 0xFF;
    }

    public FullColorExt(short xclrType, short nTintShade, int xclrValue) {
        this.xclrType = xclrType;
        this.nTintShade = nTintShade;
        this.xclrValue = xclrValue;
    }

    public int getDataSize() {
        return 16;
    }

    public boolean isTheme() {
        return this.xclrType == 3;
    }

    public boolean isRGB() {
        return this.xclrType == 2;
    }

    public boolean isIndex() {
        return this.xclrType == 1;
    }

    public void appendString(StringBuffer sb, String prefix) {
        sb.append(prefix).append(".xclrType  =").append(this.xclrType).append("\n");
        sb.append(prefix).append(".nTintShade=").append(this.nTintShade).append("\n");
        sb.append(prefix).append(".xclrValue =").append(HexDump.intToHex(this.xclrValue)).append("\n");
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.xclrType);
        out.writeShort(this.nTintShade);
        out.writeInt(this.xclrValue);
        out.write(this.unused);
    }

    public short getXclrType() {
        return this.xclrType;
    }

    public void setXclrType(short xclrType) {
        this.xclrType = xclrType;
    }

    public short getTintShade() {
        return this.nTintShade;
    }

    public void setTintShade(short nTintShade) {
        this.nTintShade = nTintShade;
    }

    public int getXclrValue() {
        return this.xclrValue;
    }

    public void setXclrValue(int xclrValue) {
        this.xclrValue = xclrValue;
    }

    private int BGRToRGB() {
        return this.xclrValue & 0xFF000000 | this.xclrValue << 16 & 0xFF0000 | this.xclrValue & 0xFF00 | this.xclrValue >> 16 & 0xFF;
    }

    public int getRGB() {
        if (this.isRGB()) {
            return this.BGRToRGB();
        }
        if (this.isTheme()) {
            return DEFAULT_THEME[this.getXclrValue()];
        }
        if (this.isIndex()) {
            throw new RuntimeException("XFExt with color table is not supported yet:" + this.getXclrValue());
        }
        return -1;
    }

    public boolean isTint() {
        return this.nTintShade != 0;
    }

    public double getTint() {
        return (double)this.nTintShade / 32767.0;
    }
}

