/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.lang.reflect.Field;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageSetup;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellComments;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPrintError;

public class XSSFPrintSetupHelper {
    public static void setErrorsMode(XSSFPrintSetup printSetup, int mode) {
        if (mode < 0 || mode > 3) {
            mode = 0;
        }
        XSSFPrintSetupHelper.getCtPageSetup(printSetup).setErrors(STPrintError.Enum.forInt((int)(mode + 1)));
    }

    public static void setCommentsMode(XSSFPrintSetup printSetup, int mode) {
        XSSFPrintSetupHelper.getCtPageSetup(printSetup).setCellComments(STCellComments.Enum.forInt((int)(mode + 1)));
    }

    private static CTPageSetup getCtPageSetup(XSSFPrintSetup printSetup) {
        Field pageSetupField = null;
        try {
            pageSetupField = printSetup.getClass().getDeclaredField("pageSetup");
            pageSetupField.setAccessible(true);
            CTPageSetup cTPageSetup = (CTPageSetup)pageSetupField.get(printSetup);
            return cTPageSetup;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (pageSetupField != null) {
                pageSetupField.setAccessible(false);
            }
        }
    }
}

