/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.token;

import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.FormulaTokenParser;
import org.apache.poi.ss.formula.token.ExternalRefNode;
import org.apache.poi.ss.formula.token.FormulaTokenNode;
import org.apache.poi.ss.formula.token.NodeId;
import org.apache.poi.ss.formula.token.TokenNodeVisitor;
import org.apache.poi.ss.util.RefUtil;

public class RefNode
implements FormulaTokenNode {
    private final long hash;
    protected ExternalRefNode externalRef;

    public RefNode(long hash) {
        this.hash = hash;
    }

    public RefNode(long hash, ExternalRefNode externalRef) {
        this.hash = hash;
        this.externalRef = externalRef;
    }

    public long getHash() {
        return this.hash;
    }

    public ExternalRefNode getExternalRef() {
        return this.externalRef;
    }

    public void setExternalRef(ExternalRefNode externalRef) {
        this.externalRef = externalRef;
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.RefNode;
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public boolean hasOperands() {
        return true;
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public boolean add(FormulaTokenNode child) {
        throw new FormulaParseException("Simple operand should not have any child");
    }

    @Override
    public FormulaTokenNode normalize(FormulaTokenParser parser) {
        return this;
    }

    @Override
    public <R> R accept(TokenNodeVisitor<R> visitor) {
        return visitor.visitRef(this);
    }

    @Override
    public <R> List<R> visitChildren(TokenNodeVisitor<R> visitor) {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.externalRef != null) {
            sb.append(this.externalRef.toString());
            sb.append('!');
        }
        sb.append(RefUtil.decodeRef(this.hash));
        return sb.toString();
    }
}

