/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.util;

import io.keikai.util.Converter;

public class Ref {
    public static int MAX_COL = 16384;
    public static int MAX_ROW = 0x100000;
    private int left;
    private int top;
    private int right;
    private int bottom;

    Ref(int left, int top) {
        this.left = left;
        this.top = top;
        this.right = left;
        this.bottom = top;
    }

    Ref(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public boolean isCell() {
        return this.top == this.bottom && this.left == this.right;
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public String toString() {
        return Converter.refToA1(this);
    }

    public int getCount() {
        return this.getColumnCount() * this.getRowCount();
    }

    public int getRowCount() {
        if (this.isCell()) {
            return 1;
        }
        return this.bottom - this.top + 1;
    }

    public int getColumnCount() {
        if (this.isCell()) {
            return 1;
        }
        return this.right - this.left + 1;
    }
}

