/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SFill;
import io.keikai.model.SFillBuilder;
import io.keikai.model.impl.BookImpl;
import io.keikai.model.impl.DefaultStyle;
import io.keikai.model.impl.ImmutableFillImpl;

public class FillBuilderImpl
implements SFillBuilder {
    private final BookImpl bookImpl;
    private final boolean inStyleTable;
    private String fillColor;
    private String backColor;
    private SFill.FillPattern fillPattern;

    public FillBuilderImpl(BookImpl bookImpl) {
        this(bookImpl, null);
    }

    public FillBuilderImpl(BookImpl bookImpl, SFill src) {
        this.bookImpl = bookImpl;
        boolean bl = this.inStyleTable = bookImpl != null;
        if (src != null) {
            this.fillPattern = src.getFillPattern();
            this.fillColor = src.getFillColor().getHtmlColor();
            this.backColor = src.getBackColor().getHtmlColor();
        } else {
            this.fillPattern = DefaultStyle.FILL_PATTERN;
            this.fillColor = DefaultStyle.FONT_COLOR.getHtmlColor();
            this.backColor = DefaultStyle.BACK_COLOR.getHtmlColor();
        }
    }

    @Override
    public SFill build() {
        if (this.inStyleTable) {
            return new ImmutableFillImpl(this.fillPattern, this.bookImpl.createColor(this.fillColor), this.bookImpl.createColor(this.backColor));
        }
        return new ImmutableFillImpl(this.fillPattern, this.fillColor, this.backColor);
    }

    @Override
    public SFillBuilder fillColor(String color) {
        this.fillColor = color;
        return this;
    }

    @Override
    public SFillBuilder backColor(String color) {
        this.backColor = color;
        return this;
    }

    @Override
    public SFillBuilder fillPattern(SFill.FillPattern pattern) {
        this.fillPattern = pattern;
        return this;
    }
}

