/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.sys;

import io.keikai.model.impl.sys.CalendarUtilImpl;
import io.keikai.model.impl.sys.DependencyTableImpl;
import io.keikai.model.impl.sys.FormatEngineImpl;
import io.keikai.model.impl.sys.InputEngineImpl;
import io.keikai.model.impl.sys.formula.FormulaEngineImpl;
import io.keikai.model.sys.CalendarUtil;
import io.keikai.model.sys.dependency.DependencyTable;
import io.keikai.model.sys.format.FormatEngine;
import io.keikai.model.sys.formula.FormulaEngine;
import io.keikai.model.sys.input.InputEngine;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;

public class EngineFactory {
    private static final Logger _logger = LoggerFactory.getLogger(EngineFactory.class);
    private static EngineFactory _instance;
    private static CalendarUtil _calendarUtil;
    private int _maxIters;
    private double _maxChange;
    static InputEngine _inputEngine;
    static Class<?> inputEngineClazz;
    static Class<?> formulaEngineClazz;
    static Class<?> dependencyTableClazz;
    static FormatEngine _formatEngine;
    static Class<?> formatEngineClazz;

    private EngineFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EngineFactory getInstance() {
        if (_instance != null) return _instance;
        Class<EngineFactory> clazz = EngineFactory.class;
        synchronized (EngineFactory.class) {
            if (_instance != null) return _instance;
            _instance = new EngineFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public InputEngine createInputEngine() {
        if (_inputEngine == null) {
            try {
                if (inputEngineClazz != null) {
                    _inputEngine = (InputEngine)inputEngineClazz.newInstance();
                    return _inputEngine;
                }
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
                inputEngineClazz = null;
            }
            _inputEngine = new InputEngineImpl();
        }
        return _inputEngine;
    }

    public FormulaEngine createFormulaEngine() {
        try {
            if (formulaEngineClazz != null) {
                return (FormulaEngine)formulaEngineClazz.newInstance();
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            formulaEngineClazz = null;
        }
        return new FormulaEngineImpl();
    }

    public DependencyTable createDependencyTable() {
        try {
            if (dependencyTableClazz != null) {
                return (DependencyTable)dependencyTableClazz.newInstance();
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            dependencyTableClazz = null;
        }
        return new DependencyTableImpl();
    }

    public FormatEngine createFormatEngine() {
        if (_formatEngine == null) {
            try {
                if (formatEngineClazz != null) {
                    _formatEngine = (FormatEngine)formatEngineClazz.newInstance();
                    return _formatEngine;
                }
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
                formatEngineClazz = null;
            }
            _formatEngine = new FormatEngineImpl();
        }
        return _formatEngine;
    }

    public CalendarUtil getCalendarUtil() {
        return _calendarUtil;
    }

    static {
        _calendarUtil = new CalendarUtilImpl();
        String clz = Optional.ofNullable(Library.getProperty((String)"io.keikai.model.InputEngine.class")).orElse(Library.getProperty((String)"org.zkoss.zss.model.InputEngine.class"));
        if (clz != null) {
            try {
                inputEngineClazz = Class.forName(clz);
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((clz = Optional.ofNullable(Library.getProperty((String)"io.keikai.model.FormulaEngine.class")).orElse(Library.getProperty((String)"org.zkoss.zss.model.FormulaEngine.class"))) != null) {
            try {
                formulaEngineClazz = Class.forName(clz);
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((clz = Optional.ofNullable(Library.getProperty((String)"io.keikai.model.DependencyTable.class")).orElse(Library.getProperty((String)"org.zkoss.zss.model.DependencyTable.class"))) != null) {
            try {
                dependencyTableClazz = Class.forName(clz);
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((clz = Optional.ofNullable(Library.getProperty((String)"io.keikai.model.FormatEngine.class")).orElse(Library.getProperty((String)"org.zkoss.zss.model.FormatEngine.class"))) != null) {
            try {
                formatEngineClazz = Class.forName(clz);
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

