/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.sys.formula;

import io.keikai.model.SBook;
import io.keikai.model.SName;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractNameAdv;
import io.keikai.model.impl.sys.formula.EvalSheet;
import io.keikai.model.impl.sys.formula.ParsingBook;
import io.keikai.model.sys.formula.FormulaExpression;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationName;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaTokenParser;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.SheetIdentifier;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.ptg.NamePtg;
import org.apache.poi.ss.formula.ptg.NameXPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.TablePtg;
import org.apache.poi.ss.formula.udf.AggregatingUDFFinder;
import org.apache.poi.ss.formula.udf.IndexedUDFFinder;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Table;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;

public final class EvalBook
implements EvaluationWorkbook,
FormulaParsingWorkbook,
Serializable {
    private static final long serialVersionUID = 296252202526323617L;
    private SBook _nbook;
    private IndexedUDFFinder _udfFinder = new IndexedUDFFinder(new UDFFinder[]{AggregatingUDFFinder.DEFAULT});
    private ParsingBook _parsingBook;

    public EvalBook(SBook book) {
        this._nbook = book;
        this.createParsingBook();
    }

    private void createParsingBook() {
        this._parsingBook = new ParsingBook(this._nbook);
    }

    public SBook getNBook() {
        return this._nbook;
    }

    public Ptg[] getFormulaTokens(EvaluationCell cell) {
        FormulaExpression fexpr = ((EvalSheet.EvalCell)cell).getFormulaExpression();
        return fexpr != null ? fexpr.getPtgs() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ptg[] getFormulaTokens(int sheetIndex, String formula) {
        EvalBook evalBook = this;
        synchronized (evalBook) {
            this.createParsingBook();
            return FormulaTokenParser.parse((String)formula, (FormulaParsingWorkbook)this._parsingBook, (int)sheetIndex, (FormulaType)FormulaType.CELL);
        }
    }

    public EvaluationName getName(String name, int sheetIndex) {
        SName nname = null;
        if (sheetIndex < 0) {
            nname = this._nbook.getNameByName(name);
        } else {
            SSheet sheet = this._nbook.getSheet(sheetIndex);
            if (sheet != null) {
                nname = this._nbook.getNameByName(name, sheet.getSheetName());
            }
        }
        if (nname != null) {
            int index = this._nbook.getNames().indexOf(nname);
            return new EvalName(name, index, ((AbstractNameAdv)nname).getRefersToFormulaExpression(), sheetIndex);
        }
        return null;
    }

    public EvaluationName getName(NamePtg namePtg) {
        return this.getName(namePtg, -1);
    }

    public EvaluationName getName(NamePtg namePtg, int contextSheetIndex) {
        Object[] nameInfo = this._parsingBook.getNameInfo(namePtg);
        String name = (String)nameInfo[1];
        if (name != null) {
            SName nname;
            int externSheetIndex = (Integer)nameInfo[0];
            String sheetName = null;
            if (externSheetIndex >= 0) {
                sheetName = this._parsingBook.getSheetNameByExternSheet(externSheetIndex);
            }
            if (sheetName == null && contextSheetIndex >= 0) {
                sheetName = this._nbook.getSheet(contextSheetIndex).getSheetName();
            }
            if ((nname = this._nbook.getNameByName(name, sheetName)) != null) {
                return new EvalName(name, namePtg.getIndex(), ((AbstractNameAdv)nname).getRefersToFormulaExpression(), this._nbook.getSheetIndex(sheetName));
            }
            if (sheetName != null && (nname = this._nbook.getNameByName(name, null)) != null) {
                return new EvalName(name, namePtg.getIndex(), ((AbstractNameAdv)nname).getRefersToFormulaExpression(), -1);
            }
        }
        return new EvalName(name, namePtg.getIndex(), null, -1);
    }

    public EvaluationWorkbook.ExternalName getExternalName(int externSheetIndex, int externNameIndex) {
        throw new RuntimeException("Not implemented yet");
    }

    public UDFFinder getUDFFinder() {
        return this._udfFinder;
    }

    public EvaluationSheet getSheet(int sheetIndex) {
        SSheet sheet = this._nbook.getSheet(sheetIndex);
        return sheet != null ? new EvalSheet(sheet) : null;
    }

    public int getSheetIndex(EvaluationSheet evalSheet) {
        if (evalSheet instanceof EvalSheet) {
            SSheet sheet = ((EvalSheet)evalSheet).getNSheet();
            return this._nbook.getSheetIndex(sheet);
        }
        return -1;
    }

    public int getSheetIndex(String sheetName) {
        SSheet sheet = this._nbook.getSheetByName(sheetName);
        return sheet != null ? this._nbook.getSheetIndex(sheet) : -1;
    }

    public String getSheetName(int sheetIndex) {
        SSheet sheet = this._nbook.getSheet(sheetIndex);
        return sheet != null ? sheet.getSheetName() : null;
    }

    public EvaluationWorkbook.ExternalSheet getExternalSheet(int externSheetIndex) {
        return this._parsingBook.getExternalSheet(externSheetIndex);
    }

    public String resolveNameXText(NameXPtg n) {
        String name = this._parsingBook.resolveNameXText(n);
        FreeRefFunction function = this._udfFinder.findFunction(name);
        return function != null ? name : null;
    }

    public int convertFromExternSheetIndex(int externSheetIndex) {
        EvaluationWorkbook.ExternalSheetRange sheet = this._parsingBook.getAnyExternalSheet(externSheetIndex);
        if (sheet != null && sheet.getWorkbookName() == null) {
            return this.getSheetIndex(sheet.getSheetName());
        }
        return -1;
    }

    public int convertLastIndexFromExternSheetIndex(int externSheetIndex) {
        EvaluationWorkbook.ExternalSheetRange sheet = this._parsingBook.getAnyExternalSheet(externSheetIndex);
        if (sheet != null && sheet.getWorkbookName() == null) {
            return this.getSheetIndex(sheet.getLastSheetName());
        }
        return -1;
    }

    public int getExternalSheetIndex(String sheetName) {
        return this._parsingBook.getExternalSheetIndex(sheetName);
    }

    public int getExternalSheetIndex(String workbookName, String sheetName) {
        return this._parsingBook.getExternalSheetIndex(workbookName, sheetName);
    }

    public EvaluationWorkbook.ExternalSheet getExternalSheet(String firstSheetName, String lastSheetName, int externalWorkbookNumber) {
        String workbookName = externalWorkbookNumber > 0 ? this._parsingBook.getBookNameFromExternalLinkIndex(String.valueOf(externalWorkbookNumber)) : null;
        if (lastSheetName == null || firstSheetName.equals(lastSheetName)) {
            return new EvaluationWorkbook.ExternalSheet(workbookName, firstSheetName);
        }
        return new EvaluationWorkbook.ExternalSheetRange(workbookName, firstSheetName, lastSheetName);
    }

    public EvaluationWorkbook.ExternalName getExternalName(String nameName, String sheetName, int externalWorkbookNumber) {
        throw new IllegalStateException("HSSF-style external references are not supported for XSSF");
    }

    public void clearAllCachedResultValues() {
    }

    public Name createName() {
        return null;
    }

    public Table getTable(String name) {
        return null;
    }

    public Ptg getNameXPtg(String name, SheetIdentifier sheet) {
        return null;
    }

    public Ptg get3DReferencePtg(CellReference cell, SheetIdentifier sheet) {
        return null;
    }

    public Ptg get3DReferencePtg(AreaReference area, SheetIdentifier sheet) {
        return null;
    }

    public SpreadsheetVersion getSpreadsheetVersion() {
        return this._parsingBook.getSpreadsheetVersion();
    }

    public String getBookNameFromExternalLinkIndex(String externalLinkIndex) {
        return this._parsingBook.getBookNameFromExternalLinkIndex(externalLinkIndex);
    }

    public EvaluationName getOrCreateName(String name, int sheetIndex) {
        return this._parsingBook.getOrCreateName(name, sheetIndex);
    }

    public boolean isAllowedDeferredNamePtg() {
        return true;
    }

    public EvaluationName getName(String name, String sheetName) {
        return this._parsingBook.getName(name, sheetName);
    }

    public TablePtg createTablePtg(String tableName, Object[] specifiers, int sheetIndex, int rowIdx, int colIdx) {
        return this._parsingBook.createTablePtg(tableName, specifiers, sheetIndex, rowIdx, colIdx);
    }

    public String getTableName(String name) {
        STable table = ((AbstractBookAdv)this._nbook).getTable(name);
        return table == null ? null : table.getName();
    }

    public Map<String, Formula> getFormulaParsingCache() {
        HashMap cache = (HashMap)this._nbook.getAttribute("$KEY_FORMULA_CACHE$");
        if (cache == null) {
            cache = new HashMap();
            this._nbook.setAttribute("$KEY_FORMULA_CACHE$", cache);
        }
        return cache;
    }

    private class EvalName
    implements EvaluationName {
        private final String name;
        private final int nameIndex;
        private FormulaExpression refersToFormulaExpression;
        private int sheetIndex;

        public EvalName(String name, int nameIndex, FormulaExpression refersToFormula, int sheetIndex) {
            this.name = name;
            this.nameIndex = nameIndex;
            this.refersToFormulaExpression = refersToFormula;
            this.sheetIndex = sheetIndex;
        }

        public NamePtg createPtg() {
            return new NamePtg(this.nameIndex);
        }

        public Ptg[] getNameDefinition() {
            return this.refersToFormulaExpression != null ? this.refersToFormulaExpression.getPtgs() : null;
        }

        public String getNameText() {
            return this.name;
        }

        public boolean hasFormula() {
            return !this.isFunctionName() && this.refersToFormulaExpression != null;
        }

        public boolean isFunctionName() {
            return false;
        }

        public boolean isRange() {
            return this.hasFormula();
        }
    }
}

