/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.sys;

import io.keikai.model.SColor;
import io.keikai.model.SRichText;
import io.keikai.model.impl.ColorImpl;
import io.keikai.model.sys.format.FormatResult;
import java.io.Serializable;
import java.text.Format;
import org.apache.poi.ss.format.CellFormatResult;

public class FormatResultImpl
implements FormatResult,
Serializable {
    private static final long serialVersionUID = -289137517055850524L;
    private String _text;
    private SColor _textColor;
    private SRichText _richText;
    private boolean _dateFormatted = false;
    private Format _formater;

    public FormatResultImpl(SRichText richText) {
        this._richText = richText;
    }

    public FormatResultImpl(CellFormatResult result, Format formater, boolean dateFormatted) {
        this._text = result.text;
        if (result.textColor != null) {
            this._textColor = new ColorImpl((byte)result.textColor.getRed(), (byte)result.textColor.getGreen(), (byte)result.textColor.getBlue());
        }
        this._formater = formater;
        this._dateFormatted = dateFormatted;
    }

    public FormatResultImpl(String text, SColor color) {
        this._text = text;
        this._textColor = color;
    }

    @Override
    public Format getFormater() {
        return this._formater;
    }

    @Override
    public String getText() {
        return this._richText == null ? this._text : this._richText.getText();
    }

    @Override
    public SColor getColor() {
        return this._richText == null ? this._textColor : this._richText.getFont().getColor();
    }

    @Override
    public boolean isRichText() {
        return this._richText != null;
    }

    @Override
    public SRichText getRichText() {
        return this._richText;
    }

    @Override
    public boolean isDateFormatted() {
        return this._dateFormatted;
    }
}

