/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SColor;
import io.keikai.model.SFill;
import io.keikai.model.impl.AbstractColorAdv;
import io.keikai.model.impl.AbstractFillAdv;
import io.keikai.model.impl.ColorImpl;
import io.keikai.model.impl.DefaultStyle;
import io.keikai.model.impl.FillImpl;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Objects;

public class ImmutableFillImpl
extends AbstractFillAdv {
    public static final ImmutableFillImpl BLANK_FILL = new ImmutableFillImpl(DefaultStyle.FILL_PATTERN, DefaultStyle.FILL_COLOR, DefaultStyle.BACK_COLOR);
    private static final long serialVersionUID = 7543091524803612257L;
    private static final Logger log = LoggerFactory.getLogger(ImmutableFillImpl.class);
    private final SColor fillColor;
    private final SColor backColor;
    private final SFill.FillPattern fillPattern;
    private final int hashCode;
    private String patternHtml;

    ImmutableFillImpl(ImmutableFillImpl src, SBook book) {
        this.backColor = src.backColor == null ? null : ((AbstractColorAdv)src.backColor).cloneColor(book);
        this.fillColor = src.fillColor == null ? null : ((AbstractColorAdv)src.fillColor).cloneColor(book);
        this.fillPattern = src.fillPattern;
        this.hashCode = ImmutableFillImpl.hashCode(this);
    }

    public ImmutableFillImpl(SFill.FillPattern pattern, String fgColor, String bgColor) {
        this.fillPattern = pattern;
        this.fillColor = new ColorImpl(fgColor);
        this.backColor = new ColorImpl(bgColor);
        this.hashCode = ImmutableFillImpl.hashCode(this);
    }

    public ImmutableFillImpl(SFill.FillPattern pattern, SColor fgColor, SColor bgColor) {
        this.fillPattern = pattern;
        this.fillColor = fgColor;
        this.backColor = bgColor;
        this.hashCode = ImmutableFillImpl.hashCode(this);
    }

    ImmutableFillImpl() {
        this.fillColor = null;
        this.backColor = null;
        this.fillPattern = null;
        this.hashCode = ImmutableFillImpl.hashCode(this);
    }

    private static String getFillPatternHtml(ImmutableFillImpl style) {
        byte[] rawData = ImmutableFillImpl.getFillPatternBytes(style, 0, 0, 8, 4);
        StringBuilder sb = new StringBuilder();
        sb.append("background-image:url(data:image/png;base64,");
        String base64 = Base64.encodeBase64String((byte[])rawData);
        sb.append(base64).append(");");
        return sb.toString();
    }

    private static int hashCode(ImmutableFillImpl fillImpl) {
        int hash = fillImpl.getFillColor().hashCode();
        hash = hash * 31 + fillImpl.getBackColor().hashCode();
        hash = hash * 31 + fillImpl.getFillPattern().hashCode();
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFillPatternBytes(ImmutableFillImpl style, int xOffset, int yOffset, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2 = image.createGraphics();
        byte[] rgb = style.getBackColor().getRGB();
        g2.setColor(new Color(rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF));
        g2.fillRect(0, 0, width, height);
        rgb = style.getFillColor().getRGB();
        g2.setColor(new Color(rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF));
        byte[] patb = FillImpl.PATTERN_BYTES[style.getFillPattern().ordinal()];
        for (int y = 0; y < height; ++y) {
            int y0 = (y + yOffset) % 4;
            byte b = patb[y0];
            if (b == 0) continue;
            if (b == 255) {
                g2.drawLine(0, y, width - 1, y);
                continue;
            }
            int mask = 128 >>> xOffset % 8;
            for (int x = 0; x < width; ++x) {
                if ((b & mask) != 0) {
                    g2.drawLine(x, y, x, y);
                }
                if ((mask >>>= 1) != 0) continue;
                mask = 128;
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", os);
        }
        catch (IOException e) {
            log.error("Failed to write image", (Throwable)e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                log.error("Failed to close output stream", (Throwable)e);
            }
        }
        return os.toByteArray();
    }

    @Override
    public SColor getFillColor() {
        return Optional.ofNullable(this.fillColor).orElse(DefaultStyle.FILL_COLOR);
    }

    @Override
    public void setFillColor(SColor fillColor) {
        throw new UnsupportedOperationException("doesn't support set fill color");
    }

    @Override
    public SColor getBackColor() {
        return Optional.ofNullable(this.backColor).orElse(DefaultStyle.BACK_COLOR);
    }

    @Override
    public void setBackColor(SColor backColor) {
        throw new UnsupportedOperationException("doesn't support set back color");
    }

    @Override
    public SFill.FillPattern getFillPattern() {
        return Optional.ofNullable(this.fillPattern).orElse(DefaultStyle.FILL_PATTERN);
    }

    @Override
    public void setFillPattern(SFill.FillPattern fillPattern) {
        throw new UnsupportedOperationException("doesn't support set fill pattern");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ImmutableFillImpl)) {
            return false;
        }
        ImmutableFillImpl o = (ImmutableFillImpl)other;
        return Objects.equals((Object)this.getFillColor(), (Object)o.getFillColor()) && Objects.equals((Object)this.getBackColor(), (Object)o.getBackColor()) && Objects.equals((Object)((Object)this.getFillPattern()), (Object)((Object)o.getFillPattern()));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getFillPatternHtml() {
        if (!Optional.ofNullable(this.patternHtml).isPresent()) {
            SFill.FillPattern pattern = this.getFillPattern();
            this.patternHtml = pattern == SFill.FillPattern.NONE || pattern == SFill.FillPattern.SOLID ? "" : ImmutableFillImpl.getFillPatternHtml(this);
        }
        return this.patternHtml;
    }

    @Override
    String getStyleKey() {
        return this.fillPattern.ordinal() + "." + this.fillColor.getHtmlColor() + "." + this.backColor.getHtmlColor();
    }

    @Override
    public SColor getRawFillColor() {
        return this.fillColor;
    }

    @Override
    public SColor getRawBackColor() {
        return this.backColor;
    }

    @Override
    public SFill.FillPattern getRawFillPattern() {
        return this.fillPattern;
    }

    @Override
    ImmutableFillImpl cloneFill(SBook book) {
        return book == null ? this : new ImmutableFillImpl(this, book);
    }
}

