/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SFont;
import io.keikai.model.impl.AbstractFontBuilderAdv;
import io.keikai.model.impl.BookImpl;
import io.keikai.model.impl.ColorImpl;
import io.keikai.model.impl.DefaultStyle;
import io.keikai.model.impl.ImmutableFontImpl;

public class FontBuilderImpl
implements AbstractFontBuilderAdv {
    private final BookImpl bookImpl;
    private final boolean inStyleTable;
    private String name;
    private String color;
    private SFont.Boldweight boldweight;
    private boolean italic;
    private boolean strikeout;
    private SFont.Underline underline;
    private SFont.TypeOffset typeOffset;
    private int heightPoints;
    private boolean overrideName;
    private boolean overrideColor;
    private boolean overrideBold;
    private boolean overrideItalic;
    private boolean overrideStrikeout;
    private boolean overrideUnderline;
    private boolean overrideHeightPoints;
    private boolean overrideTypeOffset;

    FontBuilderImpl(BookImpl bookImpl, boolean inStyleTable) {
        this(bookImpl, null, inStyleTable);
    }

    FontBuilderImpl(BookImpl bookImpl, SFont src, boolean inStyleTable) {
        this.bookImpl = bookImpl;
        this.inStyleTable = inStyleTable;
        if (src != null) {
            this.name = src.getName();
            this.color = src.getColor().getHtmlColor();
            this.boldweight = src.getBoldweight();
            this.italic = src.isItalic();
            this.strikeout = src.isStrikeout();
            this.underline = src.getUnderline();
            this.heightPoints = src.getHeightPoints();
            this.typeOffset = src.getTypeOffset();
        } else {
            this.name = "Calibri";
            this.color = DefaultStyle.FONT_COLOR.getHtmlColor();
            this.boldweight = DefaultStyle.FONT_BOLDWEIGHT;
            this.italic = false;
            this.strikeout = false;
            this.underline = DefaultStyle.FONT_UNDERLINE;
            this.heightPoints = 11;
            this.typeOffset = DefaultStyle.FONT_TYPE_OFFSET;
        }
    }

    @Override
    public SFont build() {
        if (this.inStyleTable) {
            ImmutableFontImpl font = new ImmutableFontImpl(this.name, this.bookImpl.createColor(this.color), this.boldweight, this.italic, this.strikeout, this.underline, this.heightPoints, this.typeOffset, this.overrideName, this.overrideColor, this.overrideBold, this.overrideItalic, this.overrideStrikeout, this.overrideUnderline, this.overrideHeightPoints, this.overrideTypeOffset);
            return this.bookImpl.getOrAddFont(font);
        }
        return new ImmutableFontImpl(this.name, new ColorImpl(this.color), this.boldweight, this.italic, this.strikeout, this.underline, this.heightPoints, this.typeOffset, this.overrideName, this.overrideColor, this.overrideBold, this.overrideItalic, this.overrideStrikeout, this.overrideUnderline, this.overrideHeightPoints, this.overrideTypeOffset);
    }

    @Override
    public AbstractFontBuilderAdv color(String color) {
        this.color = color;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv boldweight(SFont.Boldweight boldweight) {
        this.boldweight = boldweight;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv heightPoints(int heightPoints) {
        this.heightPoints = heightPoints < 0 ? 11 : heightPoints;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv italic(boolean italic) {
        this.italic = italic;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv strikeout(boolean strikeout) {
        this.strikeout = strikeout;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv typeOffset(SFont.TypeOffset typeOffset) {
        this.typeOffset = typeOffset;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv underline(SFont.Underline underline) {
        this.underline = underline;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv overrideName(boolean b) {
        this.overrideName = b;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv overrideColor(boolean b) {
        this.overrideColor = b;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv overrideBold(boolean b) {
        this.overrideBold = b;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv overrideItalic(boolean b) {
        this.overrideItalic = b;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv overrideStrikeout(boolean b) {
        this.overrideStrikeout = b;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv overrideUnderline(boolean b) {
        this.overrideUnderline = b;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv overrideHeightPoints(boolean b) {
        this.overrideHeightPoints = b;
        return this;
    }

    @Override
    public AbstractFontBuilderAdv overrideTypeOffset(boolean b) {
        this.overrideTypeOffset = b;
        return this;
    }
}

