/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.util.Converter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NumFmts {
    private static final List<String> BUILTIN_FMTS = Converter.asList("General", "0", "0.00", "#,##0", "#,##0.00", "\"$\"#,##0_);\\(\"$\"#,##0\\)", "\"$\"#,##0_);[Red]\\(\"$\"#,##0\\)", "\"$\"#,##0.00_);\\(\"$\"#,##0.00\\)", "\"$\"#,##0.00_);[Red]\\(\"$\"#,##0.00\\)", "0%", "0.00%", "0.00E+00", "# ?/?", "# ??/??", "m/d/yyyy", "d-mmm-yy", "d-mmm", "mmm-yy", "h:mm AM/PM", "h:mm:ss AM/PM", "h:mm", "h:mm:ss", "m/d/yyyy h:mm", "reserved-0x17", "reserved-0x18", "reserved-0x19", "reserved-0x1a", "reserved-0x1b", "reserved-0x1c", "reserved-0x1d", "reserved-0x1e", "reserved-0x1f", "reserved-0x20", "reserved-0x21", "reserved-0x22", "reserved-0x23", "reserved-0x24", "#,##0_);\\(#,##0\\)", "#,##0_);[Red]\\(#,##0\\)", "#,##0.00_);\\(#,##0.00\\)", "#,##0.00_);[Red]\\(#,##0.00\\)", "_(* #,##0_);_(* \\(#,##0\\);_(* \"-\"_);_(@_)", "_(\"$\"* #,##0_);_(\"$\"* \\(#,##0\\);_(\"$\"* \"-\"_);_(@_)", "_(* #,##0.00_);_(* \\(#,##0.00\\);_(* \"-\"??_);_(@_)", "_(\"$\"* #,##0.00_);_(\"$\"* \\(#,##0.00\\);_(\"$\"* \"-\"??_);_(@_)", "mm:ss", "[h]:mm:ss", "mm:ss.0", "##0.0E+0", "@");
    private static final int NUM_FMT_INDEX_BASE = 164;
    private Map<String, Integer> numFmtMap = new HashMap<String, Integer>();
    private Map<Integer, String> customNumFmts = new HashMap<Integer, String>();
    private int indexBase;
    private int maxIndex;

    public NumFmts() {
        this(164);
    }

    public NumFmts(int indexBase) {
        this.indexBase = indexBase;
        this.maxIndex = indexBase - 1;
        int j = 0;
        for (String fmt : BUILTIN_FMTS) {
            this.numFmtMap.put(fmt, j);
            ++j;
        }
    }

    public static boolean isBuiltIn(int id) {
        return id < BUILTIN_FMTS.size();
    }

    public boolean isCustomize(int id) {
        return id >= this.indexBase;
    }

    public int getCount() {
        return this.customNumFmts.size();
    }

    public String getNumFmtAt(int id) {
        String fmt0 = this.customNumFmts.get(id);
        if (fmt0 == null && this.isReservedBuiltin(id)) {
            id = 14;
        }
        String fmt = fmt0 != null ? fmt0 : (id < BUILTIN_FMTS.size() ? BUILTIN_FMTS.get(id) : null);
        return fmt;
    }

    private boolean isReservedBuiltin(int id) {
        return 23 <= id && id <= 36 || BUILTIN_FMTS.size() <= id && id < 164;
    }

    public void addNumFmt(String fmt, int index) {
        if (fmt != null) {
            if (index > this.maxIndex) {
                this.maxIndex = index;
            }
            this.customNumFmts.put(index, fmt);
            this.numFmtMap.put(fmt, index);
        }
    }
}

