/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.html;

import io.keikai.model.CellRegion;
import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SChart;
import io.keikai.model.SFont;
import io.keikai.model.SPicture;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.ViewAnchor;
import io.keikai.model.impl.html.Base64Coder;
import io.keikai.model.impl.html.LayoutUnitConversionHelper;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.sys.format.FormatEngine;
import io.keikai.model.sys.format.FormatResult;
import io.keikaiex.util.JFreeChartHelper;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.ZssContext;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.zkoss.zk.ui.UiException;

public class ToHtml
implements Serializable {
    private static final long serialVersionUID = 4118266926051968245L;
    private final SBook wb;
    private final OutputStream output;
    private boolean completeHTML;
    private Formatter out;
    private int firstColumn;
    private int endColumn;
    private Map<SCellStyle, Integer> styleTable = new HashMap<SCellStyle, Integer>();
    private boolean exportOneSheet = false;
    private String exportOneSheetName;
    private boolean exportSelectionArea = false;
    private CellRegion area;
    private boolean printHeader = true;
    private static final String DEFAULTS_CLASS = "excelDefaults";
    private static final String COL_HEAD_CLASS = "colHeader";
    private static final String ROW_HEAD_CLASS = "rowHeader";
    private static final Map<SCellStyle.Alignment, String> ALIGN = ToHtml.mapFor(SCellStyle.Alignment.LEFT, "left", SCellStyle.Alignment.CENTER, "center", SCellStyle.Alignment.RIGHT, "right", SCellStyle.Alignment.FILL, "left", SCellStyle.Alignment.JUSTIFY, "left", SCellStyle.Alignment.CENTER_SELECTION, "center");
    private static final Map<SCellStyle.VerticalAlignment, String> VERTICAL_ALIGN = ToHtml.mapFor(SCellStyle.VerticalAlignment.BOTTOM, "bottom", SCellStyle.VerticalAlignment.CENTER, "middle", SCellStyle.VerticalAlignment.TOP, "top");
    private static final Map<SBorder.BorderType, String> BORDER = ToHtml.mapFor(SBorder.BorderType.DASH_DOT, "dashed 1pt", SBorder.BorderType.DASH_DOT_DOT, "dashed 1pt", SBorder.BorderType.DASHED, "dashed 1pt", SBorder.BorderType.DOTTED, "dotted 1pt", SBorder.BorderType.DOUBLE, "double 3pt", SBorder.BorderType.HAIR, "solid 1px", SBorder.BorderType.MEDIUM, "solid 2pt", SBorder.BorderType.MEDIUM_DASH_DOT, "dashed 2pt", SBorder.BorderType.MEDIUM_DASH_DOT_DOT, "dashed 2pt", SBorder.BorderType.MEDIUM_DASHED, "dashed 2pt", SBorder.BorderType.NONE, "none", SBorder.BorderType.SLANTED_DASH_DOT, "dashed 2pt", SBorder.BorderType.THICK, "solid 3pt", SBorder.BorderType.THIN, "dashed 1pt");

    private static <K, V> Map<K, V> mapFor(Object ... mapping) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapping.length; i += 2) {
            map.put(mapping[i], mapping[i + 1]);
        }
        return map;
    }

    public static ToHtml create(SBook wb, OutputStream output) {
        ToHtml toHtml = new ToHtml(wb, output);
        return toHtml;
    }

    public static ToHtml create(SSheet ws, OutputStream output) {
        ToHtml toHtml = new ToHtml(ws.getBook(), output);
        toHtml.exportOneSheet = true;
        toHtml.exportOneSheetName = ws.getSheetName();
        return toHtml;
    }

    private static ToHtml create(SSheet ws, CellRegion area, OutputStream output) {
        ToHtml toHtml = new ToHtml(ws.getBook(), output);
        toHtml.exportOneSheet = true;
        toHtml.exportOneSheetName = ws.getSheetName();
        toHtml.exportSelectionArea = true;
        toHtml.area = area;
        return toHtml;
    }

    private ToHtml(SBook wb, OutputStream output) {
        if (wb == null) {
            throw new NullPointerException("wb");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        this.wb = wb;
        this.output = output;
    }

    private void setPrintHeader(boolean printHeader) {
        this.printHeader = printHeader;
    }

    public static void main(String[] args) throws Exception {
    }

    public static void export(SBook wb, OutputStream outputStream, boolean noHeader) throws IOException {
        ToHtml toHtml = ToHtml.create(wb, outputStream);
        toHtml.setCompleteHTML(true);
        toHtml.setPrintHeader(!noHeader);
        toHtml.printPage();
    }

    public static void export(SSheet ws, OutputStream outputStream, boolean noHeader) throws IOException {
        ToHtml toHtml = ToHtml.create(ws, outputStream);
        toHtml.setCompleteHTML(true);
        toHtml.setPrintHeader(!noHeader);
        toHtml.printPage();
    }

    public static void export(SSheet ws, CellRegion area, OutputStream outputStream, boolean noHeader) throws IOException {
        ToHtml toHtml = ToHtml.create(ws, area, outputStream);
        toHtml.setCompleteHTML(true);
        toHtml.setPrintHeader(!noHeader);
        toHtml.printPage();
    }

    public static void export(SBook wb, OutputStream outputStream) throws IOException {
        ToHtml.export(wb, outputStream, false);
    }

    public static void export(SSheet ws, OutputStream outputStream) throws IOException {
        ToHtml.export(ws, outputStream, false);
    }

    public static void export(SSheet ws, CellRegion area, OutputStream outputStream) throws IOException {
        ToHtml.export(ws, area, outputStream, false);
    }

    public void setCompleteHTML(boolean completeHTML) {
        this.completeHTML = completeHTML;
    }

    public void printPage() throws IOException {
        try {
            this.ensureOut();
            if (this.completeHTML) {
                this.out.format("<?xml version=\"1.0\" ?>%n", new Object[0]);
                this.out.format("<html>%n", new Object[0]);
                this.out.format("<head>%n", new Object[0]);
                this.out.format("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />", new Object[0]);
                this.out.format("</head>%n", new Object[0]);
                this.out.format("<body>%n", new Object[0]);
            }
            this.print();
            if (this.completeHTML) {
                this.out.format("</body>%n", new Object[0]);
                this.out.format("</html>%n", new Object[0]);
            }
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
            if (this.output instanceof Closeable) {
                OutputStream closeable = this.output;
                closeable.close();
            }
        }
    }

    public void print() {
        this.printInlineStyle();
        this.printSheets();
    }

    private void printInlineStyle() {
        this.out.format("<style type=\"text/css\">%n", new Object[0]);
        this.printStyles();
        this.out.format("</style>%n", new Object[0]);
    }

    private void ensureOut() {
        if (this.out == null) {
            this.out = new Formatter(this.output);
        }
    }

    public void printStyles() {
        this.ensureOut();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("excelStyle.css")));
            while ((line = in.readLine()) != null) {
                this.out.format("%s%n", line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading standard css", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Reading standard css", e);
                }
            }
        }
        HashSet<Integer> seen = new HashSet<Integer>();
        if (this.exportOneSheet) {
            SSheet sheet = this.wb.getSheetByName(this.exportOneSheetName);
            Iterator rows = sheet.getRowIterator();
            while (rows.hasNext()) {
                SRow row = (SRow)rows.next();
                Iterator cells = sheet.getCellIterator(row.getIndex());
                while (cells.hasNext()) {
                    Integer index;
                    SCell cell = (SCell)cells.next();
                    SCellStyle style = cell.getCellStyle();
                    if (this.styleTable.get(style) == null) {
                        this.styleTable.put(style, this.styleTable.size());
                    }
                    if (seen.contains(index = Integer.valueOf(this.styleTable.get(style)))) continue;
                    this.printStyle(style);
                    seen.add(index);
                }
            }
        } else {
            for (int i = 0; i < this.wb.getNumOfSheet(); ++i) {
                SSheet sheet = this.wb.getSheet(i);
                Iterator rows = sheet.getRowIterator();
                while (rows.hasNext()) {
                    SRow row = (SRow)rows.next();
                    Iterator cells = sheet.getCellIterator(row.getIndex());
                    while (cells.hasNext()) {
                        Integer index;
                        SCell cell = (SCell)cells.next();
                        SCellStyle style = cell.getCellStyle();
                        if (this.styleTable.get(style) == null) {
                            this.styleTable.put(style, this.styleTable.size());
                        }
                        if (seen.contains(index = Integer.valueOf(this.styleTable.get(style)))) continue;
                        this.printStyle(style);
                        seen.add(index);
                    }
                }
            }
        }
    }

    private void printStyle(SCellStyle style) {
        this.out.format(".%s .%s {%n", DEFAULTS_CLASS, this.styleName(style));
        this.styleContents(style);
        this.out.format("}%n", new Object[0]);
    }

    private void styleContents(SCellStyle style) {
        this.styleOut("text-align", style.getAlignment(), ALIGN);
        this.styleOut("vertical-align", style.getVerticalAlignment(), VERTICAL_ALIGN);
        this.fontStyle(style);
        this.borderStyles(style);
        this.out.format(" fill-color: %s;%n", style.getFillColor().getHtmlColor());
        this.out.format(" background-color: %s;%n", style.getBackColor().getHtmlColor());
        this.out.format(" color: %s;%n", style.getFont().getColor().getHtmlColor());
    }

    private void borderStyles(SCellStyle style) {
        this.styleOut("border-left", style.getBorderLeft(), BORDER);
        this.styleOut("border-right", style.getBorderRight(), BORDER);
        this.styleOut("border-top", style.getBorderTop(), BORDER);
        this.styleOut("border-bottom", style.getBorderBottom(), BORDER);
    }

    private void fontStyle(SCellStyle style) {
        SFont font = style.getFont();
        if (font.getBoldweight() == SFont.Boldweight.BOLD) {
            this.out.format("  font-weight: bold;%n", new Object[0]);
        }
        if (font.isItalic()) {
            this.out.format("  font-style: italic;%n", new Object[0]);
        }
        if (font.getUnderline() == SFont.Underline.SINGLE) {
            this.out.format("  text-decoration: underline;%n", new Object[0]);
        }
        if (font.isStrikeout()) {
            this.out.format("  text-decoration: line-through;%n", new Object[0]);
        }
        if (font.getName() != null) {
            this.out.format(" font-family:%s;%n", font.getName());
        }
        if (font.getTypeOffset() == SFont.TypeOffset.SUB) {
            this.out.format(" vertical-align: sub;%n", new Object[0]);
        } else if (font.getTypeOffset() == SFont.TypeOffset.SUPER) {
            this.out.format(" vertical-align: super;%n", new Object[0]);
        }
        int fontheight = font.getHeightPoints();
        if (font.getTypeOffset() != SFont.TypeOffset.NONE) {
            fontheight = (int)(0.7 * (double)fontheight + 0.5);
        }
        if (fontheight == 9) {
            fontheight = 10;
        }
        this.out.format("  font-size: %dpt;%n", fontheight);
    }

    private String styleName(SCellStyle style) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, ZssContext.getCurrent().getLocale());
        fmt.format("style_%02x", this.styleTable.get(style));
        return fmt.toString();
    }

    private <K> void styleOut(String attr, K key, Map<K, String> mapping) {
        String value = mapping.get(key);
        if (value != null) {
            this.out.format("  %s: %s;%n", attr, value);
        }
    }

    private void printSheets() {
        this.ensureOut();
        if (this.exportOneSheet) {
            SSheet sheet = this.wb.getSheetByName(this.exportOneSheetName);
            this.printSheet(sheet);
        } else {
            int sheetsNumber = this.wb.getNumOfSheet();
            for (int i = 0; i < sheetsNumber; ++i) {
                SSheet sheet = this.wb.getSheet(i);
                this.printSheet(sheet);
                this.out.format("<br/>", new Object[0]);
            }
        }
    }

    public void printSheet(SSheet sheet) {
        this.ensureOut();
        this.out.format("<div>%s%n<table class=%s>%n", sheet.getSheetName(), DEFAULTS_CLASS);
        this.printCols(sheet);
        this.printSheetContent(sheet);
        this.out.format("</table>%n</div>", new Object[0]);
    }

    private void printCols(SSheet sheet) {
        this.out.format("<col/>%n", new Object[0]);
        this.ensureColumnBounds(sheet);
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            this.out.format("<col/>%n", new Object[0]);
        }
    }

    private void ensureColumnBounds(SSheet sheet) {
        if (this.exportSelectionArea) {
            this.firstColumn = this.area.getColumn();
            this.endColumn = this.area.getLastColumn() + 1;
        } else {
            Iterator iter = sheet.getRowIterator();
            this.firstColumn = iter.hasNext() ? Integer.MAX_VALUE : 0;
            this.endColumn = 0;
            while (iter.hasNext()) {
                SRow row = (SRow)iter.next();
                this.firstColumn = Math.min(this.firstColumn, sheet.getStartCellIndex(row.getIndex()));
                this.endColumn = Math.max(this.endColumn, sheet.getEndCellIndex(row.getIndex()));
            }
            ++this.endColumn;
            this.firstColumn = 0;
        }
    }

    private void printColumnHeads(SSheet sheet) {
        this.out.format("<thead>%n", new Object[0]);
        this.out.format("  <tr class=%s>%n", COL_HEAD_CLASS);
        this.out.format("    <th class=%s>&#x25CA;</th>%n", COL_HEAD_CLASS);
        StringBuilder colName = new StringBuilder();
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            colName.setLength(0);
            int cnum = i;
            boolean lastChar = true;
            do {
                if (lastChar) {
                    colName.insert(0, (char)(65 + cnum % 26));
                    lastChar = false;
                    continue;
                }
                colName.insert(0, (char)(65 + cnum % 26 - 1));
            } while ((cnum /= 26) > 0);
            int width = sheet.getColumn(i).getWidth();
            this.out.format("    <th class=%s width=%s>%s</th>%n", COL_HEAD_CLASS, width, colName);
        }
        this.out.format("  </tr>%n", new Object[0]);
        this.out.format("</thead>%n", new Object[0]);
    }

    private void printSheetContent(SSheet sheet) {
        this.printColumnHeads(sheet);
        List pictures = sheet.getPictures();
        List charts = sheet.getCharts();
        this.out.format("<tbody>%n", new Object[0]);
        Iterator rows = sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = (SRow)rows.next();
            if (this.exportSelectionArea && (row.getIndex() < this.area.getRow() || row.getIndex() > this.area.getLastRow())) continue;
            int rowHeight = LayoutUnitConversionHelper.convertHeightToPixel(row.getHeight());
            this.out.format("  <tr>%n", new Object[0]);
            this.out.format("    <td class=%s height=%s>%d</td>%n", ROW_HEAD_CLASS, rowHeight, row.getIndex() + 1);
            for (int i = this.firstColumn; i < this.endColumn; ++i) {
                SCell cell;
                String content = "&nbsp;";
                String attrs = "";
                SCellStyle style = null;
                if (i >= sheet.getStartCellIndex(row.getIndex()) && i <= sheet.getEndCellIndex(row.getIndex()) && !(cell = sheet.getCell(row.getIndex(), i)).isNull()) {
                    style = cell.getCellStyle();
                    FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
                    FormatResult result = fe.format(cell, new FormatContext(ZssContext.getCurrent().getLocale()));
                    content = result.getText();
                    if (this.hasPictureStartInCell(pictures, cell)) {
                        content = this.genContentForPicture(pictures, cell);
                    }
                    if (this.hasChartStartInCell(charts, cell)) {
                        content = this.genContentForChart(sheet, charts, cell);
                    }
                    if (content.equals("")) {
                        content = "&nbsp;";
                    }
                    if (cell.getHyperlink() != null) {
                        content = "<a href=\"hyperlinkurl\" style=\"color:blue;\">origin_content</a>".replace("hyperlinkurl", cell.getHyperlink().getAddress()).replace("origin_content", content);
                    }
                }
                this.out.format("    <td class=%s %s>%s</td>%n", this.styleName(style), attrs, content);
            }
            this.out.format("  </tr>%n", new Object[0]);
        }
        this.out.format("</tbody>%n", new Object[0]);
    }

    private String genContentForChart(SSheet sheet, List<SChart> charts, SCell cell) {
        String result = "<span style=\"position: absolute; z-index: 1; margin-left: 27px; margin-top: 15px; width: contentWidth; height: contentHeight;\"><img alt=\"Embedded Image\" width=\"contentWidth\" height=\"contentHeight\" src=\"data:image/png;base64,realcontent\"></span>";
        SChart chart = this.getMappingChart(charts, cell);
        ViewAnchor anchor = chart.getAnchor();
        int width = anchor.getWidth();
        int height = anchor.getHeight();
        JFreeChart jfchart = JFreeChartHelper.drawJFreeChart((SChart)chart);
        ChartRenderingInfo jfinfo = new ChartRenderingInfo();
        BufferedImage bi = jfchart.createBufferedImage(chart.getAnchor().getWidth(), chart.getAnchor().getHeight(), 3, jfinfo);
        byte[] rawData = null;
        try {
            rawData = EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
        }
        catch (IOException ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
        String encodedPic = String.valueOf(Base64Coder.encode(rawData));
        result = result.replaceAll("contentWidth", String.valueOf(width));
        result = result.replaceAll("contentHeight", String.valueOf(height));
        return result.replace("realcontent", encodedPic);
    }

    private String genContentForPicture(List<SPicture> pictures, SCell cell) {
        String result = "<span style=\"position: absolute; z-index: 1; margin-left: 27px; margin-top: 15px; width: contentWidthpx; height: contentHeightpx;\"><img alt=\"Embedded Image\" width=\"contentWidth\" height=\"contentHeight\" src=\"data:image/png;base64,realcontent\"></span>";
        SPicture picture = this.getMappingPicture(pictures, cell);
        ViewAnchor anchor = picture.getAnchor();
        int width = anchor.getWidth();
        int height = anchor.getHeight();
        byte[] data = picture.getData();
        String encodedPic = String.valueOf(Base64Coder.encode(data));
        result = result.replaceAll("contentWidth", String.valueOf(width));
        result = result.replaceAll("contentHeight", String.valueOf(height));
        return result.replace("realcontent", encodedPic);
    }

    private boolean hasChartStartInCell(List<SChart> charts, SCell cell) {
        for (SChart chart : charts) {
            ViewAnchor anchor = chart.getAnchor();
            if (anchor.getColumnIndex() != cell.getColumnIndex() || anchor.getRowIndex() != cell.getRowIndex()) continue;
            return true;
        }
        return false;
    }

    private boolean hasPictureStartInCell(List<SPicture> pictures, SCell cell) {
        for (SPicture picture : pictures) {
            ViewAnchor anchor = picture.getAnchor();
            if (anchor.getColumnIndex() != cell.getColumnIndex() || anchor.getRowIndex() != cell.getRowIndex()) continue;
            return true;
        }
        return false;
    }

    private SChart getMappingChart(List<SChart> charts, SCell cell) {
        for (SChart chart : charts) {
            ViewAnchor anchor = chart.getAnchor();
            if (anchor.getColumnIndex() != cell.getColumnIndex() || anchor.getRowIndex() != cell.getRowIndex()) continue;
            return chart;
        }
        return null;
    }

    private SPicture getMappingPicture(List<SPicture> pictures, SCell cell) {
        for (SPicture picture : pictures) {
            ViewAnchor anchor = picture.getAnchor();
            if (anchor.getColumnIndex() != cell.getColumnIndex() || anchor.getRowIndex() != cell.getRowIndex()) continue;
            return picture;
        }
        return null;
    }
}

