/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.html;

import io.keikai.model.SBook;
import io.keikai.model.SPicture;
import io.keikai.model.SSheet;
import io.keikai.model.SheetRegion;
import io.keikai.model.impl.html.ToHtml;
import io.keikai.range.SExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zul.Chart;

public class HtmlExporter
implements SExporter,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(HtmlExporter.class);
    private static final long serialVersionUID = -6528106240649515421L;
    protected SBook wb;
    protected int[] colBreaks;
    protected int[] rowBreaks;
    protected int firstColumn;
    protected int endColumn;
    protected int endRow;
    protected int pageCount = 1;
    protected int pageNumber;
    protected boolean printGridLines;
    protected boolean printHeadings;
    protected float headerFooterTotalWidth;
    protected float leftMargin;
    protected float rightMargin;
    protected float topMargin;
    protected float bottomMargin;
    protected float headerMargin;
    protected float footerMargin;
    protected Map<Integer, Map<String, int[]>> sheetsWithRepeatingRowsAndColumns = new HashMap<Integer, Map<String, int[]>>();
    protected float totalAvailablePageWidth;
    protected float totalAvailablePageHeight;
    protected float[] columnLeft;
    protected float[] rowTop;
    protected Map<String, Integer> lastPageRowColumnBounds;
    protected int currentSheetIndex = 0;
    List<SPicture> pictures;
    protected int _outcol1;
    protected int _outcol2;
    protected int _outrow1;
    protected int _outrow2;
    protected Chart _chart;
    protected String _refSheetName;

    public void export(SBook workbook, OutputStream outputStream) throws IOException {
        ToHtml.export(workbook, outputStream, !this.printHeadings);
    }

    public void export(SSheet worksheet, OutputStream outputStream) throws IOException {
        ToHtml.export(worksheet, outputStream, !this.printHeadings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(SBook book, File file) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.export(book, (OutputStream)os);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception x) {
                    log.error("Error closing output stream", (Throwable)x);
                }
            }
        }
    }

    public void export(SheetRegion sheetRegion, OutputStream outputStream) throws IOException {
        ToHtml.export(sheetRegion.getSheet(), sheetRegion.getRegion(), outputStream, !this.printHeadings);
    }

    public void enableHeadings(boolean enable) {
        this.printHeadings = enable;
    }
}

