/* overflow.js

	Purpose:
		
	Description:
		
	History:
		Mar 6, 2015 Created by henrichen

Copyright (C) 2015 Potix Corporation. All Rights Reserved.
*/
//ZSS-944
(function () {
  // backup before overrode
  var zssrotate$overrode = {};
  zk.override(zss.Cell.prototype, zssrotate$overrode, {
    _colWidth: function () {
      var sheet = this.sheet,
        custColWidth = sheet.custColWidth,
        cellPad = sheet.cellPad,
        cw = 0,
        ml = this.merid ? this.merl : this.c,
        mr = this.merid ? this.merr : ml;
      for (var col = ml; col <= mr; ++col) {
        cw += custColWidth.getSize(col);
      }
      return cw - 2 * cellPad; // current cell's width
    },
    _textWidth: function () {
      if (!this._txtwd) {
        //ZSS-1171
        var tn = this.getTextNode(),
          $tn = jq(tn),
          html_calc = jq('<span>' + $tn.html() + '</span>');
        html_calc.css('font-size', $tn.css('font-size')).css('font-family', $tn.css('font-family')).hide();
        html_calc.prependTo('body');
        this._txtwd = html_calc.width();
        html_calc.remove();
      }
      return this._txtwd;
    },
    _processRotate: function () {
      var rot = this.rotate;
      if (rot != 90 && rot != -90) return; //ZSS-1020

      var cave = this.$n('cave'),
        $cave = jq(cave),
        real = this.$n('real'),
        tn = this.getTextNode(),
        txtHeight = '1.6em',
        // current text's height, 1.6 is found by experiments;
        fontSizePt = this.fontSize,
        oneem,
        // 1em in px
        halfem,
        // 0.5em in px
        pointeightem,
        // 1.6em / 2 in px
        onepointsixem; // 1.6em  

      //ZSS-1108
      //IE9 does NOT support transform-origin at all, its rotation origin
      //seems always be (center, center).
      var tw, cw;
      if (zk.ie) {
        oneem = Math.round(fontSizePt * 4 / 3); // 1em in px; px = pt * 4 / 3
        halfem = Math.round(fontSizePt * 2 / 3); // 0.5em in px
        pointeightem = Math.round(fontSizePt * 4 * 0.8 / 3); // 1.6em / 2 in px
        onepointsixem = Math.round(fontSizePt * 4 * 1.6 / 3); // 1.6em
      }

      //cave must be always left aligned so css3 transform can handle the text properly
      $cave.css('text-align', '');

      // excel's -90 degree in UI is 90 degree in CSS3
      if (rot == -90) {
        //ZSS-1020
        var tcss = '';
        //vertical align
        switch (this.valign) {
          case 't':
            //top
            tcss = 'rotate(90deg) translate(-1em';
            break;
          case 'c':
            //middle
            tw = tw || this._textWidth(); // heavy duty (it's actually a function call from ZK widget)
            if (zk.ie) {
              //ZSS-1108
              var transX = Math.floor(tw / 2) + halfem;
              tcss = 'rotate(90deg) translate(-' + transX + 'px';
            } else {
              tcss = 'rotate(90deg) translate(calc(-' + Math.floor(tw / 2) + 'px - 0.5em)';
            }
            break;
          case 'b':
            //bottom
            tw = tw || this._textWidth(); // heavy duty (it's actually a function call from ZK widget)
            tcss = 'rotate(90deg) translate(-' + tw + 'px';
            break;
        }

        //horizontal align
        switch (this.halign) {
          case 'l':
            //left
            tcss += ',0px)';
            break;
          case 'c':
            //center
            cw = cw || this._colWidth(); // current cell's width(will consider merged cell)
            if (zk.ie) {
              //ZSS-1108
              var transY = pointeightem - Math.floor(cw / 2);
              tcss += ',' + transY + 'px)';
            } else {
              tcss += ',calc(' + txtHeight + ' / 2 - ' + Math.floor(cw / 2) + 'px))';
            }
            break;
          case 'r':
            //right
            cw = cw || this._colWidth(); // current cell's width(will consider merged cell)
            if (zk.ie) {
              //ZSS-1108
              var transY = onepointsixem - cw;
              tcss += ',' + transY + 'px)';
            } else {
              tcss += ',calc(' + txtHeight + ' - ' + cw + 'px))';
            }
            break;
        }
        real.style['transform-origin'] = 'left bottom 0';
        // cannot use jq.css() which does not support two 'calc" in one key
        real.style['transform'] = tcss;
      }
      // excel's 90 degree in UI is -90 degree in CSS3
      else if (rot == 90) {
        var tcss = '';
        //vertical align
        switch (this.valign) {
          case 'b':
            //bottom
            if (zk.ie) {
              //ZSS-1108
              var transX = -oneem;
              tcss = 'rotate(-90deg) translate(' + transX + 'px';
            } else {
              tcss = 'rotate(-90deg) translate(-1em';
            }
            break;
          case 'c':
            //middle
            tw = tw || this._textWidth(); // heavy duty (it's actually a function call from ZK widget)
            if (zk.ie) {
              //ZSS-1108
              var transX = -Math.floor(tw / 2) - halfem;
              tcss = 'rotate(-90deg) translate(' + transX + 'px';
            } else {
              tcss = 'rotate(-90deg) translate(calc(-' + Math.floor(tw / 2) + 'px - 0.5em)';
            }
            break;
          case 't':
            //top
            tw = tw || this._textWidth(); // heavy duty (it's actually a function call from ZK widget)
            tcss = 'rotate(-90deg) translate(-' + tw + 'px';
            break;
        }

        //horizontal align
        switch (this.halign) {
          case 'l':
            //left
            tcss += ',0px)';
            break;
          case 'c':
            //center
            cw = cw || this._colWidth(); // current cell's width(will consider merged cell)
            if (zk.ie) {
              //ZSS-1108
              var transY = Math.floor(cw / 2) - pointeightem;
              tcss += ',' + transY + 'px)';
            } else {
              tcss += ',calc(' + Math.floor(cw / 2) + 'px - ' + txtHeight + ' / 2))';
            }
            break;
          case 'r':
            //right
            cw = cw || this._colWidth(); // current cell's width(will consider merged cell)
            if (zk.ie) {
              //ZSS-1108
              var transY = cw - onepointsixem;
              tcss += ',' + transY + 'px)';
            } else {
              tcss += ',calc(' + cw + 'px - ' + txtHeight + '))';
            }
            break;
        }
        real.style['transform-origin'] = 'left top 0';
        // cannot use jq.css() which does not support two 'calc" in one key
        real.style['transform'] = tcss;
      }
    }
  });
})(); // end of topmost function