/* Btn.js

{{IS_NOTE
	Purpose:
		
	Description:
		
	History:
		Sat May 7, 2011 11:31:29 AM , Created by henrichen
}}IS_NOTE

Copyright (C) 2011 Potix Corporation. All Rights Reserved.
*/

/**
 * AutoFilter buttons.
 */
zssex.Btn = zk.$extends(zul.wgt.Div, {
  $init: function (sht, r, c, parent, cls, field, btntype, left) {
    this.$supers(zssex.Btn, '$init', []); //DO NOT pass "arguments" or all fields in sht will be copied into this Object. 
    this.sheet = sht;
    this.left = left; // KEIKAI-710: cache "left" instead of "loffset", coz it might need to recalculate
    this.row = r;
    this.col = c;
    this.field = field;
    this.btntype = btntype;
    this.uuid = zk.Widget.nextUuid();
    this._zclass = 'zsbtn';
    this._sclass = cls;

    //KEIKAI-43: avoid to relocate after init btn, so we invoke relocate() first.
    this.relocate(r, c);
    var ctmp = '<div id="' + this.uuid + '" zs.t="SBtn" class="zsbtn ' + cls + '" style="width:' + jq.px0(this.imgwidth) + ';height:' + jq.px0(this.imgheight) + ';left:' + jq.px(this.imgleft) + ';bottom:' + jq.px(this.imgbottom) + '"></div>';
    jq(parent).append(ctmp); //attach to dom
    if (sht.desktop) {
      // bind
      this.bind(sht.desktop);
    }
    this._updateVisibilityByCol(c);
  },
  cleanup: function () {
    var elm = this.$n();
    this.unbind();
    if (elm) jq(elm).remove();
  },
  doTooltipOver_: function () {
    //unknown
  },
  doTooltipOut_: function () {
    //unknown
  },
  doClick_: function (evt) {
    //do nothing. eat the event.
  },
  doMouseDown_: function (evt) {
    if (evt.which && evt.which == 1)
      //work only if a left mouse down
      this.sheet._doBtndown(evt, this.btntype, evt.domTarget, this); //auto filter
  },
  doMouseUp_: function (evt) {
    this.sheet._doMouseup(evt);
  },
  doRightClick_: function (evt) {
    this.sheet._doMouserightclick(evt);
  },
  doDoubleClick_: function (evt) {
    this.sheet._doMousedblclick(evt);
  },
  doKeyDown_: function (evt) {
    this.sheet.doKeyDown_(evt);
  },
  afterKeyDown_: function (evt) {
    this.sheet._wgt.afterKeyDown_(evt);
  },
  doKeyPress_: function (evt) {
    this.sheet._doKeypress(evt);
  },
  relocate: function (row, col) {
    this._updateVisibilityByCol(col);
    if (!this.isVisible()) {
      return;
    }
    var sht = this.sheet;
    this.row = row;
    this.col = col;

    //ZSS-805
    var colR = col;
    var cell = sht.getCell(row, col);
    if (cell && cell.merr && cell.merr > colR) {
      colR = cell.merr;
    }
    var custColWidth = sht.custColWidth,
      custRowHeight = sht.custRowHeight,
      l = custColWidth.getStartPixel(col),
      t = custRowHeight.getStartPixel(row),
      w = custColWidth.getStartPixel(colR + 1) - l,
      h = custRowHeight.getStartPixel(row + 1) - t,
      imgw = zk.mobile ? 26 : 18,
      imgh = zk.mobile ? 26 : 18,
      selectBorderWidth = 1,
      rb = h - 2 < imgh ? 0 : 2,
      top = t + h - imgh - rb;
    //'af' button is at left side while 'dv' button is at right side of right edge
    //ZSS-954, left must minus the offset because column might not start from 0
    var loffset = this.left ? sht.custColWidth.getStartPixel(this.left) : 0;
    this.relocate_(l - loffset + w - (this.btntype == 'af' ? imgw : -1) - selectBorderWidth, top, rb, imgw, imgh);
  },
  /**
   * Sets the button position
   * @param int left position
   * @param int top position
   * @param int relative bottom position
   * @param int width
   * @param int height
   */
  relocate_: function (l, t, rb, w, h) {
    // KEIKAI-33: align to bottom if current cell height is less then image height
    this.imgwidth = w;
    this.imgheight = h;
    this.imgleft = l - 1;
    this.imgtop = t;
    this.imgbottom = rb;
    if (this.$n()) {
      jq(this.$n()).css({
        'width': jq.px0(w),
        'height': jq.px0(h),
        'left': jq.px(this.imgleft),
        'bottom': jq.px(rb)
      });
    }
  },
  _updateVisibilityByCol: function (col) {
    if (this.$n()) {
      var isColHidden = this.sheet.custColWidth.isHidden(col);
      this.setVisible(!isColHidden);
    }
  }
});