/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikai.model.SChart;
import io.keikaiex.util.JFreeChartHelper;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.ui.RectangleEdge;
import org.zkoss.zkex.zul.impl.JFreeChartEngine;
import org.zkoss.zul.Chart;

public class ZssChartEngine
extends JFreeChartEngine {
    protected final SChart _chartInfo;
    private static final long serialVersionUID = 201011021111L;
    static final int POS_B = 1;
    static final int POS_TR = 2;
    static final int POS_L = 3;
    static final int POS_R = 4;
    static final int POS_T = 5;

    public ZssChartEngine(SChart chartInfo) {
        this._chartInfo = chartInfo;
    }

    public boolean prepareJFreeChart(JFreeChart jfchart, Chart chart) {
        chart.setPaneColor("#FFFFFF");
        jfchart.getPlot().setOutlineVisible(false);
        jfchart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        if (this.hasLegend()) {
            RectangleEdge edge = null;
            switch (this.getLegendPos()) {
                case 1: {
                    edge = RectangleEdge.BOTTOM;
                    break;
                }
                case 3: {
                    edge = RectangleEdge.LEFT;
                    break;
                }
                case 5: {
                    edge = RectangleEdge.TOP;
                    break;
                }
                default: {
                    edge = RectangleEdge.RIGHT;
                }
            }
            jfchart.getLegend().setPosition(edge);
        } else {
            jfchart.getLegend().setVisible(false);
        }
        JFreeChartHelper.prepareAxis(jfchart, this._chartInfo);
        return false;
    }

    private boolean hasLegend() {
        return this._chartInfo.getLegendPosition() != null;
    }

    private int getLegendPos() {
        switch (this._chartInfo.getLegendPosition()) {
            case BOTTOM: {
                return 1;
            }
            case LEFT: {
                return 3;
            }
            case TOP: {
                return 5;
            }
            case TOP_RIGHT: {
                return 2;
            }
        }
        return 4;
    }
}

