/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikaiex.util.Interval;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

class ParallelIntervals<T>
implements Iterable<Interval<T>>,
Serializable {
    private static final long serialVersionUID = -7745165987819212136L;
    private static Comparator<Interval> comparator = new Comparator<Interval>(){

        @Override
        public int compare(Interval a, Interval b) {
            return a.getHigh() - b.getHigh();
        }
    };
    List<Interval<T>> intervals;

    ParallelIntervals() {
    }

    IntervalResult<T> insertInterval(Interval<T> interval) {
        int j;
        if (this.intervals != null) {
            if (!this.intervals.isEmpty() && this.intervals.get(0).getLow() != interval.getLow()) {
                return null;
            }
        } else {
            this.intervals = new ArrayList<Interval<T>>(1);
        }
        if ((j = Collections.binarySearch(this.intervals, interval, comparator)) < 0) {
            this.intervals.add(-j - 1, interval);
            return new IntervalResult<T>(interval, j);
        }
        return new IntervalResult<T>(this.intervals.get(j), j);
    }

    IntervalResult<T> searchInterval(Interval<T> interval) {
        int j;
        if (this.intervals != null && !this.intervals.isEmpty() && (j = Collections.binarySearch(this.intervals, interval, comparator)) >= 0) {
            return new IntervalResult<T>(this.intervals.get(j), j);
        }
        return null;
    }

    Interval<T> deleteInterval(int index) {
        if (this.intervals == null || index < 0 || this.intervals.isEmpty()) {
            return null;
        }
        Interval<T> intv = this.intervals.remove(index);
        if (this.intervals.isEmpty()) {
            this.intervals = null;
        }
        return intv;
    }

    int getMax() {
        return this.intervals == null || this.intervals.isEmpty() ? -1 : this.intervals.get(this.intervals.size() - 1).getHigh();
    }

    int getMin() {
        return this.intervals == null || this.intervals.isEmpty() ? -1 : this.intervals.get(0).getHigh();
    }

    int getLow() {
        return this.intervals == null || this.intervals.isEmpty() ? -1 : this.intervals.get(0).getLow();
    }

    void contains(Interval<T> interval, Collection<Interval<T>> results) {
        if (this.intervals == null || interval.getHigh() > this.getMax() || interval.getLow() < this.getLow()) {
            return;
        }
        int len = this.intervals.size();
        for (int k = (j = Collections.binarySearch(this.intervals, interval, comparator)) < 0 ? -(j + 1) : j; k < len; ++k) {
            results.add(this.intervals.get(k));
        }
    }

    void overlaps(Interval<T> interval, Collection<Interval<T>> results) {
        int l = interval.getLow();
        if (l > this.getMax() || interval.getHigh() < this.getLow()) {
            return;
        }
        if (l <= this.getLow()) {
            results.addAll(this.intervals);
            return;
        }
        int len = this.intervals.size();
        for (int k = (j = Collections.binarySearch(this.intervals, new Interval<Object>(l, l, null), comparator)) < 0 ? -(j + 1) : j; k < len; ++k) {
            results.add(this.intervals.get(k));
        }
    }

    void contained(Interval<T> interval, Collection<Interval<T>> results) {
        if (interval.getLow() > this.getLow()) {
            return;
        }
        int j = Collections.binarySearch(this.intervals, interval, comparator);
        int e = j < 0 ? -(j + 1) : j + 1;
        for (int k = 0; k < e; ++k) {
            results.add(this.intervals.get(k));
        }
    }

    boolean isEmpty() {
        return this.intervals == null || this.intervals.isEmpty();
    }

    @Override
    public Iterator<Interval<T>> iterator() {
        return this.intervals == null ? Collections.EMPTY_LIST.iterator() : this.intervals.iterator();
    }

    static class IntervalResult<T> {
        final Interval<T> interval;
        final int index;

        IntervalResult(Interval<T> interval, int index) {
            this.interval = interval;
            this.index = index;
        }
    }
}

