/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikai.model.SChart;
import io.keikai.model.SChartAxis;
import io.keikai.model.chart.SChartData;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.chart.SSeries;
import io.keikai.model.impl.sys.FormatEngineImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.sys.format.FormatResult;
import io.keikai.model.util.Strings;
import io.keikaiex.util.LineChartExportEngine;
import io.keikaiex.util.PieChartExportEngine;
import io.keikaiex.util.ZssChartExportEngine;
import java.awt.Font;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Optional;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.zul.Chart;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.SimpleCategoryModel;
import org.zkoss.zul.SimpleHiLoModel;
import org.zkoss.zul.SimplePieModel;
import org.zkoss.zul.SimpleXYModel;
import org.zkoss.zul.SimpleXYZModel;
import org.zkoss.zul.XYModel;
import org.zkoss.zul.XYZModel;

public class JFreeChartHelper {
    private static final Logger logger = LoggerFactory.getLogger(JFreeChartHelper.class);
    static final String TITLE_FONT_PROPERTY_KEY = "io.keikai.chart.title.font";
    static final String LEGEND_FONT_PROPERTY_KEY = "io.keikai.chart.legend.font";
    static final String XAXIS_TICK_FONT_PROPERTY_KEY = "io.keikai.chart.xAxisTick.font";
    static final String YAXIS_TICK_FONT_PROPERTY_KEY = "io.keikai.chart.yAxisTick.font";
    static final String ZSS_TITLE_FONT_PROPERTY_KEY = "org.zkoss.zss.chart.title.font";
    static final String ZSS_LEGEND_FONT_PROPERTY_KEY = "org.zkoss.zss.chart.legend.font";
    static final String ZSS_XAXIS_TICK_FONT_PROPERTY_KEY = "org.zkoss.zss.chart.xAxisTick.font";
    static final String ZSS_YAXIS_TICK_FONT_PROPERTY_KEY = "org.zkoss.zss.chart.yAxisTick.font";

    public static JFreeChart drawJFreeChart(SChart chartInfo) {
        String type = JFreeChartHelper.getChartType(chartInfo);
        ZssChartExportEngine engine = "line".equals(type) ? new LineChartExportEngine(chartInfo) : ("pie".equals(type) || "ring".equals(type) ? new PieChartExportEngine(chartInfo) : new ZssChartExportEngine(chartInfo));
        return engine.drawJFreeChart();
    }

    public static String getChartType(SChart chartInfo) {
        switch (chartInfo.getType()) {
            case AREA: {
                return chartInfo.getGrouping() == SChart.ChartGrouping.STACKED ? "stacked_area" : "area";
            }
            case BAR: 
            case COLUMN: {
                return chartInfo.getGrouping() == SChart.ChartGrouping.STACKED ? "stacked_bar" : "bar";
            }
            case BUBBLE: {
                return "bubble";
            }
            case DOUGHNUT: {
                return "ring";
            }
            case LINE: {
                return "line";
            }
            case OF_PIE: {
                return "ofpie";
            }
            case PIE: {
                return "pie";
            }
            case RADAR: {
                return "radar";
            }
            case SCATTER: {
                return "scatter";
            }
            case STOCK: {
                return "candlestick";
            }
            case SURFACE: {
                return "surface";
            }
        }
        return "";
    }

    public static PlotOrientation getOrientation(SChart chartInfo) {
        if (chartInfo.getBarDirection() == null) {
            return PlotOrientation.VERTICAL;
        }
        switch (chartInfo.getBarDirection()) {
            case HORIZONTAL: {
                return PlotOrientation.HORIZONTAL;
            }
        }
        return PlotOrientation.VERTICAL;
    }

    public static void drawChart(Chart chart, SChart chartInfo) {
        ChartModel model = null;
        switch (chartInfo.getType()) {
            case DOUGHNUT: 
            case PIE: {
                model = JFreeChartHelper.preparePieModel(chartInfo.getData());
                break;
            }
            case AREA: 
            case BAR: 
            case COLUMN: 
            case LINE: {
                model = JFreeChartHelper.prepareCategoryModel(chartInfo.getData());
                break;
            }
            case SCATTER: {
                model = JFreeChartHelper.prepareXYModel(chartInfo.getData());
                break;
            }
            case BUBBLE: {
                model = JFreeChartHelper.prepareXYZModel(chartInfo.getData());
                break;
            }
            case STOCK: {
                model = JFreeChartHelper.prepareHiLoModel(chartInfo.getData());
                break;
            }
        }
        if (model != null) {
            JFreeChartHelper.drawChartInner(chart, model, chartInfo);
        }
    }

    public static ChartModel prepareHiLoModel(SChartData chartData) {
        if (!(chartData instanceof SGeneralChartData)) {
            return null;
        }
        SimpleHiLoModel model = new SimpleHiLoModel();
        SSeries volumn = null;
        SSeries open = null;
        SSeries high = null;
        SSeries low = null;
        SSeries close = null;
        SGeneralChartData catData = (SGeneralChartData)chartData;
        int s = catData.getNumOfSeries();
        if (s <= 0) {
            return model;
        }
        if (s > 4) {
            close = catData.getSeries(4);
        }
        if (s > 3) {
            low = catData.getSeries(3);
        }
        if (s > 2) {
            high = catData.getSeries(2);
        }
        if (s > 1) {
            open = catData.getSeries(1);
        }
        if (s > 0) {
            volumn = catData.getSeries(0);
        }
        s = Math.max(catData.getNumOfCategory(), volumn.getNumOfValue());
        s = open == null ? s : Math.max(volumn.getNumOfValue(), open.getNumOfValue());
        s = high == null ? s : Math.max(open.getNumOfValue(), high.getNumOfValue());
        s = low == null ? s : Math.max(high.getNumOfValue(), low.getNumOfValue());
        s = close == null ? s : Math.max(low.getNumOfValue(), volumn.getNumOfValue());
        for (int i = 0; i < s; ++i) {
            Number volumnval = JFreeChartHelper.toNumber(volumn == null ? Integer.valueOf(0) : volumn.getValue(i), 0);
            Number openval = JFreeChartHelper.toNumber(open == null ? Integer.valueOf(0) : open.getValue(i), 0);
            Number highval = JFreeChartHelper.toNumber(high == null ? Integer.valueOf(0) : high.getValue(i), 0);
            Number lowval = JFreeChartHelper.toNumber(low == null ? Integer.valueOf(0) : low.getValue(i), 0);
            Number closeval = JFreeChartHelper.toNumber(close == null ? Integer.valueOf(0) : close.getValue(i), 0);
            Object cat = catData.getCategory(i);
            Date d = JFreeChartHelper.toDate(cat);
            if (d == null) continue;
            model.addValue(d, openval, highval, lowval, closeval, volumnval);
        }
        return model;
    }

    private static Date toDate(Object obj) {
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Number) {
            return EngineFactory.getInstance().getCalendarUtil().doubleValueToDate(((Number)obj).doubleValue());
        }
        return null;
    }

    private static Number toNumber(Object obj, int defaultValue) {
        return obj instanceof Number ? (Number)((Number)obj) : (Number)defaultValue;
    }

    private static String toSeriesName(String name, int seriesIndex) {
        if (name == null || "".equals(name)) {
            return "Series" + (seriesIndex + 1);
        }
        return name;
    }

    public static ChartModel prepareCategoryModel(SChartData chartData) {
        if (!(chartData instanceof SGeneralChartData)) {
            return null;
        }
        SimpleCategoryModel model = new SimpleCategoryModel();
        SGeneralChartData catData = (SGeneralChartData)chartData;
        SSeries[] serieses = new SSeries[catData.getNumOfSeries()];
        if (serieses.length == 0) {
            return model;
        }
        for (int i = 0; i < serieses.length; ++i) {
            serieses[i] = catData.getSeries(i);
        }
        int s = Math.max(catData.getNumOfCategory(), serieses[0].getNumOfValue());
        for (int i = 1; i < serieses.length; ++i) {
            s = Math.max(s, serieses[i].getNumOfValue());
        }
        boolean onlyVisible = chartData.getChart().isPlotOnlyVisibleCells();
        for (int i = 0; i < s; ++i) {
            Object cat = "";
            if (!onlyVisible || !catData.isCategoryHidden(i)) {
                cat = catData.getCategory(i);
            }
            for (int j = 0; j < serieses.length; ++j) {
                if (onlyVisible && serieses[j].isXValueFomulaHidden(i)) continue;
                String series = JFreeChartHelper.toSeriesName(serieses[j].getName(), j);
                Number val = JFreeChartHelper.toNumber(serieses[j].getValue(i), 0);
                model.setValue((Comparable)new ChartModelLabel(j, series), (Comparable)new ChartModelLabel(i, cat), val);
            }
        }
        return model;
    }

    public static XYModel prepareXYModel(SChartData chartData) {
        if (!(chartData instanceof SGeneralChartData)) {
            return null;
        }
        SimpleXYModel model = new SimpleXYModel();
        SGeneralChartData catData = (SGeneralChartData)chartData;
        SSeries[] serieses = new SSeries[catData.getNumOfSeries()];
        if (serieses.length == 0) {
            return model;
        }
        for (int i = 0; i < serieses.length; ++i) {
            serieses[i] = catData.getSeries(i);
        }
        boolean onlyVisible = chartData.getChart().isPlotOnlyVisibleCells();
        for (int i = 0; i < serieses.length; ++i) {
            String sname = JFreeChartHelper.toSeriesName(serieses[i].getName(), i);
            int s = Math.min(serieses[i].getNumOfValue(), serieses[i].getNumOfYValue());
            for (int j = 0; j < s; ++j) {
                if (onlyVisible && serieses[i].isYValueFomulaHidden(j)) continue;
                Number xval = JFreeChartHelper.toNumber(serieses[i].getValue(j), j + 1);
                Number yval = JFreeChartHelper.toNumber(serieses[i].getYValue(j), 0);
                model.addValue((Comparable)new ChartModelLabel(i, sname), xval, yval);
            }
        }
        return model;
    }

    public static XYZModel prepareXYZModel(SChartData chartData) {
        if (!(chartData instanceof SGeneralChartData)) {
            return null;
        }
        SimpleXYZModel model = new SimpleXYZModel();
        SGeneralChartData catData = (SGeneralChartData)chartData;
        SSeries[] serieses = new SSeries[catData.getNumOfSeries()];
        if (serieses.length == 0) {
            return model;
        }
        for (int i = 0; i < serieses.length; ++i) {
            serieses[i] = catData.getSeries(i);
        }
        boolean onlyVisible = chartData.getChart().isPlotOnlyVisibleCells();
        for (int i = 0; i < serieses.length; ++i) {
            String sname = JFreeChartHelper.toSeriesName(serieses[i].getName(), i);
            int s = Math.min(serieses[i].getNumOfValue(), serieses[i].getNumOfYValue());
            for (int j = 0; j < s; ++j) {
                if (onlyVisible && (serieses[i].isYValueFomulaHidden(j) || serieses[i].isZValueFomulaHidden(j))) continue;
                Number xval = JFreeChartHelper.toNumber(serieses[i].getValue(j), j + 1);
                Number yval = JFreeChartHelper.toNumber(serieses[i].getYValue(j), 0);
                Number zval = JFreeChartHelper.toNumber(serieses[i].getZValue(j), 0);
                model.addValue((Comparable)new ChartModelLabel(i, sname), xval, yval, zval);
            }
        }
        return model;
    }

    public static ChartModel preparePieModel(SChartData chartData) {
        if (!(chartData instanceof SGeneralChartData)) {
            return null;
        }
        SimplePieModel model = new SimplePieModel();
        SGeneralChartData catData = (SGeneralChartData)chartData;
        SSeries series1 = null;
        if (catData.getNumOfSeries() > 0) {
            series1 = catData.getSeries(0);
        }
        if (series1 == null) {
            return model;
        }
        int s = Math.max(catData.getNumOfCategory(), series1.getNumOfValue());
        boolean onlyVisible = chartData.getChart().isPlotOnlyVisibleCells();
        for (int i = 0; i < s; ++i) {
            Object label = "";
            Object val = "";
            if (onlyVisible) {
                if (series1.isXValueFomulaHidden(i)) continue;
                if (!catData.isCategoryHidden(i)) {
                    label = catData.getCategory(i);
                }
                val = series1.getValue(i);
            } else {
                label = catData.getCategory(i);
                val = series1.getValue(i);
            }
            model.setValue((Comparable)new ChartModelLabel(i, label), val instanceof Number ? (Number)((Number)val) : (Number)0);
        }
        return model;
    }

    public static Font getCustomFont(String key) {
        String value = Library.getProperty((String)key);
        Font font = null;
        if (value != null) {
            try {
                String[] token = value.trim().split(",");
                if (token.length == 3) {
                    String weightString = token[1].trim();
                    int weight = 0;
                    if ("bold".equalsIgnoreCase(weightString)) {
                        weight = 1;
                    } else if ("plain".equalsIgnoreCase(weightString)) {
                        weight = 0;
                    } else if ("italic".equalsIgnoreCase(weightString)) {
                        weight = 2;
                    } else {
                        throw new Exception("Unsupprted chart font weight: " + weightString);
                    }
                    font = new Font(token[0].trim(), weight, Integer.parseInt(token[2].trim()));
                }
            }
            catch (Exception x) {
                logger.warn(x.getMessage());
            }
        }
        return font;
    }

    private static void setFont(Chart chart) {
        Font font = Optional.ofNullable(JFreeChartHelper.getCustomFont(TITLE_FONT_PROPERTY_KEY)).orElse(JFreeChartHelper.getCustomFont(ZSS_TITLE_FONT_PROPERTY_KEY));
        if (font != null) {
            chart.setTitleFont(font);
        }
        if ((font = Optional.ofNullable(JFreeChartHelper.getCustomFont(LEGEND_FONT_PROPERTY_KEY)).orElse(JFreeChartHelper.getCustomFont(ZSS_LEGEND_FONT_PROPERTY_KEY))) != null) {
            chart.setLegendFont(font);
        }
        if ((font = Optional.ofNullable(JFreeChartHelper.getCustomFont(XAXIS_TICK_FONT_PROPERTY_KEY)).orElse(JFreeChartHelper.getCustomFont(ZSS_XAXIS_TICK_FONT_PROPERTY_KEY))) != null) {
            chart.setXAxisTickFont(font);
        }
        if ((font = Optional.ofNullable(JFreeChartHelper.getCustomFont(YAXIS_TICK_FONT_PROPERTY_KEY)).orElse(JFreeChartHelper.getCustomFont(ZSS_YAXIS_TICK_FONT_PROPERTY_KEY))) != null) {
            chart.setYAxisTickFont(font);
        }
    }

    private static void drawChartInner(Chart chart, ChartModel model, SChart chartInfo) {
        JFreeChartHelper.setFont(chart);
        chart.setType(JFreeChartHelper.getChartType(chartInfo));
        chart.setTitle(JFreeChartHelper.getChartTitle(chartInfo));
        chart.setThreeD(chartInfo.isThreeD());
        chart.setFgAlpha(128);
        if (chartInfo.getBarDirection() != null) {
            chart.setOrient(chartInfo.getBarDirection() == SChart.BarDirection.HORIZONTAL ? "horizontal" : "vertical");
        }
        chart.setModel(model);
    }

    private static String getChartTitle(SChart chartInfo) {
        String title = chartInfo.getTitle();
        return title == null ? "" : (!Strings.isEmpty((String)title) ? title : JFreeChartHelper.getFirstSeriesTitle(chartInfo));
    }

    private static String getFirstSeriesTitle(SChart chartInfo) {
        SGeneralChartData cd;
        SChartData scd = chartInfo.getData();
        if (scd instanceof SGeneralChartData && (cd = (SGeneralChartData)chartInfo.getData()).getNumOfSeries() > 0) {
            if (cd.getNumOfSeries() == 1) {
                return cd.getSeries(0).getName();
            }
            switch (chartInfo.getType()) {
                case DOUGHNUT: 
                case PIE: {
                    return cd.getSeries(0).getName();
                }
            }
            return "";
        }
        return "";
    }

    public static void prepareAxis(JFreeChart jfchart, SChart chartInfo) {
        switch (chartInfo.getType()) {
            case AREA: 
            case BAR: 
            case COLUMN: 
            case DOUGHNUT: 
            case LINE: 
            case PIE: {
                NumberAxis jfaxis;
                if (chartInfo.getValueAxises().isEmpty() || (jfaxis = (NumberAxis)jfchart.getCategoryPlot().getRangeAxis()) == null) break;
                SChartAxis saxis = (SChartAxis)chartInfo.getValueAxises().get(0);
                JFreeChartHelper.setupAxis((ValueAxis)jfaxis, saxis);
                break;
            }
            case SCATTER: {
                int size = chartInfo.getValueAxises().size();
                NumberAxis jfxaxis = (NumberAxis)jfchart.getXYPlot().getRangeAxis(0);
                NumberAxis jfyaxis = (NumberAxis)jfchart.getXYPlot().getRangeAxis(1);
                if (chartInfo.getBarDirection() == SChart.BarDirection.HORIZONTAL) {
                    if (size > 0 && jfyaxis != null) {
                        SChartAxis yaxis = (SChartAxis)chartInfo.getValueAxises().get(0);
                        JFreeChartHelper.setupAxis((ValueAxis)jfyaxis, yaxis);
                    }
                    if (size <= 1 || jfxaxis == null) break;
                    SChartAxis xaxis = (SChartAxis)chartInfo.getValueAxises().get(1);
                    JFreeChartHelper.setupAxis((ValueAxis)jfxaxis, xaxis);
                    break;
                }
                if (size > 0 && jfxaxis != null) {
                    SChartAxis xaxis = (SChartAxis)chartInfo.getValueAxises().get(0);
                    JFreeChartHelper.setupAxis((ValueAxis)jfxaxis, xaxis);
                }
                if (size <= 1 || jfyaxis == null) break;
                SChartAxis yaxis = (SChartAxis)chartInfo.getValueAxises().get(1);
                JFreeChartHelper.setupAxis((ValueAxis)jfyaxis, yaxis);
                break;
            }
            case BUBBLE: {
                int size0 = chartInfo.getValueAxises().size();
                NumberAxis jfxaxis0 = (NumberAxis)jfchart.getXYPlot().getRangeAxis(0);
                NumberAxis jfyaxis0 = (NumberAxis)jfchart.getXYPlot().getRangeAxis(1);
                NumberAxis jfzaxis0 = (NumberAxis)jfchart.getXYPlot().getRangeAxis(2);
                if (size0 > 0 && jfxaxis0 != null) {
                    SChartAxis xaxis = (SChartAxis)chartInfo.getValueAxises().get(0);
                    JFreeChartHelper.setupAxis((ValueAxis)jfxaxis0, xaxis);
                }
                if (size0 > 1 && jfyaxis0 != null) {
                    SChartAxis yaxis = (SChartAxis)chartInfo.getValueAxises().get(1);
                    JFreeChartHelper.setupAxis((ValueAxis)jfyaxis0, yaxis);
                }
                if (size0 <= 2 || jfzaxis0 == null) break;
                SChartAxis zaxis = (SChartAxis)chartInfo.getValueAxises().get(2);
                JFreeChartHelper.setupAxis((ValueAxis)jfzaxis0, zaxis);
                break;
            }
            case STOCK: {
                int size1 = chartInfo.getValueAxises().size();
                NumberAxis jfxaxis1 = (NumberAxis)jfchart.getXYPlot().getRangeAxis(0);
                NumberAxis jfyaxis1 = (NumberAxis)jfchart.getXYPlot().getRangeAxis(1);
                if (size1 > 0 && jfxaxis1 != null) {
                    SChartAxis xaxis = (SChartAxis)chartInfo.getValueAxises().get(0);
                    JFreeChartHelper.setupAxis((ValueAxis)jfxaxis1, xaxis);
                }
                if (size1 <= 1 || jfyaxis1 == null) break;
                SChartAxis yaxis = (SChartAxis)chartInfo.getValueAxises().get(1);
                JFreeChartHelper.setupAxis((ValueAxis)jfyaxis1, yaxis);
                break;
            }
        }
    }

    private static void setupAxis(ValueAxis axis, SChartAxis saxis) {
        if (saxis != null && !Strings.isBlank((String)saxis.getFormat())) {
            FormatContext formatContext = new FormatContext();
            FormatEngineImpl formatEngine = new FormatEngineImpl();
            FormatResult result = formatEngine.format(saxis.getFormat(), (Object)1.0, formatContext, 12);
            NumberFormat format = (NumberFormat)result.getFormater();
            double low = axis.getLowerBound();
            double high = axis.getUpperBound();
            double size = (high - low) / 10.0;
            size = JFreeChartHelper.normalize(size);
            TickUnits units = new TickUnits();
            if (format != null) {
                units.add((TickUnit)new NumberTickUnit(size, format));
            } else {
                units.add((TickUnit)new NumberTickUnit(size));
            }
            axis.setStandardTickUnits((TickUnitSource)units);
        }
    }

    private static double normalize(double size) {
        double exp10 = Math.log10(size);
        int exp = (int)Math.floor(exp10);
        double tens = Math.pow(10.0, exp);
        int num = (int)Math.floor(size / tens);
        switch (num) {
            case 0: 
            case 1: 
            case 2: {
                num = tens < 1.0 ? 5 : 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                num = 5;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                num = 10;
            }
        }
        return (double)num * tens;
    }

    static class ChartModelLabel
    implements Serializable,
    Comparable<ChartModelLabel> {
        private static final long serialVersionUID = 1L;
        private final Integer index;
        private final Object label;

        ChartModelLabel(int index, Object label) {
            this.index = index;
            this.label = label;
        }

        public String toString() {
            return this.label == null ? "" : this.label.toString();
        }

        @Override
        public int compareTo(ChartModelLabel o) {
            int indexComp = this.index.compareTo(o.index);
            return indexComp != 0 ? indexComp : this.label.toString().compareTo(o.toString());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode()) + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChartModelLabel other = (ChartModelLabel)obj;
            return Objects.equals((Object)this.index, (Object)other.index) && Objects.equals((Object)this.label, (Object)other.label);
        }
    }
}

