/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.widget;

import io.keikai.model.CellRegion;
import io.keikai.model.SChart;
import io.keikai.model.SColumnArray;
import io.keikai.model.SPicture;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.ViewAnchor;
import io.keikai.model.impl.ColumnArrayImpl;
import io.keikai.model.impl.RowImpl;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.Widget;
import io.keikai.ui.impl.HeaderPositionHelper;
import io.keikai.ui.sys.SpreadsheetCtrl;
import io.keikai.ui.sys.WidgetLoader;
import io.keikaiex.ui.widget.BaseWidget;
import io.keikaiex.ui.widget.ChartsWidget;
import io.keikaiex.ui.widget.ImageWidget;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.UiException;

public class DefaultBookWidgetLoader
implements WidgetLoader {
    private static final long serialVersionUID = -4896590549570605193L;
    private static final Logger log = LoggerFactory.getLogger(DefaultBookWidgetLoader.class);
    private Spreadsheet _spreadsheet;
    private ThreadLocal<List<Runnable>> _colResetCallbacks;
    private ThreadLocal<List<Runnable>> _rowResetCallbacks;
    static final int ZINDEX_START = 200;
    Map<String, Map<String, List<Widget>>> _widgetMap = new HashMap<String, Map<String, List<Widget>>>();

    public void init(Spreadsheet spreadsheet) {
        this._spreadsheet = spreadsheet;
    }

    public void invalidate() {
    }

    public void onSheetClean(SSheet sheet) {
        String key = sheet.getId();
        Map<String, List<Widget>> list = this._widgetMap.get(key);
        if (list != null) {
            Iterator<List<Widget>> iter = list.values().iterator();
            while (iter.hasNext()) {
                for (Widget widget : iter.next()) {
                    ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).removeWidget(widget);
                }
            }
            this._widgetMap.remove(key);
        }
    }

    public void onSheetSelected(SSheet sheet) {
        String key = sheet.getId();
        LinkedHashMap<String, List<Widget>> list = new LinkedHashMap<String, List<Widget>>();
        this.preparePictureWidgets(sheet, list);
        this.prepareChartWidgets(sheet, list);
        if (list != null && list.size() > 0) {
            this._widgetMap.put(key, list);
        }
    }

    public void onSheetFreeze(SSheet sheet) {
        List charts;
        List pictures = sheet.getPictures();
        if (pictures != null) {
            for (SPicture picture : pictures) {
                this.updatePictureWidget(sheet, picture);
            }
        }
        if ((charts = sheet.getCharts()) != null) {
            for (SChart chart : charts) {
                this.updateChartWidget(sheet, chart);
            }
        }
    }

    public void onColumnChange(SSheet sheet, int left, int right) {
        List charts;
        List pictures = sheet.getPictures();
        HeaderPositionHelper colHelper = null;
        this._colResetCallbacks = ThreadLocal.withInitial(ArrayList::new);
        if (pictures != null && !pictures.isEmpty()) {
            colHelper = this._spreadsheet.getColumnPosition(sheet);
            for (SPicture picture : pictures) {
                ViewAnchor anchor = picture.getAnchor();
                ViewAnchor rightBottomAnchor = anchor.getRightBottomAnchor(sheet);
                if (anchor.getColumnIndex() < left && rightBottomAnchor.getColumnIndex() < right) continue;
                this.updateColumnAnchor(sheet, anchor, colHelper, left, right);
                this.updatePictureWidget(sheet, picture);
            }
        }
        if ((charts = sheet.getCharts()) != null && !charts.isEmpty()) {
            colHelper = colHelper == null ? this._spreadsheet.getColumnPosition(sheet) : colHelper;
            for (SChart chartX : charts) {
                ViewAnchor anchor = chartX.getAnchor();
                ViewAnchor rightBottomAnchor = anchor.getRightBottomAnchor(sheet);
                if (anchor.getColumnIndex() < left && rightBottomAnchor.getColumnIndex() < right) continue;
                if (anchor.getColumnIndex() == left && chartX.isSparkline()) {
                    int width = 0;
                    for (int i = left; i <= right; ++i) {
                        width += sheet.getColumn(i).getWidth();
                    }
                    anchor.setWidth(width - 4);
                }
                this.updateColumnAnchor(sheet, anchor, colHelper, left, right);
                this.updateChartWidget(sheet, chartX);
            }
        }
        for (Runnable callback : this._colResetCallbacks.get()) {
            callback.run();
        }
        this._colResetCallbacks = null;
    }

    public void onRowChange(SSheet sheet, int top, int bottom) {
        List charts;
        List pictures = sheet.getPictures();
        HeaderPositionHelper rowHelper = null;
        this._rowResetCallbacks = ThreadLocal.withInitial(ArrayList::new);
        if (pictures != null && !pictures.isEmpty()) {
            rowHelper = this._spreadsheet.getRowPosition(sheet);
            for (SPicture picture : pictures) {
                ViewAnchor anchor = picture.getAnchor();
                ViewAnchor rightBottomAnchor = anchor.getRightBottomAnchor(sheet);
                if (anchor.getRowIndex() < top && rightBottomAnchor.getRowIndex() < bottom) continue;
                this.updateRowAnchor(sheet, anchor, rowHelper, top, bottom);
                this.updatePictureWidget(sheet, picture);
            }
        }
        if ((charts = sheet.getCharts()) != null && !charts.isEmpty()) {
            rowHelper = rowHelper == null ? this._spreadsheet.getRowPosition(sheet) : rowHelper;
            for (SChart chartX : charts) {
                ViewAnchor anchor = chartX.getAnchor();
                ViewAnchor rightBottomAnchor = anchor.getRightBottomAnchor(sheet);
                if (anchor.getRowIndex() < top && rightBottomAnchor.getRowIndex() < bottom) continue;
                if (anchor.getRowIndex() == top && chartX.isSparkline()) {
                    int height = 0;
                    boolean isHidden = true;
                    for (int i = top; i <= bottom; ++i) {
                        SRow row = sheet.getRow(i);
                        if (row.isHidden()) continue;
                        isHidden = false;
                        height += row.getHeight();
                    }
                    anchor.setHeight(isHidden ? 0 : height - 4);
                }
                this.updateRowAnchor(sheet, anchor, rowHelper, top, bottom);
                this.updateChartWidget(sheet, chartX);
            }
        }
        for (Runnable callback : this._rowResetCallbacks.get()) {
            callback.run();
        }
        this._rowResetCallbacks = null;
    }

    private void updateColumnAnchor(SSheet sheet, ViewAnchor anchor, HeaderPositionHelper colHelper, int left, int right) {
        ViewAnchor rightBottomAnchor = anchor.getRightBottomAnchor(sheet);
        switch (anchor.getAnchorType()) {
            case DONT_MOVE_AND_RESIZE: 
            case DONT_MOVE_DO_RESIZE: {
                int diff;
                if (left <= anchor.getColumnIndex() && ((diff = this.getDiffOfResizeColumn(sheet, anchor, rightBottomAnchor, colHelper, left, anchor.getColumnIndex(), true)) > 0 && left < anchor.getColumnIndex() || diff < 0)) {
                    int oldStartPixel = colHelper.getStartPixel(anchor.getColumnIndex());
                    int oldStartLeft = oldStartPixel + anchor.getXOffset() - (left == anchor.getColumnIndex() ? Math.max(diff, 0) : diff);
                    int cellIndex = colHelper.getCellIndex(oldStartLeft);
                    anchor.setColumnIndex(cellIndex);
                    int newStartPixel = colHelper.getStartPixel(cellIndex);
                    anchor.setXOffset(Math.max(0, oldStartLeft - newStartPixel));
                }
                if (anchor.getAnchorType() != ViewAnchor.AnchorType.DONT_MOVE_DO_RESIZE) break;
                anchor.setWidth(Math.max(0, anchor.getWidth() + this.getDiffOfResizeColumn(sheet, anchor, rightBottomAnchor, colHelper, left, right, false)));
                break;
            }
            case MOVE_AND_RESIZE: {
                anchor.setWidth(Math.max(0, anchor.getWidth() + this.getDiffOfResizeColumn(sheet, anchor, rightBottomAnchor, colHelper, left, right, false)));
                break;
            }
        }
    }

    private int getDiffOfResizeColumn(SSheet sheet, ViewAnchor anchor, ViewAnchor rightBottomAnchor, HeaderPositionHelper colHelper, int left, int right, boolean forceToDiffAll) {
        int diff = 0;
        for (int start = left; start <= right; ++start) {
            SColumnArray columnArray;
            if (!forceToDiffAll && start < anchor.getColumnIndex() || !((columnArray = sheet.getColumnArray(start)) instanceof ColumnArrayImpl)) continue;
            ColumnArrayImpl colImpl = (ColumnArrayImpl)columnArray;
            Map updates = colImpl.getUpdates();
            if (!updates.isEmpty()) {
                Boolean lastHidden = (Boolean)updates.get("hidden");
                if (lastHidden != null) {
                    diff = rightBottomAnchor.getColumnIndex() == right ? (diff += (lastHidden != false ? 1 : -1) * rightBottomAnchor.getXOffset()) : (diff += (lastHidden != false ? 1 : -1) * colImpl.getWidth());
                } else {
                    Boolean lastCustomWidth = (Boolean)updates.get("customWidth");
                    if (lastCustomWidth != null) {
                        Integer lastWidth = Optional.ofNullable(updates.get("width")).orElse(colHelper.getDefaultSize());
                        if (rightBottomAnchor.getColumnIndex() == right) {
                            int diffOffset = colImpl.getWidth() - lastWidth;
                            if (diffOffset > 0) {
                                diff += diffOffset;
                            } else if (diffOffset < 0) {
                                diff += Math.min(colImpl.getWidth() - rightBottomAnchor.getXOffset(), 0);
                            }
                        } else {
                            diff = rightBottomAnchor.getColumnIndex() - 1 == right ? (lastWidth - colImpl.getWidth() > rightBottomAnchor.getXOffset() ? (diff -= rightBottomAnchor.getXOffset()) : (diff += colImpl.getWidth() - lastWidth)) : (diff += colImpl.getWidth() - lastWidth);
                        }
                    }
                }
            }
            if (this._colResetCallbacks != null) {
                this._colResetCallbacks.get().add(() -> ((ColumnArrayImpl)colImpl).resetUpdates());
                continue;
            }
            colImpl.resetUpdates();
        }
        return diff;
    }

    private int getDiffOfResizeRow(SSheet sheet, ViewAnchor anchor, ViewAnchor rightBottomAnchor, HeaderPositionHelper rowHelper, int top, int bottom, boolean forceToDiffAll) {
        int diff = 0;
        for (int start = top; start <= bottom; ++start) {
            SRow row;
            if (!forceToDiffAll && start < anchor.getRowIndex() || !((row = sheet.getRow(start)) instanceof RowImpl)) continue;
            RowImpl rowImpl = (RowImpl)row;
            Map updates = rowImpl.getUpdates();
            if (!updates.isEmpty()) {
                Boolean lastHidden = (Boolean)updates.get("hidden");
                if (lastHidden != null) {
                    diff = rightBottomAnchor.getRowIndex() == bottom ? (diff += (lastHidden != false ? 1 : -1) * rightBottomAnchor.getYOffset()) : (diff += (lastHidden != false ? 1 : -1) * rowImpl.getHeight());
                } else {
                    Boolean lastCustomHeight = (Boolean)updates.get("customHeight");
                    if (lastCustomHeight != null) {
                        Integer lastHeight = Optional.ofNullable(updates.get("height")).orElse(rowHelper.getDefaultSize());
                        if (rightBottomAnchor.getRowIndex() == bottom) {
                            int diffOffset = rowImpl.getHeight() - lastHeight;
                            if (diffOffset > 0) {
                                diff += diffOffset;
                            } else if (diffOffset < 0) {
                                diff += Math.min(rowImpl.getHeight() - rightBottomAnchor.getYOffset(), 0);
                            }
                        } else {
                            diff = rightBottomAnchor.getRowIndex() - 1 == bottom ? (lastHeight - rowImpl.getHeight() > rightBottomAnchor.getYOffset() ? (diff -= rightBottomAnchor.getYOffset()) : (diff += rowImpl.getHeight() - lastHeight)) : (diff += rowImpl.getHeight() - lastHeight);
                        }
                    }
                }
            }
            if (this._rowResetCallbacks != null) {
                this._rowResetCallbacks.get().add(() -> ((RowImpl)rowImpl).resetUpdates());
                continue;
            }
            rowImpl.resetUpdates();
        }
        return diff;
    }

    private void updateRowAnchor(SSheet sheet, ViewAnchor anchor, HeaderPositionHelper rowHelper, int top, int bottom) {
        ViewAnchor rightBottomAnchor = anchor.getRightBottomAnchor(sheet);
        switch (anchor.getAnchorType()) {
            case DONT_MOVE_AND_RESIZE: 
            case DONT_MOVE_DO_RESIZE: {
                int diff;
                if (top <= anchor.getRowIndex() && ((diff = this.getDiffOfResizeRow(sheet, anchor, rightBottomAnchor, rowHelper, top, anchor.getRowIndex(), true)) > 0 && top < anchor.getRowIndex() || diff < 0)) {
                    int oldStartPixel = rowHelper.getStartPixel(anchor.getRowIndex());
                    int oldStartTop = oldStartPixel + anchor.getYOffset() - (top == anchor.getRowIndex() ? Math.max(diff, 0) : diff);
                    int cellIndex = rowHelper.getCellIndex(oldStartTop);
                    anchor.setRowIndex(cellIndex);
                    int newStartPixel = rowHelper.getStartPixel(cellIndex);
                    anchor.setYOffset(Math.max(0, oldStartTop - newStartPixel));
                }
                if (anchor.getAnchorType() != ViewAnchor.AnchorType.DONT_MOVE_DO_RESIZE) break;
                anchor.setHeight(Math.max(0, anchor.getHeight() + this.getDiffOfResizeRow(sheet, anchor, rightBottomAnchor, rowHelper, top, bottom, false)));
                break;
            }
            case MOVE_AND_RESIZE: {
                anchor.setHeight(Math.max(0, anchor.getHeight() + this.getDiffOfResizeRow(sheet, anchor, rightBottomAnchor, rowHelper, top, bottom, false)));
                break;
            }
        }
    }

    public void onResetSparklineAnchor(SSheet sheet, CellRegion region) {
        List charts = sheet.getCharts();
        if (charts != null) {
            for (SChart chartX : charts) {
                int col;
                ViewAnchor anchor;
                int row;
                if (!chartX.isSparkline() || !region.contains(row = (anchor = chartX.getAnchor()).getRowIndex(), col = anchor.getColumnIndex())) continue;
                anchor.setWidth(sheet.getColumn(col).getWidth() - 4);
                anchor.setHeight(sheet.getRow(row).getHeight() - 4);
                this.updateChartWidget(sheet, chartX);
            }
        }
    }

    public void onRowColumnChange(SSheet sheet, CellRegion region) {
        int left = region.column;
        int right = region.lastColumn;
        int top = region.row;
        int bottom = region.lastRow;
        List charts = sheet.getCharts();
        if (charts != null) {
            for (SChart chartX : charts) {
                if (!chartX.isSparkline()) continue;
                ViewAnchor anchor = chartX.getAnchor();
                int columnIndex = anchor.getColumnIndex();
                int rowIndex = anchor.getRowIndex();
                if (columnIndex == left && rowIndex == top) {
                    int width = 0;
                    for (int i = left; i <= right; ++i) {
                        width += sheet.getColumn(i).getWidth();
                    }
                    anchor.setWidth(width - 4);
                    int height = 0;
                    for (int i = top; i <= bottom; ++i) {
                        height += sheet.getRow(i).getHeight();
                    }
                    anchor.setHeight(height - 4);
                    this.updateChartWidget(sheet, chartX);
                    continue;
                }
                if (!region.contains(anchor.getRowIndex(), anchor.getColumnIndex())) continue;
                this.deleteChartWidget(sheet, chartX.getId());
            }
        }
    }

    private void preparePictureWidgets(SSheet sheet, Map<String, List<Widget>> widgets) {
        List pictures = sheet.getPictures();
        if (pictures == null || pictures.size() == 0) {
            return;
        }
        int zindex = 200 + widgets.size();
        for (SPicture picture : pictures) {
            List<Widget> imagewgts = this.newImageWidgetGroup(sheet, picture, zindex++);
            if (imagewgts == null || imagewgts.size() <= 0) continue;
            widgets.put(picture.getId(), imagewgts);
            for (Widget w : imagewgts) {
                ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).addWidget(w);
            }
        }
    }

    private void prepareChartWidgets(SSheet sheet, Map<String, List<Widget>> widgets) {
        List charts = sheet.getCharts();
        if (charts == null || charts.size() == 0) {
            return;
        }
        int zindex = 200 + widgets.size();
        for (SChart chartX : charts) {
            try {
                List<Widget> chartwgts;
                if ((chartwgts = this.newChartWidgetGroup(sheet, chartX, zindex++)) == null || chartwgts.size() <= 0) continue;
                widgets.put(chartX.getId(), chartwgts);
                for (Widget w : chartwgts) {
                    ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).addWidget(w);
                }
            }
            catch (IOException e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
    }

    public void addChartWidget(SSheet sheet, SChart chart) {
        String key = sheet.getId();
        Map<String, List<Widget>> existingWidgets = this._widgetMap.get(key);
        if (existingWidgets == null) {
            existingWidgets = new LinkedHashMap<String, List<Widget>>();
        }
        if (existingWidgets.containsKey(chart.getId())) {
            return;
        }
        int zindex = 200 + existingWidgets.size();
        try {
            List<Widget> chartwgts = this.newChartWidgetGroup(sheet, chart, zindex);
            if (chartwgts != null && chartwgts.size() > 0) {
                existingWidgets.put(chart.getId(), chartwgts);
                for (Widget w : chartwgts) {
                    ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).addWidget(w);
                }
            }
        }
        catch (IOException e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        if (existingWidgets != null && existingWidgets.size() > 0) {
            this._widgetMap.put(key, existingWidgets);
        }
    }

    public void addPictureWidget(SSheet sheet, SPicture picture) {
        String key = sheet.getId();
        Map<String, List<Widget>> existingWidgets = this._widgetMap.get(key);
        if (existingWidgets == null) {
            existingWidgets = new LinkedHashMap<String, List<Widget>>();
        }
        if (existingWidgets.containsKey(picture.getId())) {
            return;
        }
        int zindex = 200 + existingWidgets.size();
        List<Widget> imagewgts = this.newImageWidgetGroup(sheet, picture, zindex);
        if (imagewgts != null && imagewgts.size() > 0) {
            existingWidgets.put(picture.getId(), imagewgts);
            for (Widget w : imagewgts) {
                ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).addWidget(w);
            }
        }
        if (existingWidgets != null && existingWidgets.size() > 0) {
            this._widgetMap.put(key, existingWidgets);
        }
    }

    public void deletePictureWidget(SSheet sheet, String pictureId) {
        String key = sheet.getId();
        Map<String, List<Widget>> widgets = this._widgetMap.get(key);
        if (widgets == null) {
            return;
        }
        List<Widget> imagewgts = widgets.remove(pictureId);
        if (imagewgts != null) {
            for (Widget w : imagewgts) {
                ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).removeWidget(w);
            }
        }
    }

    private List<String> getEffectedPanels(SSheet sheet, ViewAnchor anchor) {
        int fr = sheet.getViewInfo().getNumOfRowFreeze();
        int fc = sheet.getViewInfo().getNumOfColumnFreeze();
        ArrayList<String> panels = new ArrayList<String>();
        panels.add("default");
        if (fr > 0 && anchor.getRowIndex() < fr) {
            panels.add("top");
        }
        if (fc > 0 && anchor.getColumnIndex() < fc) {
            panels.add("left");
        }
        if (fc > 0 && fc > 0 && anchor.getRowIndex() < fr && anchor.getColumnIndex() < fc) {
            panels.add("corner");
        }
        return panels;
    }

    public void updatePictureWidget(SSheet sheet, SPicture picture) {
        String key = sheet.getId();
        Map<String, List<Widget>> widgets = this._widgetMap.get(key);
        if (widgets == null) {
            return;
        }
        List<Widget> imagewgts = widgets.get(picture.getId());
        if (imagewgts == null) {
            return;
        }
        ViewAnchor anchor = picture.getAnchor();
        Image pimage = null;
        int zindex = 200 + widgets.size();
        List<String> panels = this.getEffectedPanels(sheet, anchor);
        ArrayList<String> newadd = new ArrayList<String>(panels);
        for (Widget w : new ArrayList<Widget>(imagewgts)) {
            if (panels.contains(w.getPanel())) {
                pimage = ((ImageWidget)w).getContent();
                zindex = w.getZindex();
                this.setupImageWigetAnchor(sheet, (ImageWidget)w, anchor, zindex);
                newadd.remove(w.getPanel());
                continue;
            }
            imagewgts.remove(w);
            ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).removeWidget(w);
        }
        for (String p : newadd) {
            Widget w = this.newImageWidget(sheet, picture, pimage, p, zindex);
            imagewgts.add(w);
            ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).addWidget(w);
        }
    }

    private void setupImageWigetAnchor(SSheet sheet, ImageWidget imagewgt, ViewAnchor anchor, int zindex) {
        if (anchor != null) {
            int row = anchor.getRowIndex();
            int col = anchor.getColumnIndex();
            int height = anchor.getHeight();
            int width = anchor.getWidth();
            int left = anchor.getXOffset();
            int top = anchor.getYOffset();
            imagewgt.setRow(row);
            imagewgt.setColumn(col);
            imagewgt.setZindex(zindex);
            imagewgt.setWidth(width + "px");
            imagewgt.setHeight(height + "px");
            imagewgt.setLeft(left - 1);
            imagewgt.setTop(top - 1);
            imagewgt.adjustLocation();
            this.syncAnchorType(imagewgt, anchor.getAnchorType());
        }
    }

    private void syncAnchorType(BaseWidget widget, ViewAnchor.AnchorType anchorType) {
        switch (anchorType) {
            case DONT_MOVE_AND_RESIZE: {
                widget.setMovable(false);
                widget.setSizable(false);
                break;
            }
            case DONT_MOVE_DO_RESIZE: {
                widget.setMovable(false);
                widget.setSizable(true);
                break;
            }
            case MOVE_AND_RESIZE: {
                widget.setMovable(true);
                widget.setSizable(true);
                break;
            }
            case MOVE_DONT_RESIZE: {
                widget.setMovable(true);
                widget.setSizable(false);
            }
        }
    }

    private void setupChartWigetAnchor(SSheet sheet, ChartsWidget chartwgt, ViewAnchor anchor, int zindex) {
        if (anchor != null) {
            int row = anchor.getRowIndex();
            int col = anchor.getColumnIndex();
            int height = anchor.getHeight();
            int width = anchor.getWidth();
            int left = anchor.getXOffset();
            int top = anchor.getYOffset();
            chartwgt.setRow(row);
            chartwgt.setColumn(col);
            chartwgt.setZindex(zindex);
            chartwgt.setHeight(height);
            chartwgt.setWidth(width);
            chartwgt.getInnerComponent().setVisible(width != 0 && height != 0);
            chartwgt.setLeft(left - 1);
            chartwgt.setTop(top - 1);
            chartwgt.adjustLocation();
            this.syncAnchorType(chartwgt, anchor.getAnchorType());
        }
    }

    protected List<Widget> newImageWidgetGroup(SSheet sheet, SPicture picture, int zindex) {
        byte[] picdata = picture.getData();
        if (picdata == null) {
            return null;
        }
        ViewAnchor anchor = picture.getAnchor();
        List<String> panels = this.getEffectedPanels(sheet, anchor);
        Image pimage = null;
        ArrayList<Widget> widgets = new ArrayList<Widget>(panels.size());
        for (String p : panels) {
            Widget imagewgt = this.newImageWidget(sheet, picture, pimage, p, zindex);
            widgets.add(imagewgt);
            pimage = ((ImageWidget)imagewgt).getContent();
        }
        return widgets;
    }

    protected Widget newImageWidget(SSheet sheet, SPicture picture, Image image, String panel, int zindex) {
        byte[] picdata = picture.getData();
        if (picdata == null && image == null) {
            return null;
        }
        ViewAnchor anchor = picture.getAnchor();
        ImageWidget imagewgt = new ImageWidget(sheet, picture, panel);
        Image img = image != null ? image : this.getAImage(sheet, picture);
        imagewgt.setContent(img);
        this.setupImageWigetAnchor(sheet, imagewgt, anchor, zindex);
        return imagewgt;
    }

    private AImage getAImage(SSheet sheet, SPicture picture) {
        try {
            String name = picture.getId() + "." + picture.getFormat().getFileExtension();
            return new AImage(name, picture.getData());
        }
        catch (IOException e) {
            log.warn(e.toString());
            return null;
        }
    }

    protected List<Widget> newChartWidgetGroup(SSheet sheet, SChart chart, int zindex) throws IOException {
        List<String> panels = this.getEffectedPanels(sheet, chart.getAnchor());
        ArrayList<Widget> widgets = new ArrayList<Widget>(panels.size());
        for (String p : panels) {
            Widget chartwgt = this.newChartWidget(sheet, chart, p, zindex);
            widgets.add(chartwgt);
        }
        return widgets;
    }

    protected Widget newChartWidget(SSheet sheet, SChart chart, String panel, int zindex) {
        ChartsWidget widget = new ChartsWidget(sheet, chart, panel, zindex);
        ViewAnchor anchor = chart.getAnchor();
        if (chart.isSparkline()) {
            anchor.setAnchorType(ViewAnchor.AnchorType.DONT_MOVE_DO_RESIZE);
        }
        this.setupChartWigetAnchor(sheet, widget, anchor, zindex);
        return widget;
    }

    public void updateChartWidget(SSheet sheet, SChart chart) {
        String key = sheet.getId();
        Map<String, List<Widget>> widgets = this._widgetMap.get(key);
        if (widgets == null) {
            return;
        }
        List<Widget> chartwgts = widgets.get(chart.getId());
        if (chartwgts == null) {
            return;
        }
        ViewAnchor anchor = chart.getAnchor();
        int zindex = 200 + widgets.size();
        List<String> panels = this.getEffectedPanels(sheet, anchor);
        ArrayList<String> newadd = new ArrayList<String>(panels);
        for (Widget w : new ArrayList<Widget>(chartwgts)) {
            if (panels.contains(w.getPanel())) {
                this.setupChartWigetAnchor(sheet, (ChartsWidget)w, anchor, w.getZindex());
                ((ChartsWidget)w).updateName();
                newadd.remove(w.getPanel());
                continue;
            }
            chartwgts.remove(w);
            ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).removeWidget(w);
        }
        for (String p : newadd) {
            Widget w = this.newChartWidget(sheet, chart, p, zindex);
            chartwgts.add(w);
            ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).addWidget(w);
        }
    }

    public void deleteChartWidget(SSheet sheet, String chartId) {
        String key = sheet.getId();
        Map<String, List<Widget>> widgets = this._widgetMap.get(key);
        if (widgets == null) {
            return;
        }
        List<Widget> chartwgts = widgets.remove(chartId);
        if (chartwgts == null) {
            return;
        }
        for (Widget w : chartwgts) {
            ((SpreadsheetCtrl)this._spreadsheet.getExtraCtrl()).removeWidget(w);
        }
    }
}

